/*
 * Copyright (C) 2014 The Android Open Source Project
 * Copyright (c) 1995, 2008, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */


package java.io;


/**
 * Signals that an I/O operation has been interrupted. An
 * <code>InterruptedIOException</code> is thrown to indicate that an
 * input or output transfer has been terminated because the thread
 * performing it was interrupted. The field {@link #bytesTransferred}
 * indicates how many bytes were successfully transferred before
 * the interruption occurred.
 *
 * @author  unascribed
 * @see     java.io.InputStream
 * @see     java.io.OutputStream
 * @see     java.lang.Thread#interrupt()
 * @since   JDK1.0
 * @apiSince 1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class InterruptedIOException extends java.io.IOException {

/**
 * Constructs an <code>InterruptedIOException</code> with
 * <code>null</code> as its error detail message.
 * @apiSince 1
 */

public InterruptedIOException() { throw new RuntimeException("Stub!"); }

/**
 * Constructs an <code>InterruptedIOException</code> with the
 * specified detail message. The string <code>s</code> can be
 * retrieved later by the
 * <code>{@link java.lang.Throwable#getMessage}</code>
 * method of class <code>java.lang.Throwable</code>.
 *
 * @param   s   the detail message.
 * @apiSince 1
 */

public InterruptedIOException(java.lang.String s) { throw new RuntimeException("Stub!"); }

/**
 * Reports how many bytes had been transferred as part of the I/O
 * operation before it was interrupted.
 *
 * @serial
 * @apiSince 1
 */

public int bytesTransferred = 0; // 0x0
}

