/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.text.method;


/**
 * For numeric text entry
 * <p></p>
 * As for all implementations of {@link KeyListener}, this class is only concerned
 * with hardware keyboards.  Software input methods have no obligation to trigger
 * the methods in this class.
 * @apiSince 1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class NumberKeyListener extends android.text.method.BaseKeyListener implements android.text.InputFilter {

public NumberKeyListener() { throw new RuntimeException("Stub!"); }

/**
 * You can say which characters you can accept.
 
 * @return This value will never be {@code null}.
 * @apiSince 1
 */

@android.annotation.NonNull
protected abstract char[] getAcceptedChars();

/** @apiSince 1 */

protected int lookup(android.view.KeyEvent event, android.text.Spannable content) { throw new RuntimeException("Stub!"); }

/** @apiSince 1 */

public java.lang.CharSequence filter(java.lang.CharSequence source, int start, int end, android.text.Spanned dest, int dstart, int dend) { throw new RuntimeException("Stub!"); }

/** @apiSince 1 */

protected static boolean ok(char[] accept, char c) { throw new RuntimeException("Stub!"); }

/** @apiSince 1 */

public boolean onKeyDown(android.view.View view, android.text.Editable content, int keyCode, android.view.KeyEvent event) { throw new RuntimeException("Stub!"); }
}

