
 /**
 * <p>
 * Provides classes for implementing print services. Print services are plug-in components
 * that know how to talk to printers via some standard protocols. These services serve as a
 * bridge between the system and the printers. Hence, the printer and print protocol specific
 * implementation is factored out of the system and can be independently developed and updated.
 * </p>
 * <p>
 * A print service implementation should extend {@link android.printservice.PrintService}
 * and implement its abstract methods. Also the print service has to follow the contract for
 * managing {@link android.printservice.PrintJob}s.
 * <p/>
 * <p>
 * The system is responsible for starting and stopping a print service depending on whether
 * there are active print jobs for the printers managed by the service. The print service
 * should also perform printer discovery in a timely fashion to ensure good user experience.
 * The interaction between the system and the print service during printer discovery is
 * encapsulated by a {@link android.printservice.PrinterDiscoverySession} instance created
 * by the print service when requested by the system.
 * </p>
 @apiSince 19
 */

package android.printservice;
