/*
 * Copyright (C) 2009 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.os;


/**
 * Generic interface for receiving a callback result from someone.  Use this
 * by creating a subclass and implement {@link #onReceiveResult}, which you can
 * then pass to others and send through IPC, and receive results they
 * supply with {@link #send}.
 *
 * <p>Note: the implementation underneath is just a simple wrapper around
 * a {@link Binder} that is used to perform the communication.  This means
 * semantically you should treat it as such: this class does not impact process
 * lifecycle management (you must be using some higher-level component to tell
 * the system that your process needs to continue running), the connection will
 * break if your process goes away for any reason, etc.</p>
 * @apiSince 3
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class ResultReceiver implements android.os.Parcelable {

/**
 * Create a new ResultReceive to receive results.  Your
 * {@link #onReceiveResult} method will be called from the thread running
 * <var>handler</var> if given, or from an arbitrary thread if null.
 * @apiSince 3
 */

public ResultReceiver(android.os.Handler handler) { throw new RuntimeException("Stub!"); }

/**
 * Deliver a result to this receiver.  Will call {@link #onReceiveResult},
 * always asynchronously if the receiver has supplied a Handler in which
 * to dispatch the result.
 * @param resultCode Arbitrary result code to deliver, as defined by you.
 * @param resultData Any additional data provided by you.
 * @apiSince 3
 */

public void send(int resultCode, android.os.Bundle resultData) { throw new RuntimeException("Stub!"); }

/**
 * Override to receive results delivered to this object.
 *
 * @param resultCode Arbitrary result code delivered by the sender, as
 * defined by the sender.
 * @param resultData Any additional data provided by the sender.
 * @apiSince 3
 */

protected void onReceiveResult(int resultCode, android.os.Bundle resultData) { throw new RuntimeException("Stub!"); }

/** @apiSince 3 */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** @apiSince 3 */

public void writeToParcel(android.os.Parcel out, int flags) { throw new RuntimeException("Stub!"); }

/** @apiSince 3 */

@androidx.annotation.RecentlyNonNull public static final android.os.Parcelable.Creator<android.os.ResultReceiver> CREATOR;
static { CREATOR = null; }
}

