/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.location;

import android.os.SystemClock;
import android.os.Bundle;

/**
 * A data class representing a geographic location.
 *
 * <p>A location can consist of a latitude, longitude, timestamp,
 * and other information such as bearing, altitude and velocity.
 *
 * <p>All locations generated by the {@link LocationManager} are
 * guaranteed to have a valid latitude, longitude, and timestamp
 * (both UTC time and elapsed real-time since boot), all other
 * parameters are optional.
 * @apiSince 1
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class Location implements android.os.Parcelable {

/**
 * Construct a new Location with a named provider.
 *
 * <p>By default time, latitude and longitude are 0, and the location
 * has no bearing, altitude, speed, accuracy or extras.
 *
 * @param provider the name of the provider that generated this location
 * @apiSince 1
 */

public Location(java.lang.String provider) { throw new RuntimeException("Stub!"); }

/**
 * Construct a new Location object that is copied from an existing one.
 * @apiSince 1
 */

public Location(android.location.Location l) { throw new RuntimeException("Stub!"); }

/**
 * Sets the contents of the location to the values from the given location.
 * @apiSince 1
 */

public void set(android.location.Location l) { throw new RuntimeException("Stub!"); }

/**
 * Clears the contents of the location.
 * @apiSince 1
 */

public void reset() { throw new RuntimeException("Stub!"); }

/**
 * Converts a coordinate to a String representation. The outputType
 * may be one of FORMAT_DEGREES, FORMAT_MINUTES, or FORMAT_SECONDS.
 * The coordinate must be a valid double between -180.0 and 180.0.
 * This conversion is performed in a method that is dependent on the
 * default locale, and so is not guaranteed to round-trip with
 * {@link #convert(String)}.
 *
 * @throws IllegalArgumentException if coordinate is less than
 * -180.0, greater than 180.0, or is not a number.
 * @throws IllegalArgumentException if outputType is not one of
 * FORMAT_DEGREES, FORMAT_MINUTES, or FORMAT_SECONDS.
 * @apiSince 1
 */

public static java.lang.String convert(double coordinate, int outputType) { throw new RuntimeException("Stub!"); }

/**
 * Converts a String in one of the formats described by
 * FORMAT_DEGREES, FORMAT_MINUTES, or FORMAT_SECONDS into a
 * double. This conversion is performed in a locale agnostic
 * method, and so is not guaranteed to round-trip with
 * {@link #convert(double, int)}.
 *
 * @throws NullPointerException if coordinate is null
 * @throws IllegalArgumentException if the coordinate is not
 * in one of the valid formats.
 * @apiSince 1
 */

public static double convert(java.lang.String coordinate) { throw new RuntimeException("Stub!"); }

/**
 * Computes the approximate distance in meters between two
 * locations, and optionally the initial and final bearings of the
 * shortest path between them.  Distance and bearing are defined using the
 * WGS84 ellipsoid.
 *
 * <p> The computed distance is stored in results[0].  If results has length
 * 2 or greater, the initial bearing is stored in results[1]. If results has
 * length 3 or greater, the final bearing is stored in results[2].
 *
 * @param startLatitude the starting latitude
 * @param startLongitude the starting longitude
 * @param endLatitude the ending latitude
 * @param endLongitude the ending longitude
 * @param results an array of floats to hold the results
 *
 * @throws IllegalArgumentException if results is null or has length < 1
 * @apiSince 1
 */

public static void distanceBetween(double startLatitude, double startLongitude, double endLatitude, double endLongitude, float[] results) { throw new RuntimeException("Stub!"); }

/**
 * Returns the approximate distance in meters between this
 * location and the given location.  Distance is defined using
 * the WGS84 ellipsoid.
 *
 * @param dest the destination location
 * @return the approximate distance in meters
 * @apiSince 1
 */

public float distanceTo(android.location.Location dest) { throw new RuntimeException("Stub!"); }

/**
 * Returns the approximate initial bearing in degrees East of true
 * North when traveling along the shortest path between this
 * location and the given location.  The shortest path is defined
 * using the WGS84 ellipsoid.  Locations that are (nearly)
 * antipodal may produce meaningless results.
 *
 * @param dest the destination location
 * @return the initial bearing in degrees
 * @apiSince 1
 */

public float bearingTo(android.location.Location dest) { throw new RuntimeException("Stub!"); }

/**
 * Returns the name of the provider that generated this fix.
 *
 * @return the provider, or null if it has not been set
 * @apiSince 1
 */

public java.lang.String getProvider() { throw new RuntimeException("Stub!"); }

/**
 * Sets the name of the provider that generated this fix.
 * @apiSince 1
 */

public void setProvider(java.lang.String provider) { throw new RuntimeException("Stub!"); }

/**
 * Return the UTC time of this fix, in milliseconds since January 1, 1970.
 *
 * <p>Note that the UTC time on a device is not monotonic: it
 * can jump forwards or backwards unpredictably. So always use
 * {@link #getElapsedRealtimeNanos} when calculating time deltas.
 *
 * <p>On the other hand, {@link #getTime} is useful for presenting
 * a human readable time to the user, or for carefully comparing
 * location fixes across reboot or across devices.
 *
 * <p>All locations generated by the {@link LocationManager}
 * are guaranteed to have a valid UTC time, however remember that
 * the system time may have changed since the location was generated.
 *
 * @return time of fix, in milliseconds since January 1, 1970.
 * @apiSince 1
 */

public long getTime() { throw new RuntimeException("Stub!"); }

/**
 * Set the UTC time of this fix, in milliseconds since January 1,
 * 1970.
 *
 * @param time UTC time of this fix, in milliseconds since January 1, 1970
 * @apiSince 1
 */

public void setTime(long time) { throw new RuntimeException("Stub!"); }

/**
 * Return the time of this fix, in elapsed real-time since system boot.
 *
 * <p>This value can be reliably compared to
 * {@link android.os.SystemClock#elapsedRealtimeNanos},
 * to calculate the age of a fix and to compare Location fixes. This
 * is reliable because elapsed real-time is guaranteed monotonic for
 * each system boot and continues to increment even when the system
 * is in deep sleep (unlike {@link #getTime}.
 *
 * <p>All locations generated by the {@link LocationManager}
 * are guaranteed to have a valid elapsed real-time.
 *
 * @return elapsed real-time of fix, in nanoseconds since system boot.
 * @apiSince 17
 */

public long getElapsedRealtimeNanos() { throw new RuntimeException("Stub!"); }

/**
 * Set the time of this fix, in elapsed real-time since system boot.
 *
 * @param time elapsed real-time of fix, in nanoseconds since system boot.
 * @apiSince 17
 */

public void setElapsedRealtimeNanos(long time) { throw new RuntimeException("Stub!"); }

/**
 * Get estimate of the relative precision of the alignment of the
 * ElapsedRealtimeNanos timestamp, with the reported measurements in
 * nanoseconds (68% confidence).
 *
 * This means that we have 68% confidence that the true timestamp of the
 * event is within ElapsedReatimeNanos +/- uncertainty.
 *
 * Example :
 *   - getElapsedRealtimeNanos() returns 10000000
 *   - getElapsedRealtimeUncertaintyNanos() returns 1000000 (equivalent to 1millisecond)
 *   This means that the event most likely happened between 9000000 and 11000000.
 *
 * @return uncertainty of elapsed real-time of fix, in nanoseconds.
 * @apiSince 29
 */

public double getElapsedRealtimeUncertaintyNanos() { throw new RuntimeException("Stub!"); }

/**
 * Set estimate of the relative precision of the alignment of the
 * ElapsedRealtimeNanos timestamp, with the reported measurements in
 * nanoseconds (68% confidence).
 *
 * @param time uncertainty of the elapsed real-time of fix, in nanoseconds.
 * @apiSince 29
 */

public void setElapsedRealtimeUncertaintyNanos(double time) { throw new RuntimeException("Stub!"); }

/**
 * True if this location has a elapsed realtime accuracy.
 * @apiSince 29
 */

public boolean hasElapsedRealtimeUncertaintyNanos() { throw new RuntimeException("Stub!"); }

/**
 * Get the latitude, in degrees.
 *
 * <p>All locations generated by the {@link LocationManager}
 * will have a valid latitude.
 * @apiSince 1
 */

public double getLatitude() { throw new RuntimeException("Stub!"); }

/**
 * Set the latitude, in degrees.
 * @apiSince 1
 */

public void setLatitude(double latitude) { throw new RuntimeException("Stub!"); }

/**
 * Get the longitude, in degrees.
 *
 * <p>All locations generated by the {@link LocationManager}
 * will have a valid longitude.
 * @apiSince 1
 */

public double getLongitude() { throw new RuntimeException("Stub!"); }

/**
 * Set the longitude, in degrees.
 * @apiSince 1
 */

public void setLongitude(double longitude) { throw new RuntimeException("Stub!"); }

/**
 * True if this location has an altitude.
 * @apiSince 1
 */

public boolean hasAltitude() { throw new RuntimeException("Stub!"); }

/**
 * Get the altitude if available, in meters above the WGS 84 reference
 * ellipsoid.
 *
 * <p>If this location does not have an altitude then 0.0 is returned.
 * @apiSince 1
 */

public double getAltitude() { throw new RuntimeException("Stub!"); }

/**
 * Set the altitude, in meters above the WGS 84 reference ellipsoid.
 *
 * <p>Following this call {@link #hasAltitude} will return true.
 * @apiSince 1
 */

public void setAltitude(double altitude) { throw new RuntimeException("Stub!"); }

/**
 * Remove the altitude from this location.
 *
 * <p>Following this call {@link #hasAltitude} will return false,
 * and {@link #getAltitude} will return 0.0.
 *
 * @deprecated use a new Location object for location updates.
 * @apiSince 1
 * @deprecatedSince 26
 */

@Deprecated
public void removeAltitude() { throw new RuntimeException("Stub!"); }

/**
 * True if this location has a speed.
 * @apiSince 1
 */

public boolean hasSpeed() { throw new RuntimeException("Stub!"); }

/**
 * Get the speed if it is available, in meters/second over ground.
 *
 * <p>If this location does not have a speed then 0.0 is returned.
 * @apiSince 1
 */

public float getSpeed() { throw new RuntimeException("Stub!"); }

/**
 * Set the speed, in meters/second over ground.
 *
 * <p>Following this call {@link #hasSpeed} will return true.
 * @apiSince 1
 */

public void setSpeed(float speed) { throw new RuntimeException("Stub!"); }

/**
 * Remove the speed from this location.
 *
 * <p>Following this call {@link #hasSpeed} will return false,
 * and {@link #getSpeed} will return 0.0.
 *
 * @deprecated use a new Location object for location updates.
 * @apiSince 1
 * @deprecatedSince 26
 */

@Deprecated
public void removeSpeed() { throw new RuntimeException("Stub!"); }

/**
 * True if this location has a bearing.
 * @apiSince 1
 */

public boolean hasBearing() { throw new RuntimeException("Stub!"); }

/**
 * Get the bearing, in degrees.
 *
 * <p>Bearing is the horizontal direction of travel of this device,
 * and is not related to the device orientation. It is guaranteed to
 * be in the range (0.0, 360.0] if the device has a bearing.
 *
 * <p>If this location does not have a bearing then 0.0 is returned.
 * @apiSince 1
 */

public float getBearing() { throw new RuntimeException("Stub!"); }

/**
 * Set the bearing, in degrees.
 *
 * <p>Bearing is the horizontal direction of travel of this device,
 * and is not related to the device orientation.
 *
 * <p>The input will be wrapped into the range (0.0, 360.0].
 * @apiSince 1
 */

public void setBearing(float bearing) { throw new RuntimeException("Stub!"); }

/**
 * Remove the bearing from this location.
 *
 * <p>Following this call {@link #hasBearing} will return false,
 * and {@link #getBearing} will return 0.0.
 *
 * @deprecated use a new Location object for location updates.
 * @apiSince 1
 * @deprecatedSince 26
 */

@Deprecated
public void removeBearing() { throw new RuntimeException("Stub!"); }

/**
 * True if this location has a horizontal accuracy.
 *
 * <p>All locations generated by the {@link LocationManager} have an horizontal accuracy.
 * @apiSince 1
 */

public boolean hasAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Get the estimated horizontal accuracy of this location, radial, in meters.
 *
 * <p>We define horizontal accuracy as the radius of 68% confidence. In other
 * words, if you draw a circle centered at this location's
 * latitude and longitude, and with a radius equal to the accuracy,
 * then there is a 68% probability that the true location is inside
 * the circle.
 *
 * <p>This accuracy estimation is only concerned with horizontal
 * accuracy, and does not indicate the accuracy of bearing,
 * velocity or altitude if those are included in this Location.
 *
 * <p>If this location does not have a horizontal accuracy, then 0.0 is returned.
 * All locations generated by the {@link LocationManager} include horizontal accuracy.
 * @apiSince 1
 */

public float getAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Set the estimated horizontal accuracy of this location, meters.
 *
 * <p>See {@link #getAccuracy} for the definition of horizontal accuracy.
 *
 * <p>Following this call {@link #hasAccuracy} will return true.
 * @apiSince 1
 */

public void setAccuracy(float horizontalAccuracy) { throw new RuntimeException("Stub!"); }

/**
 * Remove the horizontal accuracy from this location.
 *
 * <p>Following this call {@link #hasAccuracy} will return false, and
 * {@link #getAccuracy} will return 0.0.
 *
 * @deprecated use a new Location object for location updates.
 * @apiSince 1
 * @deprecatedSince 26
 */

@Deprecated
public void removeAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * True if this location has a vertical accuracy.
 * @apiSince 26
 */

public boolean hasVerticalAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Get the estimated vertical accuracy of this location, in meters.
 *
 * <p>We define vertical accuracy at 68% confidence.  Specifically, as 1-side of the
 * 2-sided range above and below the estimated altitude reported by {@link #getAltitude()},
 * within which there is a 68% probability of finding the true altitude.
 *
 * <p>In the case where the underlying distribution is assumed Gaussian normal, this would be
 * considered 1 standard deviation.
 *
 * <p>For example, if {@link #getAltitude()} returns 150, and
 * {@link #getVerticalAccuracyMeters()} returns 20 then there is a 68% probability
 * of the true altitude being between 130 and 170 meters.
 *
 * <p>If this location does not have a vertical accuracy, then 0.0 is returned.
 * @apiSince 26
 */

public float getVerticalAccuracyMeters() { throw new RuntimeException("Stub!"); }

/**
 * Set the estimated vertical accuracy of this location, meters.
 *
 * <p>See {@link #getVerticalAccuracyMeters} for the definition of vertical accuracy.
 *
 * <p>Following this call {@link #hasVerticalAccuracy} will return true.
 * @apiSince 26
 */

public void setVerticalAccuracyMeters(float verticalAccuracyMeters) { throw new RuntimeException("Stub!"); }

/**
 * True if this location has a speed accuracy.
 * @apiSince 26
 */

public boolean hasSpeedAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Get the estimated speed accuracy of this location, in meters per second.
 *
 * <p>We define speed accuracy at 68% confidence.  Specifically, as 1-side of the
 * 2-sided range above and below the estimated speed reported by {@link #getSpeed()},
 * within which there is a 68% probability of finding the true speed.
 *
 * <p>In the case where the underlying
 * distribution is assumed Gaussian normal, this would be considered 1 standard deviation.
 *
 * <p>For example, if {@link #getSpeed()} returns 5, and
 * {@link #getSpeedAccuracyMetersPerSecond()} returns 1, then there is a 68% probability of
 * the true speed being between 4 and 6 meters per second.
 *
 * <p>Note that the speed and speed accuracy is often better than would be obtained simply from
 * differencing sequential positions, such as when the Doppler measurements from GNSS satellites
 * are used.
 *
 * <p>If this location does not have a speed accuracy, then 0.0 is returned.
 * @apiSince 26
 */

public float getSpeedAccuracyMetersPerSecond() { throw new RuntimeException("Stub!"); }

/**
 * Set the estimated speed accuracy of this location, meters per second.
 *
 * <p>See {@link #getSpeedAccuracyMetersPerSecond} for the definition of speed accuracy.
 *
 * <p>Following this call {@link #hasSpeedAccuracy} will return true.
 * @apiSince 26
 */

public void setSpeedAccuracyMetersPerSecond(float speedAccuracyMeterPerSecond) { throw new RuntimeException("Stub!"); }

/**
 * True if this location has a bearing accuracy.
 * @apiSince 26
 */

public boolean hasBearingAccuracy() { throw new RuntimeException("Stub!"); }

/**
 * Get the estimated bearing accuracy of this location, in degrees.
 *
 * <p>We define bearing accuracy at 68% confidence.  Specifically, as 1-side of the
 * 2-sided range on each side of the estimated bearing reported by {@link #getBearing()},
 * within which there is a 68% probability of finding the true bearing.
 *
 * <p>In the case where the underlying distribution is assumed Gaussian normal, this would be
 * considered 1 standard deviation.
 *
 * <p>For example, if {@link #getBearing()} returns 60, and
 * {@link #getBearingAccuracyDegrees()} returns 10, then there is a 68% probability of the
 * true bearing being between 50 and 70 degrees.
 *
 * <p>If this location does not have a bearing accuracy, then 0.0 is returned.
 * @apiSince 26
 */

public float getBearingAccuracyDegrees() { throw new RuntimeException("Stub!"); }

/**
 * Set the estimated bearing accuracy of this location, degrees.
 *
 * <p>See {@link #getBearingAccuracyDegrees} for the definition of bearing accuracy.
 *
 * <p>Following this call {@link #hasBearingAccuracy} will return true.
 * @apiSince 26
 */

public void setBearingAccuracyDegrees(float bearingAccuracyDegrees) { throw new RuntimeException("Stub!"); }

/**
 * Returns additional provider-specific information about the
 * location fix as a Bundle.  The keys and values are determined
 * by the provider.  If no additional information is available,
 * null is returned.
 *
 * <p> A number of common key/value pairs are listed
 * below. Providers that use any of the keys on this list must
 * provide the corresponding value as described below.
 *
 * <ul>
 * <li> satellites - the number of satellites used to derive the fix
 * </ul>
 * @apiSince 1
 */

public android.os.Bundle getExtras() { throw new RuntimeException("Stub!"); }

/**
 * Sets the extra information associated with this fix to the
 * given Bundle.
 *
 * <p>Note this stores a copy of the given extras, so any changes to extras after calling this
 * method won't be reflected in the location bundle.
 * @apiSince 1
 */

public void setExtras(android.os.Bundle extras) { throw new RuntimeException("Stub!"); }

/** @apiSince 1 */

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/** @apiSince 3 */

public void dump(android.util.Printer pw, java.lang.String prefix) { throw new RuntimeException("Stub!"); }

/** @apiSince 1 */

public int describeContents() { throw new RuntimeException("Stub!"); }

/** @apiSince 1 */

public void writeToParcel(android.os.Parcel parcel, int flags) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if the Location came from a mock provider.
 *
 * @return true if this Location came from a mock provider, false otherwise
 * @apiSince 18
 */

public boolean isFromMockProvider() { throw new RuntimeException("Stub!"); }

/** @apiSince 1 */

@androidx.annotation.RecentlyNonNull public static final android.os.Parcelable.Creator<android.location.Location> CREATOR;
static { CREATOR = null; }

/**
 * Constant used to specify formatting of a latitude or longitude
 * in the form "[+-]DDD.DDDDD where D indicates degrees.
 * @apiSince 1
 */

public static final int FORMAT_DEGREES = 0; // 0x0

/**
 * Constant used to specify formatting of a latitude or longitude
 * in the form "[+-]DDD:MM.MMMMM" where D indicates degrees and
 * M indicates minutes of arc (1 minute = 1/60th of a degree).
 * @apiSince 1
 */

public static final int FORMAT_MINUTES = 1; // 0x1

/**
 * Constant used to specify formatting of a latitude or longitude
 * in the form "DDD:MM:SS.SSSSS" where D indicates degrees, M
 * indicates minutes of arc, and S indicates seconds of arc (1
 * minute = 1/60th of a degree, 1 second = 1/3600th of a degree).
 * @apiSince 1
 */

public static final int FORMAT_SECONDS = 2; // 0x2
}

