/*
 * Copyright (C) 2008 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.view;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface MenuItem {

public int getItemId();

public int getGroupId();

public int getOrder();

public android.view.MenuItem setTitle(java.lang.CharSequence title);

public android.view.MenuItem setTitle(int title);

public java.lang.CharSequence getTitle();

public android.view.MenuItem setTitleCondensed(java.lang.CharSequence title);

public java.lang.CharSequence getTitleCondensed();

public android.view.MenuItem setIcon(android.graphics.drawable.Drawable icon);

public android.view.MenuItem setIcon(int iconRes);

public android.graphics.drawable.Drawable getIcon();

public default android.view.MenuItem setIconTintList(@android.annotation.Nullable android.content.res.ColorStateList tint) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public default android.content.res.ColorStateList getIconTintList() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public default android.view.MenuItem setIconTintMode(@android.annotation.Nullable android.graphics.PorterDuff.Mode tintMode) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public default android.view.MenuItem setIconTintBlendMode(@android.annotation.Nullable android.graphics.BlendMode blendMode) { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public default android.graphics.PorterDuff.Mode getIconTintMode() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public default android.graphics.BlendMode getIconTintBlendMode() { throw new RuntimeException("Stub!"); }

public android.view.MenuItem setIntent(android.content.Intent intent);

public android.content.Intent getIntent();

public android.view.MenuItem setShortcut(char numericChar, char alphaChar);

public default android.view.MenuItem setShortcut(char numericChar, char alphaChar, int numericModifiers, int alphaModifiers) { throw new RuntimeException("Stub!"); }

public android.view.MenuItem setNumericShortcut(char numericChar);

public default android.view.MenuItem setNumericShortcut(char numericChar, int numericModifiers) { throw new RuntimeException("Stub!"); }

public char getNumericShortcut();

public default int getNumericModifiers() { throw new RuntimeException("Stub!"); }

public android.view.MenuItem setAlphabeticShortcut(char alphaChar);

public default android.view.MenuItem setAlphabeticShortcut(char alphaChar, int alphaModifiers) { throw new RuntimeException("Stub!"); }

public char getAlphabeticShortcut();

public default int getAlphabeticModifiers() { throw new RuntimeException("Stub!"); }

public android.view.MenuItem setCheckable(boolean checkable);

public boolean isCheckable();

public android.view.MenuItem setChecked(boolean checked);

public boolean isChecked();

public android.view.MenuItem setVisible(boolean visible);

public boolean isVisible();

public android.view.MenuItem setEnabled(boolean enabled);

public boolean isEnabled();

public boolean hasSubMenu();

public android.view.SubMenu getSubMenu();

public android.view.MenuItem setOnMenuItemClickListener(android.view.MenuItem.OnMenuItemClickListener menuItemClickListener);

public android.view.ContextMenu.ContextMenuInfo getMenuInfo();

public void setShowAsAction(int actionEnum);

public android.view.MenuItem setShowAsActionFlags(int actionEnum);

public android.view.MenuItem setActionView(android.view.View view);

public android.view.MenuItem setActionView(int resId);

public android.view.View getActionView();

public android.view.MenuItem setActionProvider(android.view.ActionProvider actionProvider);

public android.view.ActionProvider getActionProvider();

public boolean expandActionView();

public boolean collapseActionView();

public boolean isActionViewExpanded();

public android.view.MenuItem setOnActionExpandListener(android.view.MenuItem.OnActionExpandListener listener);

public default android.view.MenuItem setContentDescription(java.lang.CharSequence contentDescription) { throw new RuntimeException("Stub!"); }

public default java.lang.CharSequence getContentDescription() { throw new RuntimeException("Stub!"); }

public default android.view.MenuItem setTooltipText(java.lang.CharSequence tooltipText) { throw new RuntimeException("Stub!"); }

public default java.lang.CharSequence getTooltipText() { throw new RuntimeException("Stub!"); }

public static final int SHOW_AS_ACTION_ALWAYS = 2; // 0x2

public static final int SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW = 8; // 0x8

public static final int SHOW_AS_ACTION_IF_ROOM = 1; // 0x1

public static final int SHOW_AS_ACTION_NEVER = 0; // 0x0

public static final int SHOW_AS_ACTION_WITH_TEXT = 4; // 0x4
@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnActionExpandListener {

public boolean onMenuItemActionExpand(android.view.MenuItem item);

public boolean onMenuItemActionCollapse(android.view.MenuItem item);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnMenuItemClickListener {

public boolean onMenuItemClick(android.view.MenuItem item);
}

}

