/*
 * Copyright (C) 2006 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package android.telephony;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DataFailCause {

private DataFailCause() { throw new RuntimeException("Stub!"); }

public static final int ACCESS_ATTEMPT_ALREADY_IN_PROGRESS = 2219; // 0x8ab

public static final int ACCESS_BLOCK = 2087; // 0x827

public static final int ACCESS_BLOCK_ALL = 2088; // 0x828

public static final int ACCESS_CLASS_DSAC_REJECTION = 2108; // 0x83c

public static final int ACCESS_CONTROL_LIST_CHECK_FAILURE = 2128; // 0x850

public static final int ACTIVATION_REJECTED_BCM_VIOLATION = 48; // 0x30

public static final int ACTIVATION_REJECT_GGSN = 30; // 0x1e

public static final int ACTIVATION_REJECT_UNSPECIFIED = 31; // 0x1f

public static final int ACTIVE_PDP_CONTEXT_MAX_NUMBER_REACHED = 65; // 0x41

public static final int APN_DISABLED = 2045; // 0x7fd

public static final int APN_DISALLOWED_ON_ROAMING = 2059; // 0x80b

public static final int APN_MISMATCH = 2054; // 0x806

public static final int APN_PARAMETERS_CHANGED = 2060; // 0x80c

public static final int APN_PENDING_HANDOVER = 2041; // 0x7f9

public static final int APN_TYPE_CONFLICT = 112; // 0x70

public static final int AUTH_FAILURE_ON_EMERGENCY_CALL = 122; // 0x7a

public static final int BEARER_HANDLING_NOT_SUPPORTED = 60; // 0x3c

public static final int CALL_DISALLOWED_IN_ROAMING = 2068; // 0x814

public static final int CALL_PREEMPT_BY_EMERGENCY_APN = 127; // 0x7f

public static final int CANNOT_ENCODE_OTA_MESSAGE = 2159; // 0x86f

public static final int CDMA_ALERT_STOP = 2077; // 0x81d

public static final int CDMA_INCOMING_CALL = 2076; // 0x81c

public static final int CDMA_INTERCEPT = 2073; // 0x819

public static final int CDMA_LOCK = 2072; // 0x818

public static final int CDMA_RELEASE_DUE_TO_SO_REJECTION = 2075; // 0x81b

public static final int CDMA_REORDER = 2074; // 0x81a

public static final int CDMA_RETRY_ORDER = 2086; // 0x826

public static final int CHANNEL_ACQUISITION_FAILURE = 2078; // 0x81e

public static final int CLOSE_IN_PROGRESS = 2030; // 0x7ee

public static final int COLLISION_WITH_NETWORK_INITIATED_REQUEST = 56; // 0x38

public static final int COMPANION_IFACE_IN_USE = 118; // 0x76

public static final int CONCURRENT_SERVICES_INCOMPATIBLE = 2083; // 0x823

public static final int CONCURRENT_SERVICES_NOT_ALLOWED = 2091; // 0x82b

public static final int CONCURRENT_SERVICE_NOT_SUPPORTED_BY_BASE_STATION = 2080; // 0x820

public static final int CONDITIONAL_IE_ERROR = 100; // 0x64

public static final int CONGESTION = 2106; // 0x83a

public static final int CONNECTION_RELEASED = 2113; // 0x841

public static final int CS_DOMAIN_NOT_AVAILABLE = 2181; // 0x885

public static final int CS_FALLBACK_CALL_ESTABLISHMENT_NOT_ALLOWED = 2188; // 0x88c

public static final int DATA_PLAN_EXPIRED = 2198; // 0x896

public static final int DATA_ROAMING_SETTINGS_DISABLED = 2064; // 0x810

public static final int DATA_SETTINGS_DISABLED = 2063; // 0x80f

public static final int DBM_OR_SMS_IN_PROGRESS = 2211; // 0x8a3

public static final int DDS_SWITCHED = 2065; // 0x811

public static final int DDS_SWITCH_IN_PROGRESS = 2067; // 0x813

public static final int DRB_RELEASED_BY_RRC = 2112; // 0x840

public static final int DS_EXPLICIT_DEACTIVATION = 2125; // 0x84d

public static final int DUAL_SWITCH = 2227; // 0x8b3

public static final int DUN_CALL_DISALLOWED = 2056; // 0x808

public static final int DUPLICATE_BEARER_ID = 2118; // 0x846

public static final int EHRPD_TO_HRPD_FALLBACK = 2049; // 0x801

public static final int EMBMS_NOT_ENABLED = 2193; // 0x891

public static final int EMBMS_REGULAR_DEACTIVATION = 2195; // 0x893

public static final int EMERGENCY_IFACE_ONLY = 116; // 0x74

public static final int EMERGENCY_MODE = 2221; // 0x8ad

public static final int EMM_ACCESS_BARRED = 115; // 0x73

public static final int EMM_ACCESS_BARRED_INFINITE_RETRY = 121; // 0x79

public static final int EMM_ATTACH_FAILED = 2115; // 0x843

public static final int EMM_ATTACH_STARTED = 2116; // 0x844

public static final int EMM_DETACHED = 2114; // 0x842

public static final int EMM_T3417_EXPIRED = 2130; // 0x852

public static final int EMM_T3417_EXT_EXPIRED = 2131; // 0x853

public static final int EPS_SERVICES_AND_NON_EPS_SERVICES_NOT_ALLOWED = 2178; // 0x882

public static final int EPS_SERVICES_NOT_ALLOWED_IN_PLMN = 2179; // 0x883

public static final int ERROR_UNSPECIFIED = 65535; // 0xffff

public static final int ESM_BAD_OTA_MESSAGE = 2122; // 0x84a

public static final int ESM_BEARER_DEACTIVATED_TO_SYNC_WITH_NETWORK = 2120; // 0x848

public static final int ESM_COLLISION_SCENARIOS = 2119; // 0x847

public static final int ESM_CONTEXT_TRANSFERRED_DUE_TO_IRAT = 2124; // 0x84c

public static final int ESM_DOWNLOAD_SERVER_REJECTED_THE_CALL = 2123; // 0x84b

public static final int ESM_FAILURE = 2182; // 0x886

public static final int ESM_INFO_NOT_RECEIVED = 53; // 0x35

public static final int ESM_LOCAL_CAUSE_NONE = 2126; // 0x84e

public static final int ESM_NW_ACTIVATED_DED_BEARER_WITH_ID_OF_DEF_BEARER = 2121; // 0x849

public static final int ESM_PROCEDURE_TIME_OUT = 2155; // 0x86b

public static final int ESM_UNKNOWN_EPS_BEARER_CONTEXT = 2111; // 0x83f

public static final int EVDO_CONNECTION_DENY_BY_BILLING_OR_AUTHENTICATION_FAILURE = 2201; // 0x899

public static final int EVDO_CONNECTION_DENY_BY_GENERAL_OR_NETWORK_BUSY = 2200; // 0x898

public static final int EVDO_HDR_CHANGED = 2202; // 0x89a

public static final int EVDO_HDR_CONNECTION_SETUP_TIMEOUT = 2206; // 0x89e

public static final int EVDO_HDR_EXITED = 2203; // 0x89b

public static final int EVDO_HDR_NO_SESSION = 2204; // 0x89c

public static final int EVDO_USING_GPS_FIX_INSTEAD_OF_HDR_CALL = 2205; // 0x89d

public static final int FADE = 2217; // 0x8a9

public static final int FAILED_TO_ACQUIRE_COLOCATED_HDR = 2207; // 0x89f

public static final int FEATURE_NOT_SUPP = 40; // 0x28

public static final int FILTER_SEMANTIC_ERROR = 44; // 0x2c

public static final int FILTER_SYTAX_ERROR = 45; // 0x2d

public static final int FORBIDDEN_APN_NAME = 2066; // 0x812

public static final int GPRS_REGISTRATION_FAIL = -2; // 0xfffffffe

public static final int GPRS_SERVICES_AND_NON_GPRS_SERVICES_NOT_ALLOWED = 2097; // 0x831

public static final int GPRS_SERVICES_NOT_ALLOWED = 2098; // 0x832

public static final int GPRS_SERVICES_NOT_ALLOWED_IN_THIS_PLMN = 2103; // 0x837

public static final int HANDOFF_PREFERENCE_CHANGED = 2251; // 0x8cb

public static final int HDR_ACCESS_FAILURE = 2213; // 0x8a5

public static final int HDR_FADE = 2212; // 0x8a4

public static final int HDR_NO_LOCK_GRANTED = 2210; // 0x8a2

public static final int IFACE_AND_POL_FAMILY_MISMATCH = 120; // 0x78

public static final int IFACE_MISMATCH = 117; // 0x75

public static final int ILLEGAL_ME = 2096; // 0x830

public static final int ILLEGAL_MS = 2095; // 0x82f

public static final int IMEI_NOT_ACCEPTED = 2177; // 0x881

public static final int IMPLICITLY_DETACHED = 2100; // 0x834

public static final int IMSI_UNKNOWN_IN_HOME_SUBSCRIBER_SERVER = 2176; // 0x880

public static final int INCOMING_CALL_REJECTED = 2092; // 0x82c

public static final int INSUFFICIENT_RESOURCES = 26; // 0x1a

public static final int INTERFACE_IN_USE = 2058; // 0x80a

public static final int INTERNAL_CALL_PREEMPT_BY_HIGH_PRIO_APN = 114; // 0x72

public static final int INTERNAL_EPC_NONEPC_TRANSITION = 2057; // 0x809

public static final int INVALID_CONNECTION_ID = 2156; // 0x86c

public static final int INVALID_DNS_ADDR = 123; // 0x7b

public static final int INVALID_EMM_STATE = 2190; // 0x88e

public static final int INVALID_MANDATORY_INFO = 96; // 0x60

public static final int INVALID_MODE = 2223; // 0x8af

public static final int INVALID_PCSCF_ADDR = 113; // 0x71

public static final int INVALID_PCSCF_OR_DNS_ADDRESS = 124; // 0x7c

public static final int INVALID_PRIMARY_NSAPI = 2158; // 0x86e

public static final int INVALID_SIM_STATE = 2224; // 0x8b0

public static final int INVALID_TRANSACTION_ID = 81; // 0x51

public static final int IPV6_ADDRESS_TRANSFER_FAILED = 2047; // 0x7ff

public static final int IPV6_PREFIX_UNAVAILABLE = 2250; // 0x8ca

public static final int IP_ADDRESS_MISMATCH = 119; // 0x77

public static final int IP_VERSION_MISMATCH = 2055; // 0x807

public static final int IRAT_HANDOVER_FAILED = 2194; // 0x892

public static final int IS707B_MAX_ACCESS_PROBES = 2089; // 0x829

public static final int LIMITED_TO_IPV4 = 2234; // 0x8ba

public static final int LIMITED_TO_IPV6 = 2235; // 0x8bb

public static final int LLC_SNDCP = 25; // 0x19

public static final int LOCAL_END = 2215; // 0x8a7

public static final int LOCATION_AREA_NOT_ALLOWED = 2102; // 0x836

public static final int LOST_CONNECTION = 65540; // 0x10004

public static final int LOWER_LAYER_REGISTRATION_FAILURE = 2197; // 0x895

public static final int LOW_POWER_MODE_OR_POWERING_DOWN = 2044; // 0x7fc

public static final int LTE_NAS_SERVICE_REQUEST_FAILED = 2117; // 0x845

public static final int LTE_THROTTLING_NOT_REQUIRED = 2127; // 0x84f

public static final int MAC_FAILURE = 2183; // 0x887

public static final int MAXIMIUM_NSAPIS_EXCEEDED = 2157; // 0x86d

public static final int MAXINUM_SIZE_OF_L2_MESSAGE_EXCEEDED = 2166; // 0x876

public static final int MAX_ACCESS_PROBE = 2079; // 0x81f

public static final int MAX_IPV4_CONNECTIONS = 2052; // 0x804

public static final int MAX_IPV6_CONNECTIONS = 2053; // 0x805

public static final int MAX_PPP_INACTIVITY_TIMER_EXPIRED = 2046; // 0x7fe

public static final int MESSAGE_INCORRECT_SEMANTIC = 95; // 0x5f

public static final int MESSAGE_TYPE_UNSUPPORTED = 97; // 0x61

public static final int MIP_CONFIG_FAILURE = 2050; // 0x802

public static final int MIP_FA_ADMIN_PROHIBITED = 2001; // 0x7d1

public static final int MIP_FA_DELIVERY_STYLE_NOT_SUPPORTED = 2012; // 0x7dc

public static final int MIP_FA_ENCAPSULATION_UNAVAILABLE = 2008; // 0x7d8

public static final int MIP_FA_HOME_AGENT_AUTHENTICATION_FAILURE = 2004; // 0x7d4

public static final int MIP_FA_INSUFFICIENT_RESOURCES = 2002; // 0x7d2

public static final int MIP_FA_MALFORMED_REPLY = 2007; // 0x7d7

public static final int MIP_FA_MALFORMED_REQUEST = 2006; // 0x7d6

public static final int MIP_FA_MISSING_CHALLENGE = 2017; // 0x7e1

public static final int MIP_FA_MISSING_HOME_ADDRESS = 2015; // 0x7df

public static final int MIP_FA_MISSING_HOME_AGENT = 2014; // 0x7de

public static final int MIP_FA_MISSING_NAI = 2013; // 0x7dd

public static final int MIP_FA_MOBILE_NODE_AUTHENTICATION_FAILURE = 2003; // 0x7d3

public static final int MIP_FA_REASON_UNSPECIFIED = 2000; // 0x7d0

public static final int MIP_FA_REQUESTED_LIFETIME_TOO_LONG = 2005; // 0x7d5

public static final int MIP_FA_REVERSE_TUNNEL_IS_MANDATORY = 2011; // 0x7db

public static final int MIP_FA_REVERSE_TUNNEL_UNAVAILABLE = 2010; // 0x7da

public static final int MIP_FA_STALE_CHALLENGE = 2018; // 0x7e2

public static final int MIP_FA_UNKNOWN_CHALLENGE = 2016; // 0x7e0

public static final int MIP_FA_VJ_HEADER_COMPRESSION_UNAVAILABLE = 2009; // 0x7d9

public static final int MIP_HA_ADMIN_PROHIBITED = 2020; // 0x7e4

public static final int MIP_HA_ENCAPSULATION_UNAVAILABLE = 2029; // 0x7ed

public static final int MIP_HA_FOREIGN_AGENT_AUTHENTICATION_FAILURE = 2023; // 0x7e7

public static final int MIP_HA_INSUFFICIENT_RESOURCES = 2021; // 0x7e5

public static final int MIP_HA_MALFORMED_REQUEST = 2025; // 0x7e9

public static final int MIP_HA_MOBILE_NODE_AUTHENTICATION_FAILURE = 2022; // 0x7e6

public static final int MIP_HA_REASON_UNSPECIFIED = 2019; // 0x7e3

public static final int MIP_HA_REGISTRATION_ID_MISMATCH = 2024; // 0x7e8

public static final int MIP_HA_REVERSE_TUNNEL_IS_MANDATORY = 2028; // 0x7ec

public static final int MIP_HA_REVERSE_TUNNEL_UNAVAILABLE = 2027; // 0x7eb

public static final int MIP_HA_UNKNOWN_HOME_AGENT_ADDRESS = 2026; // 0x7ea

public static final int MISSING_UNKNOWN_APN = 27; // 0x1b

public static final int MODEM_APP_PREEMPTED = 2032; // 0x7f0

public static final int MODEM_RESTART = 2037; // 0x7f5

public static final int MSC_TEMPORARILY_NOT_REACHABLE = 2180; // 0x884

public static final int MSG_AND_PROTOCOL_STATE_UNCOMPATIBLE = 101; // 0x65

public static final int MSG_TYPE_NONCOMPATIBLE_STATE = 98; // 0x62

public static final int MS_IDENTITY_CANNOT_BE_DERIVED_BY_THE_NETWORK = 2099; // 0x833

public static final int MULTIPLE_PDP_CALL_NOT_ALLOWED = 2192; // 0x890

public static final int MULTI_CONN_TO_SAME_PDN_NOT_ALLOWED = 55; // 0x37

public static final int NAS_LAYER_FAILURE = 2191; // 0x88f

public static final int NAS_REQUEST_REJECTED_BY_NETWORK = 2167; // 0x877

public static final int NAS_SIGNALLING = 14; // 0xe

public static final int NETWORK_FAILURE = 38; // 0x26

public static final int NETWORK_INITIATED_DETACH_NO_AUTO_REATTACH = 2154; // 0x86a

public static final int NETWORK_INITIATED_DETACH_WITH_AUTO_REATTACH = 2153; // 0x869

public static final int NETWORK_INITIATED_TERMINATION = 2031; // 0x7ef

public static final int NONE = 0; // 0x0

public static final int NON_IP_NOT_SUPPORTED = 2069; // 0x815

public static final int NORMAL_RELEASE = 2218; // 0x8aa

public static final int NO_CDMA_SERVICE = 2084; // 0x824

public static final int NO_COLLOCATED_HDR = 2225; // 0x8b1

public static final int NO_EPS_BEARER_CONTEXT_ACTIVATED = 2189; // 0x88d

public static final int NO_GPRS_CONTEXT = 2094; // 0x82e

public static final int NO_HYBRID_HDR_SERVICE = 2209; // 0x8a1

public static final int NO_PDP_CONTEXT_ACTIVATED = 2107; // 0x83b

public static final int NO_RESPONSE_FROM_BASE_STATION = 2081; // 0x821

public static final int NO_SERVICE = 2216; // 0x8a8

public static final int NO_SERVICE_ON_GATEWAY = 2093; // 0x82d

public static final int NSAPI_IN_USE = 35; // 0x23

public static final int NULL_APN_DISALLOWED = 2061; // 0x80d

public static final int OEM_DCFAILCAUSE_1 = 4097; // 0x1001

public static final int OEM_DCFAILCAUSE_10 = 4106; // 0x100a

public static final int OEM_DCFAILCAUSE_11 = 4107; // 0x100b

public static final int OEM_DCFAILCAUSE_12 = 4108; // 0x100c

public static final int OEM_DCFAILCAUSE_13 = 4109; // 0x100d

public static final int OEM_DCFAILCAUSE_14 = 4110; // 0x100e

public static final int OEM_DCFAILCAUSE_15 = 4111; // 0x100f

public static final int OEM_DCFAILCAUSE_2 = 4098; // 0x1002

public static final int OEM_DCFAILCAUSE_3 = 4099; // 0x1003

public static final int OEM_DCFAILCAUSE_4 = 4100; // 0x1004

public static final int OEM_DCFAILCAUSE_5 = 4101; // 0x1005

public static final int OEM_DCFAILCAUSE_6 = 4102; // 0x1006

public static final int OEM_DCFAILCAUSE_7 = 4103; // 0x1007

public static final int OEM_DCFAILCAUSE_8 = 4104; // 0x1008

public static final int OEM_DCFAILCAUSE_9 = 4105; // 0x1009

public static final int ONLY_IPV4V6_ALLOWED = 57; // 0x39

public static final int ONLY_IPV4_ALLOWED = 50; // 0x32

public static final int ONLY_IPV6_ALLOWED = 51; // 0x33

public static final int ONLY_NON_IP_ALLOWED = 58; // 0x3a

public static final int ONLY_SINGLE_BEARER_ALLOWED = 52; // 0x34

public static final int OPERATOR_BARRED = 8; // 0x8

public static final int OTASP_COMMIT_IN_PROGRESS = 2208; // 0x8a0

public static final int PDN_CONN_DOES_NOT_EXIST = 54; // 0x36

public static final int PDN_INACTIVITY_TIMER_EXPIRED = 2051; // 0x803

public static final int PDN_IPV4_CALL_DISALLOWED = 2033; // 0x7f1

public static final int PDN_IPV4_CALL_THROTTLED = 2034; // 0x7f2

public static final int PDN_IPV6_CALL_DISALLOWED = 2035; // 0x7f3

public static final int PDN_IPV6_CALL_THROTTLED = 2036; // 0x7f4

public static final int PDN_NON_IP_CALL_DISALLOWED = 2071; // 0x817

public static final int PDN_NON_IP_CALL_THROTTLED = 2070; // 0x816

public static final int PDP_ACTIVATE_MAX_RETRY_FAILED = 2109; // 0x83d

public static final int PDP_DUPLICATE = 2104; // 0x838

public static final int PDP_ESTABLISH_TIMEOUT_EXPIRED = 2161; // 0x871

public static final int PDP_INACTIVE_TIMEOUT_EXPIRED = 2163; // 0x873

public static final int PDP_LOWERLAYER_ERROR = 2164; // 0x874

public static final int PDP_MODIFY_COLLISION = 2165; // 0x875

public static final int PDP_MODIFY_TIMEOUT_EXPIRED = 2162; // 0x872

public static final int PDP_PPP_NOT_SUPPORTED = 2038; // 0x7f6

public static final int PDP_WITHOUT_ACTIVE_TFT = 46; // 0x2e

public static final int PHONE_IN_USE = 2222; // 0x8ae

public static final int PHYSICAL_LINK_CLOSE_IN_PROGRESS = 2040; // 0x7f8

public static final int PLMN_NOT_ALLOWED = 2101; // 0x835

public static final int PPP_AUTH_FAILURE = 2229; // 0x8b5

public static final int PPP_CHAP_FAILURE = 2232; // 0x8b8

public static final int PPP_CLOSE_IN_PROGRESS = 2233; // 0x8b9

public static final int PPP_OPTION_MISMATCH = 2230; // 0x8b6

public static final int PPP_PAP_FAILURE = 2231; // 0x8b7

public static final int PPP_TIMEOUT = 2228; // 0x8b4

public static final int PREF_RADIO_TECH_CHANGED = -4; // 0xfffffffc

public static final int PROFILE_BEARER_INCOMPATIBLE = 2042; // 0x7fa

public static final int PROTOCOL_ERRORS = 111; // 0x6f

public static final int QOS_NOT_ACCEPTED = 37; // 0x25

public static final int RADIO_ACCESS_BEARER_FAILURE = 2110; // 0x83e

public static final int RADIO_ACCESS_BEARER_SETUP_FAILURE = 2160; // 0x870

public static final int RADIO_NOT_AVAILABLE = 65537; // 0x10001

public static final int RADIO_POWER_OFF = -5; // 0xfffffffb

public static final int REDIRECTION_OR_HANDOFF_IN_PROGRESS = 2220; // 0x8ac

public static final int REGISTRATION_FAIL = -1; // 0xffffffff

public static final int REGULAR_DEACTIVATION = 36; // 0x24

public static final int REJECTED_BY_BASE_STATION = 2082; // 0x822

public static final int RRC_CONNECTION_ABORTED_AFTER_HANDOVER = 2173; // 0x87d

public static final int RRC_CONNECTION_ABORTED_AFTER_IRAT_CELL_CHANGE = 2174; // 0x87e

public static final int RRC_CONNECTION_ABORTED_DUE_TO_IRAT_CHANGE = 2171; // 0x87b

public static final int RRC_CONNECTION_ABORTED_DURING_IRAT_CELL_CHANGE = 2175; // 0x87f

public static final int RRC_CONNECTION_ABORT_REQUEST = 2151; // 0x867

public static final int RRC_CONNECTION_ACCESS_BARRED = 2139; // 0x85b

public static final int RRC_CONNECTION_ACCESS_STRATUM_FAILURE = 2137; // 0x859

public static final int RRC_CONNECTION_ANOTHER_PROCEDURE_IN_PROGRESS = 2138; // 0x85a

public static final int RRC_CONNECTION_CELL_NOT_CAMPED = 2144; // 0x860

public static final int RRC_CONNECTION_CELL_RESELECTION = 2140; // 0x85c

public static final int RRC_CONNECTION_CONFIG_FAILURE = 2141; // 0x85d

public static final int RRC_CONNECTION_INVALID_REQUEST = 2168; // 0x878

public static final int RRC_CONNECTION_LINK_FAILURE = 2143; // 0x85f

public static final int RRC_CONNECTION_NORMAL_RELEASE = 2147; // 0x863

public static final int RRC_CONNECTION_OUT_OF_SERVICE_DURING_CELL_REGISTER = 2150; // 0x866

public static final int RRC_CONNECTION_RADIO_LINK_FAILURE = 2148; // 0x864

public static final int RRC_CONNECTION_REESTABLISHMENT_FAILURE = 2149; // 0x865

public static final int RRC_CONNECTION_REJECT_BY_NETWORK = 2146; // 0x862

public static final int RRC_CONNECTION_RELEASED_SECURITY_NOT_ACTIVE = 2172; // 0x87c

public static final int RRC_CONNECTION_RF_UNAVAILABLE = 2170; // 0x87a

public static final int RRC_CONNECTION_SYSTEM_INFORMATION_BLOCK_READ_ERROR = 2152; // 0x868

public static final int RRC_CONNECTION_SYSTEM_INTERVAL_FAILURE = 2145; // 0x861

public static final int RRC_CONNECTION_TIMER_EXPIRED = 2142; // 0x85e

public static final int RRC_CONNECTION_TRACKING_AREA_ID_CHANGED = 2169; // 0x879

public static final int RRC_UPLINK_CONNECTION_RELEASE = 2134; // 0x856

public static final int RRC_UPLINK_DATA_TRANSMISSION_FAILURE = 2132; // 0x854

public static final int RRC_UPLINK_DELIVERY_FAILED_DUE_TO_HANDOVER = 2133; // 0x855

public static final int RRC_UPLINK_ERROR_REQUEST_FROM_NAS = 2136; // 0x858

public static final int RRC_UPLINK_RADIO_LINK_FAILURE = 2135; // 0x857

public static final int RUIM_NOT_PRESENT = 2085; // 0x825

public static final int SECURITY_MODE_REJECTED = 2186; // 0x88a

public static final int SERVICE_NOT_ALLOWED_ON_PLMN = 2129; // 0x851

public static final int SERVICE_OPTION_NOT_SUBSCRIBED = 33; // 0x21

public static final int SERVICE_OPTION_NOT_SUPPORTED = 32; // 0x20

public static final int SERVICE_OPTION_OUT_OF_ORDER = 34; // 0x22

public static final int SIGNAL_LOST = -3; // 0xfffffffd

public static final int SIM_CARD_CHANGED = 2043; // 0x7fb

public static final int SYNCHRONIZATION_FAILURE = 2184; // 0x888

public static final int TEST_LOOPBACK_REGULAR_DEACTIVATION = 2196; // 0x894

public static final int TETHERED_CALL_ACTIVE = -6; // 0xfffffffa

public static final int TFT_SEMANTIC_ERROR = 41; // 0x29

public static final int TFT_SYTAX_ERROR = 42; // 0x2a

public static final int THERMAL_EMERGENCY = 2090; // 0x82a

public static final int THERMAL_MITIGATION = 2062; // 0x80e

public static final int TRAT_SWAP_FAILED = 2048; // 0x800

public static final int UE_INITIATED_DETACH_OR_DISCONNECT = 128; // 0x80

public static final int UE_IS_ENTERING_POWERSAVE_MODE = 2226; // 0x8b2

public static final int UE_RAT_CHANGE = 2105; // 0x839

public static final int UE_SECURITY_CAPABILITIES_MISMATCH = 2185; // 0x889

public static final int UMTS_HANDOVER_TO_IWLAN = 2199; // 0x897

public static final int UMTS_REACTIVATION_REQ = 39; // 0x27

public static final int UNACCEPTABLE_NETWORK_PARAMETER = 65538; // 0x10002

public static final int UNACCEPTABLE_NON_EPS_AUTHENTICATION = 2187; // 0x88b

public static final int UNKNOWN = 65536; // 0x10000

public static final int UNKNOWN_INFO_ELEMENT = 99; // 0x63

public static final int UNKNOWN_PDP_ADDRESS_TYPE = 28; // 0x1c

public static final int UNKNOWN_PDP_CONTEXT = 43; // 0x2b

public static final int UNPREFERRED_RAT = 2039; // 0x7f7

public static final int UNSUPPORTED_1X_PREV = 2214; // 0x8a6

public static final int UNSUPPORTED_APN_IN_CURRENT_PLMN = 66; // 0x42

public static final int UNSUPPORTED_QCI_VALUE = 59; // 0x3b

public static final int USER_AUTHENTICATION = 29; // 0x1d

public static final int VSNCP_ADMINISTRATIVELY_PROHIBITED = 2245; // 0x8c5

public static final int VSNCP_APN_UNAUTHORIZED = 2238; // 0x8be

public static final int VSNCP_GEN_ERROR = 2237; // 0x8bd

public static final int VSNCP_INSUFFICIENT_PARAMETERS = 2243; // 0x8c3

public static final int VSNCP_NO_PDN_GATEWAY_ADDRESS = 2240; // 0x8c0

public static final int VSNCP_PDN_EXISTS_FOR_THIS_APN = 2248; // 0x8c8

public static final int VSNCP_PDN_GATEWAY_REJECT = 2242; // 0x8c2

public static final int VSNCP_PDN_GATEWAY_UNREACHABLE = 2241; // 0x8c1

public static final int VSNCP_PDN_ID_IN_USE = 2246; // 0x8c6

public static final int VSNCP_PDN_LIMIT_EXCEEDED = 2239; // 0x8bf

public static final int VSNCP_RECONNECT_NOT_ALLOWED = 2249; // 0x8c9

public static final int VSNCP_RESOURCE_UNAVAILABLE = 2244; // 0x8c4

public static final int VSNCP_SUBSCRIBER_LIMITATION = 2247; // 0x8c7

public static final int VSNCP_TIMEOUT = 2236; // 0x8bc
}

