/*
 * Copyright (C) 2017 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.hardware;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class HardwareBuffer implements android.os.Parcelable, java.lang.AutoCloseable {

private HardwareBuffer() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.hardware.HardwareBuffer create(int width, int height, int format, int layers, long usage) { throw new RuntimeException("Stub!"); }

public static boolean isSupported(int width, int height, int format, int layers, long usage) { throw new RuntimeException("Stub!"); }

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }

public int getWidth() { throw new RuntimeException("Stub!"); }

public int getHeight() { throw new RuntimeException("Stub!"); }

public int getFormat() { throw new RuntimeException("Stub!"); }

public int getLayers() { throw new RuntimeException("Stub!"); }

public long getUsage() { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

public boolean isClosed() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

public static final int BLOB = 33; // 0x21

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.hardware.HardwareBuffer> CREATOR;
static { CREATOR = null; }

public static final int DS_24UI8 = 50; // 0x32

public static final int DS_FP32UI8 = 52; // 0x34

public static final int D_16 = 48; // 0x30

public static final int D_24 = 49; // 0x31

public static final int D_FP32 = 51; // 0x33

public static final int RGBA_1010102 = 43; // 0x2b

public static final int RGBA_8888 = 1; // 0x1

public static final int RGBA_FP16 = 22; // 0x16

public static final int RGBX_8888 = 2; // 0x2

public static final int RGB_565 = 4; // 0x4

public static final int RGB_888 = 3; // 0x3

public static final int S_UI8 = 53; // 0x35

public static final long USAGE_CPU_READ_OFTEN = 3L; // 0x3L

public static final long USAGE_CPU_READ_RARELY = 2L; // 0x2L

public static final long USAGE_CPU_WRITE_OFTEN = 48L; // 0x30L

public static final long USAGE_CPU_WRITE_RARELY = 32L; // 0x20L

public static final long USAGE_GPU_COLOR_OUTPUT = 512L; // 0x200L

public static final long USAGE_GPU_CUBE_MAP = 33554432L; // 0x2000000L

public static final long USAGE_GPU_DATA_BUFFER = 16777216L; // 0x1000000L

public static final long USAGE_GPU_MIPMAP_COMPLETE = 67108864L; // 0x4000000L

public static final long USAGE_GPU_SAMPLED_IMAGE = 256L; // 0x100L

public static final long USAGE_PROTECTED_CONTENT = 16384L; // 0x4000L

public static final long USAGE_SENSOR_DIRECT_DATA = 8388608L; // 0x800000L

public static final long USAGE_VIDEO_ENCODE = 65536L; // 0x10000L

public static final int YCBCR_420_888 = 35; // 0x23
}

