/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.r8.shaking;

import com.android.tools.r8.experimental.graphinfo.GraphNode;
import com.android.tools.r8.experimental.graphinfo.a;
import com.android.tools.r8.graph.O;
import com.android.tools.r8.graph.R0;
import com.android.tools.r8.graph.V;
import com.android.tools.r8.graph.X;
import com.android.tools.r8.graph.c0;
import com.android.tools.r8.graph.e0;
import com.android.tools.r8.graph.i0;
import com.android.tools.r8.shaking.GraphReporter;

public abstract class KeepReason {
    static KeepReason annotatedOn(O o4) {
        return new AnnotatedOn(o4);
    }

    static KeepReason instantiatedIn(V v4) {
        return new InstatiatedIn(v4);
    }

    public static KeepReason invokedViaSuperFrom(V v4) {
        return new InvokedViaSuper(v4);
    }

    public static KeepReason reachableFromLiveType(i0 i02) {
        return new ReachableFromLiveType(i02);
    }

    public static KeepReason invokedFrom(e0 e02, V v4) {
        return new InvokedFrom(e02, v4);
    }

    public static KeepReason invokedFrom(R0 r02) {
        return KeepReason.invokedFrom(r02.c(), r02.b());
    }

    public static KeepReason invokedFromLambdaCreatedIn(V v4) {
        return new InvokedFromLambdaCreatedIn(v4);
    }

    public static KeepReason isLibraryMethod(e0 e02, i0 i02) {
        return new IsLibraryMethod(e02.e, i02);
    }

    public static KeepReason fieldReferencedIn(V v4) {
        return new ReferencedFrom(v4);
    }

    public static KeepReason referencedInAnnotation(X x4) {
        return new ReferencedInAnnotation(x4);
    }

    public static KeepReason targetedBySuperFrom(V v4) {
        return new TargetedBySuper(v4);
    }

    public static KeepReason reflectiveUseIn(V v4) {
        return new ReflectiveUseFrom(v4);
    }

    public static KeepReason methodHandleReferencedIn(V v4) {
        return new MethodHandleReferencedFrom(v4);
    }

    public abstract a.a edgeKind();

    public abstract GraphNode getSourceNode(GraphReporter var1);

    public boolean isDueToKeepRule() {
        return false;
    }

    public boolean isDueToReflectiveUse() {
        return false;
    }

    private static class MethodHandleReferencedFrom
    extends BasedOnOtherMethod {
        private MethodHandleReferencedFrom(V v4) {
            super(v4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.q;
        }

        @Override
        String getKind() {
            return "method handle referenced from";
        }
    }

    private static class ReflectiveUseFrom
    extends BasedOnOtherMethod {
        private ReflectiveUseFrom(V v4) {
            super(v4);
        }

        @Override
        public boolean isDueToReflectiveUse() {
            return true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.l;
        }

        @Override
        String getKind() {
            return "reflective use in";
        }
    }

    private static class AnnotatedOn
    extends KeepReason {
        static final /* synthetic */ boolean $assertionsDisabled;
        private final O holder;

        private AnnotatedOn(O o4) {
            this.holder = o4;
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.j;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            if (this.holder.h()) {
                return graphReporter.getClassGraphNode(this.holder.b().e);
            }
            if (this.holder.i()) {
                return graphReporter.getFieldGraphNode(this.holder.c().c);
            }
            if (!$assertionsDisabled && !this.holder.j()) {
                throw new AssertionError();
            }
            return graphReporter.getMethodGraphNode(this.holder.e().c);
        }
    }

    private static class ReferencedInAnnotation
    extends KeepReason {
        private final X holder;

        private ReferencedInAnnotation(X x4) {
            this.holder = x4;
        }

        @Override
        public a.a edgeKind() {
            return a.a.n;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getAnnotationGraphNode(this.holder);
        }
    }

    public static class IsLibraryMethod
    extends KeepReason {
        private final i0 implementer;
        private final i0 libraryType;

        private IsLibraryMethod(i0 i02, i0 i03) {
            this.implementer = i02;
            this.libraryType = i03;
        }

        @Override
        public a.a edgeKind() {
            return a.a.o;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.implementer);
        }
    }

    private static class ReachableFromLiveType
    extends KeepReason {
        private final i0 type;

        private ReachableFromLiveType(i0 i02) {
            this.type = i02;
        }

        @Override
        public a.a edgeKind() {
            return a.a.m;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getClassGraphNode(this.type);
        }
    }

    private static class ReferencedFrom
    extends BasedOnOtherMethod {
        private ReferencedFrom(V v4) {
            super(v4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.k;
        }

        @Override
        String getKind() {
            return "referenced from";
        }
    }

    private static class InvokedFromLambdaCreatedIn
    extends BasedOnOtherMethod {
        private InvokedFromLambdaCreatedIn(V v4) {
            super(v4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.i;
        }

        @Override
        String getKind() {
            return "invoked from lambda created in";
        }
    }

    private static class InvokedFrom
    extends BasedOnOtherMethod {
        static final /* synthetic */ boolean $assertionsDisabled;

        private InvokedFrom(e0 e02, V v4) {
            super(v4);
            if (!$assertionsDisabled && e02.e != v4.c.c) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = KeepReason.class.desiredAssertionStatus() ^ true;
        }

        @Override
        public a.a edgeKind() {
            return a.a.h;
        }

        @Override
        String getKind() {
            return "invoked from";
        }
    }

    private static class TargetedBySuper
    extends BasedOnOtherMethod {
        private TargetedBySuper(V v4) {
            super(v4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.g;
        }

        @Override
        String getKind() {
            return "targeted by super from";
        }
    }

    private static class InvokedViaSuper
    extends BasedOnOtherMethod {
        private InvokedViaSuper(V v4) {
            super(v4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.f;
        }

        @Override
        String getKind() {
            return "invoked via super from";
        }
    }

    public static class InstatiatedIn
    extends BasedOnOtherMethod {
        private InstatiatedIn(V v4) {
            super(v4);
        }

        @Override
        public a.a edgeKind() {
            return a.a.e;
        }

        @Override
        String getKind() {
            return "instantiated in";
        }
    }

    private static abstract class BasedOnOtherMethod
    extends KeepReason {
        private final V method;

        private BasedOnOtherMethod(V v4) {
            this.method = v4;
        }

        abstract String getKind();

        public c0 getMethod() {
            return this.method.c;
        }

        @Override
        public GraphNode getSourceNode(GraphReporter graphReporter) {
            return graphReporter.getMethodGraphNode(this.method.c);
        }
    }
}

