/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint;

import com.android.tools.lint.LintCoreApplicationEnvironment;
import com.google.common.collect.Sets;
import com.intellij.core.CoreApplicationEnvironment;
import com.intellij.core.JavaCoreApplicationEnvironment;
import com.intellij.core.JavaCoreProjectEnvironment;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.impl.PsiTreeChangePreprocessor;
import com.intellij.psi.impl.file.impl.JavaFileManager;
import java.io.File;
import java.util.HashSet;
import java.util.List;

public class LintCoreProjectEnvironment
extends JavaCoreProjectEnvironment {
    public static LintCoreProjectEnvironment create(Disposable parentDisposable, JavaCoreApplicationEnvironment applicationEnvironment) {
        return new LintCoreProjectEnvironment(parentDisposable, (CoreApplicationEnvironment)applicationEnvironment);
    }

    protected void preregisterServices() {
        super.preregisterServices();
        ExtensionsArea area = Extensions.getArea((AreaInstance)this.getProject());
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)PsiTreeChangePreprocessor.EP_NAME, PsiTreeChangePreprocessor.class);
        CoreApplicationEnvironment.registerExtensionPoint((ExtensionsArea)area, (ExtensionPointName)PsiElementFinder.EP_NAME, PsiElementFinder.class);
    }

    public LintCoreProjectEnvironment(Disposable parentDisposable, CoreApplicationEnvironment applicationEnvironment) {
        super(parentDisposable, applicationEnvironment);
        ExtensionsArea area = Extensions.getArea((AreaInstance)this.getProject());
        LintCoreApplicationEnvironment.registerProjectExtensionPoints(area);
        LintCoreApplicationEnvironment.registerProjectServicesForCLI(this);
        LintCoreApplicationEnvironment.registerProjectServices(this);
    }

    protected JavaFileManager createCoreFileManager() {
        return super.createCoreFileManager();
    }

    public void registerPaths(List<File> classpath) {
        int expectedSize = classpath.size();
        HashSet files = Sets.newHashSetWithExpectedSize((int)expectedSize);
        VirtualFileSystem local = StandardFileSystems.local();
        for (File path : classpath) {
            VirtualFile virtualFile;
            if (files.contains(path)) continue;
            files.add(path);
            if (!path.exists()) continue;
            if (path.isFile()) {
                this.addJarToClassPath(path);
                continue;
            }
            if (!path.isDirectory() || (virtualFile = local.findFileByPath(path.getPath())) == null) continue;
            this.addSourcesToClasspath(virtualFile);
        }
    }
}

