/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Set;
import org.jf.dexlib2.dexbacked.DexBackedClassDef;
import org.jf.dexlib2.dexbacked.DexBackedDexFile;

public class DexFileStats {
    public final int classCount;
    public final int definedMethodCount;
    public final int referencedMethodCount;

    private DexFileStats(int classCount, int definedMethodCount, int referencedMethodCount) {
        this.classCount = classCount;
        this.definedMethodCount = definedMethodCount;
        this.referencedMethodCount = referencedMethodCount;
    }

    public static DexFileStats create(Collection<DexBackedDexFile> dexFiles) {
        int definedMethodCount = 0;
        int classesCount = 0;
        int methodCount = 0;
        for (DexBackedDexFile dexFile : dexFiles) {
            Set<? extends DexBackedClassDef> classes = dexFile.getClasses();
            for (DexBackedClassDef dexBackedClassDef : classes) {
                definedMethodCount += Iterables.size(dexBackedClassDef.getMethods());
            }
            classesCount += classes.size();
            methodCount += dexFile.getMethodCount();
        }
        return new DexFileStats(classesCount, definedMethodCount, methodCount);
    }
}

