/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchiveTreeStream;
import com.android.tools.apk.analyzer.Archives;
import com.android.tools.apk.analyzer.InnerArchiveEntry;
import com.android.tools.apk.analyzer.internal.ArchiveTreeNode;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.swing.tree.MutableTreeNode;

public class ArchiveTreeStructure {
    private static final List<String> INNER_ZIP_EXTENSIONS = ImmutableList.of((Object)".zip", (Object)".apk", (Object)".jar");
    private static final FileVisitor<Path> fileVisitor = new FileVisitor<Path>(){

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            dir.toFile().deleteOnExit();
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            file.toFile().deleteOnExit();
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    };

    public static ArchiveNode create(Archive archive) throws IOException {
        return ArchiveTreeStructure.create(archive, "");
    }

    public static ArchiveNode create(Archive archive, String fullPathString) throws IOException {
        Path contentRoot = archive.getContentRoot();
        ArchiveTreeNode rootNode = new ArchiveTreeNode(new ArchiveEntry(archive, contentRoot, fullPathString + contentRoot.toString()));
        Stack<ArchiveTreeNode> stack = new Stack<ArchiveTreeNode>();
        stack.push(rootNode);
        Path tempFolder = null;
        while (!stack.isEmpty()) {
            ArchiveTreeNode node = (ArchiveTreeNode)stack.pop();
            Path path = node.getData().getPath();
            DirectoryStream<Path> stream = Files.newDirectoryStream(path);
            Throwable throwable = null;
            try {
                for (Path childPath : stream) {
                    ArchiveTreeNode childNode;
                    if (INNER_ZIP_EXTENSIONS.stream().anyMatch(ext -> childPath.getFileName().toString().endsWith((String)ext))) {
                        if (tempFolder == null) {
                            tempFolder = Files.createTempDirectory(archive.getPath().getFileName().toString(), new FileAttribute[0]);
                        }
                        Path tempFile = tempFolder.resolve(contentRoot.relativize(childPath).toString());
                        Files.createDirectories(tempFile.getParent(), new FileAttribute[0]);
                        Files.copy(childPath, tempFile, new CopyOption[0]);
                        Archive tempArchive = Archives.openInnerZip(tempFile);
                        ArchiveTreeNode newArchiveNode = (ArchiveTreeNode)ArchiveTreeStructure.create(tempArchive, fullPathString + childPath.toString());
                        childNode = new ArchiveTreeNode(new InnerArchiveEntry(archive, childPath, fullPathString + childPath.toString(), tempArchive));
                        for (ArchiveNode archiveNodeChild : newArchiveNode.getChildren()) {
                            childNode.add((MutableTreeNode)((Object)archiveNodeChild));
                        }
                    } else {
                        childNode = new ArchiveTreeNode(new ArchiveEntry(archive, childPath, fullPathString + childPath.toString()));
                        if (Files.isDirectory(childPath, new LinkOption[0])) {
                            stack.push(childNode);
                        }
                    }
                    node.add(childNode);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (stream == null) continue;
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                stream.close();
            }
        }
        if (tempFolder != null) {
            Files.walkFileTree(tempFolder, fileVisitor);
        }
        return rootNode;
    }

    public static void updateRawFileSizes(ArchiveNode root, ApkSizeCalculator calculator) {
        Map<String, Long> rawFileSizes = root.getData() instanceof InnerArchiveEntry ? calculator.getRawSizePerFile(((InnerArchiveEntry)root.getData()).asArchiveEntry().getArchive().getPath()) : calculator.getRawSizePerFile(root.getData().getArchive().getPath());
        ArchiveTreeStream.preOrderStream(root).forEach(node -> {
            Long rawFileSize;
            ArchiveEntry data = node.getData();
            if (node != root && data.getPath().getFileName() != null && node.getData() instanceof InnerArchiveEntry) {
                ArchiveTreeStructure.updateRawFileSizes(node, calculator);
            }
            if ((rawFileSize = (Long)rawFileSizes.get(data.getPath().toString())) != null) {
                data.setRawFileSize(rawFileSize);
            }
        });
        ArchiveTreeStream.postOrderStream(root).forEach(node -> {
            ArchiveEntry data = node.getData();
            if (data.getRawFileSize() < 0L && node.getChildCount() > 0) {
                Long sizeOfAllChildren = node.getChildren().stream().map(n -> n.getData().getRawFileSize()).reduce(0L, Long::sum);
                data.setRawFileSize(sizeOfAllChildren);
            }
        });
    }

    public static void updateDownloadFileSizes(ArchiveNode root, ApkSizeCalculator calculator) {
        Map<String, Long> downloadFileSizes = root.getData() instanceof InnerArchiveEntry ? calculator.getDownloadSizePerFile(((InnerArchiveEntry)root.getData()).asArchiveEntry().getArchive().getPath()) : calculator.getDownloadSizePerFile(root.getData().getArchive().getPath());
        ArchiveTreeStream.preOrderStream(root).forEach(node -> {
            Long downloadFileSize;
            ArchiveEntry data = node.getData();
            if (node != root && data.getPath().getFileName() != null && node.getData() instanceof InnerArchiveEntry) {
                ArchiveTreeStructure.updateDownloadFileSizes(node, calculator);
            }
            if ((downloadFileSize = (Long)downloadFileSizes.get(data.getPath().toString())) != null) {
                data.setDownloadFileSize(downloadFileSize);
            }
        });
        ArchiveTreeStream.postOrderStream(root).forEach(node -> {
            ArchiveEntry data = node.getData();
            if (data.getDownloadFileSize() < 0L && node.getChildCount() > 0) {
                Long sizeOfAllChildren = node.getChildren().stream().map(n -> n.getData().getDownloadFileSize()).reduce(0L, Long::sum);
                data.setDownloadFileSize(sizeOfAllChildren);
            }
        });
    }

    public static void sort(ArchiveNode root, Comparator<ArchiveNode> comparator) {
        assert (root instanceof ArchiveTreeNode);
        ArchiveTreeStructure.sort((ArchiveTreeNode)root, comparator);
    }

    private static void sort(ArchiveTreeNode root, Comparator<ArchiveNode> comparator) {
        ArrayList<ArchiveNode> children = new ArrayList<ArchiveNode>(root.getChildren());
        children.sort(comparator);
        root.removeAllChildren();
        for (ArchiveNode child : children) {
            root.add((ArchiveTreeNode)child);
            ArchiveTreeStructure.sort(child, comparator);
        }
    }
}

