/*
 * Decompiled with CFR 0.152.
 */
package com.android.assetstudiolib;

import com.android.assetstudiolib.GeneratedIcon;
import com.android.assetstudiolib.GeneratedIcons;
import com.android.assetstudiolib.GeneratedImageIcon;
import com.android.assetstudiolib.GraphicGeneratorContext;
import com.android.assetstudiolib.IconCategory;
import com.android.resources.Density;
import com.android.resources.ResourceFolderType;
import com.android.utils.FileUtils;
import com.android.utils.SdkUtils;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Paths;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public abstract class GraphicGenerator {
    private static final Map<Density, Pattern> DENSITY_PATTERNS;

    public GeneratedIcon generateIcon(GraphicGeneratorContext context, Options options, String name, IconCategory category) {
        BufferedImage image = this.generate(context, options);
        if (image == null) {
            return null;
        }
        return new GeneratedImageIcon(this.getIconName(options, name), Paths.get(this.getIconPath(options, name), new String[0]), category, options.density, image);
    }

    public GeneratedIcons generateIcons(GraphicGeneratorContext context, Options options, String name) {
        HashMap<String, Map<String, BufferedImage>> categoryMap = new HashMap<String, Map<String, BufferedImage>>();
        this.generate(null, categoryMap, context, options, name);
        GeneratedIcons icons = new GeneratedIcons();
        categoryMap.forEach((category, images) -> images.forEach((path, image) -> {
            Density density = GraphicGenerator.pathToDensity(path);
            if (density == null) {
                density = Density.NODPI;
            }
            GeneratedImageIcon icon = new GeneratedImageIcon((String)path, Paths.get(path, new String[0]), IconCategory.fromName(category), density, (BufferedImage)image);
            icons.add(icon);
        }));
        return icons;
    }

    public abstract BufferedImage generate(GraphicGeneratorContext var1, Options var2);

    protected String getIconPath(Options options, String name) {
        return this.getIconFolder(options) + '/' + this.getIconName(options, name);
    }

    protected String getIconName(Options options, String name) {
        if (options.density == Density.ANYDPI) {
            return name + ".xml";
        }
        return name + ".png";
    }

    protected String getIconFolder(Options options) {
        switch (options.iconFolderKind) {
            case DRAWABLE: {
                return GraphicGenerator.getIconFolder(ResourceFolderType.DRAWABLE, options.density);
            }
            case MIPMAP: {
                return GraphicGenerator.getIconFolder(ResourceFolderType.MIPMAP, options.density);
            }
            case MIPMAP_V26: {
                return GraphicGenerator.getIconFolder(ResourceFolderType.MIPMAP, options.density) + "-v26";
            }
            case DRAWABLE_NO_DPI: {
                return GraphicGenerator.getIconFolder(ResourceFolderType.DRAWABLE, Density.NODPI);
            }
            case VALUES: {
                return GraphicGenerator.getIconFolder(ResourceFolderType.VALUES, Density.NODPI);
            }
        }
        throw new IllegalArgumentException();
    }

    private static String getIconFolder(ResourceFolderType folderType, Density density) {
        StringBuilder sb = new StringBuilder(50);
        sb.append("res");
        sb.append('/');
        sb.append(folderType.getName());
        if (density != Density.NODPI) {
            sb.append('-');
            sb.append(density.getResourceValue());
        }
        return sb.toString();
    }

    public void generate(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, Options options, String name) {
        this.generateAllDensities(category, categoryMap, context, options, name);
    }

    protected void generateAllDensities(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, Options options, String name) {
        if (options.density == Density.ANYDPI) {
            this.generateImageAndUpdateMap(category, categoryMap, context, options, name);
            return;
        }
        Density[] densityValues = Density.values();
        Arrays.sort(densityValues, Comparator.comparingInt(Density::getDpiValue));
        for (Density density : densityValues) {
            if (!density.isValidValueForDevice() || !this.includeDensity(density)) continue;
            options.density = density;
            this.generateImageAndUpdateMap(category, categoryMap, context, options, name);
        }
    }

    private void generateImageAndUpdateMap(String category, Map<String, Map<String, BufferedImage>> categoryMap, GraphicGeneratorContext context, Options options, String name) {
        BufferedImage image = this.generate(context, options);
        if (image == null) {
            return;
        }
        String mapCategory = category;
        if (mapCategory == null) {
            mapCategory = options.density.getResourceValue();
        }
        Map imageMap = categoryMap.computeIfAbsent(mapCategory, k -> new LinkedHashMap());
        imageMap.put(this.getIconPath(options, name), image);
    }

    protected boolean includeDensity(Density density) {
        return density.isRecommended() && density != Density.LOW && density != Density.XXXHIGH;
    }

    public static float getMdpiScaleFactor(Density density) {
        if (density == Density.ANYDPI) {
            density = Density.XXXHIGH;
        }
        if (density == Density.NODPI) {
            density = Density.MEDIUM;
        }
        return (float)density.getDpiValue() / (float)Density.MEDIUM.getDpiValue();
    }

    public static BufferedImage getStencilImage(String relativePath) throws IOException {
        InputStream is = GraphicGenerator.class.getResourceAsStream(relativePath);
        if (is == null) {
            return null;
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
        finally {
            Closeables.close((Closeable)is, (boolean)true);
        }
    }

    public static BufferedImage getClipartIcon(String name) throws IOException {
        InputStream is = GraphicGenerator.class.getResourceAsStream("/images/clipart/small/" + name);
        try {
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
        finally {
            Closeables.close((Closeable)is, (boolean)true);
        }
    }

    public static BufferedImage getClipartImage(String name) throws IOException {
        InputStream is = GraphicGenerator.class.getResourceAsStream("/images/clipart/big/" + name);
        try {
            BufferedImage bufferedImage = ImageIO.read(is);
            return bufferedImage;
        }
        finally {
            Closeables.close((Closeable)is, (boolean)true);
        }
    }

    public static Iterator<String> getResourcesNames(String pathPrefix, String filenameExtension) {
        ArrayList<String> names = new ArrayList<String>(80);
        try {
            ZipFile zipFile = null;
            ProtectionDomain protectionDomain = GraphicGenerator.class.getProtectionDomain();
            URL url = protectionDomain.getCodeSource().getLocation();
            if (url != null && url.getProtocol().equals("jar")) {
                File file = SdkUtils.urlToFile((URL)url);
                zipFile = new JarFile(file);
            } else {
                Enumeration<URL> en = GraphicGenerator.class.getClassLoader().getResources(pathPrefix);
                if (en.hasMoreElements()) {
                    url = en.nextElement();
                    URLConnection urlConnection = url.openConnection();
                    if (urlConnection instanceof JarURLConnection) {
                        JarURLConnection urlConn = (JarURLConnection)urlConnection;
                        zipFile = urlConn.getJarFile();
                    } else if ("file".equals(url.getProtocol())) {
                        File directory = new File(url.getPath());
                        return Lists.newArrayList((Object[])directory.list()).iterator();
                    }
                }
            }
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!name.startsWith(pathPrefix) || !name.endsWith(filenameExtension)) continue;
                int lastSlash = name.lastIndexOf(47);
                if (lastSlash != -1) {
                    name = name.substring(lastSlash + 1);
                }
                names.add(name);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return names.iterator();
    }

    public static Density pathToDensity(String iconPath) {
        iconPath = FileUtils.toSystemIndependentPath((String)iconPath);
        iconPath = iconPath.substring(0, iconPath.lastIndexOf(47) + 1);
        for (Density density : Density.values()) {
            if (!DENSITY_PATTERNS.get(density).matcher(iconPath).matches()) continue;
            return density;
        }
        return null;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Density density : Density.values()) {
            builder.put((Object)density, (Object)Pattern.compile(String.format(".*[^a-z]%s[^a-z].*", density.getResourceValue()), 2));
        }
        DENSITY_PATTERNS = builder.build();
    }

    public static enum Style {
        SIMPLE("fore1");

        public final String id;

        private Style(String id) {
            this.id = id;
        }
    }

    public static enum Shape {
        NONE("none"),
        CIRCLE("circle"),
        SQUARE("square"),
        VRECT("vrect"),
        HRECT("hrect"),
        SQUARE_DOG("square_dogear"),
        VRECT_DOG("vrect_dogear"),
        HRECT_DOG("hrect_dogear");

        public final String id;

        private Shape(String id) {
            this.id = id;
        }
    }

    public static enum IconFolderKind {
        DRAWABLE,
        MIPMAP,
        MIPMAP_V26,
        DRAWABLE_NO_DPI,
        VALUES;

    }

    public static class Options {
        public int minSdk = 1;
        public BufferedImage sourceImage;
        public Density density = Density.XHIGH;
        public IconFolderKind iconFolderKind = IconFolderKind.DRAWABLE;
    }
}

