/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.device;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.TimeoutException;
import com.android.hierarchyviewerlib.device.IHvDevice;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractHvDevice
implements IHvDevice {
    private static final String TAG = "HierarchyViewer";

    @Override
    public Image getScreenshotImage() {
        IDevice device = this.getDevice();
        final AtomicReference imageRef = new AtomicReference();
        try {
            final RawImage screenshot = device.getScreenshot();
            if (screenshot == null) {
                return null;
            }
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    ImageData imageData = new ImageData(screenshot.width, screenshot.height, screenshot.bpp, new PaletteData(screenshot.getRedMask(), screenshot.getGreenMask(), screenshot.getBlueMask()), 1, screenshot.data);
                    imageRef.set(new Image((Device)Display.getDefault(), imageData));
                }
            });
            return (Image)imageRef.get();
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("Unable to load screenshot from device " + device.getName()));
        }
        catch (TimeoutException e) {
            Log.e((String)TAG, (String)("Timeout loading screenshot from device " + device.getName()));
        }
        catch (AdbCommandRejectedException e) {
            Log.e((String)TAG, (String)("Adb rejected command to load screenshot from device " + device.getName()));
        }
        return null;
    }
}

