/*
 * Decompiled with CFR 0.152.
 */
package com.android.fakeadbserver.devicecommandhandlers.ddmsHandlers;

import com.android.fakeadbserver.ClientState;
import com.android.fakeadbserver.CommandHandler;
import com.android.fakeadbserver.devicecommandhandlers.ddmsHandlers.JdwpDdmsPacket;
import com.android.fakeadbserver.devicecommandhandlers.ddmsHandlers.JdwpDdmsPacketHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public class HeloHandler
extends CommandHandler
implements JdwpDdmsPacketHandler {
    public static final int CHUNK_TYPE = JdwpDdmsPacket.encodeChunkType("HELO");
    private static final String VM_IDENTIFIER = "FakeVM";
    private static final int HELO_CHUNK_HEADER_LENGTH = 16;
    private static final int VERSION = 9999;

    @Override
    public boolean handlePacket(JdwpDdmsPacket packet, ClientState client, OutputStream oStream) {
        String appName = client.getPackageName();
        int payloadLength = 16 + (VM_IDENTIFIER.length() + appName.length()) * 2;
        byte[] payload = new byte[payloadLength];
        ByteBuffer payloadBuffer = ByteBuffer.wrap(payload);
        payloadBuffer.putInt(9999);
        payloadBuffer.putInt(client.getPid());
        payloadBuffer.putInt(VM_IDENTIFIER.length());
        payloadBuffer.putInt(appName.length());
        for (char c : VM_IDENTIFIER.toCharArray()) {
            payloadBuffer.putChar(c);
        }
        for (char c : appName.toCharArray()) {
            payloadBuffer.putChar(c);
        }
        JdwpDdmsPacket responsePacket = JdwpDdmsPacket.createResponse(packet.getId(), CHUNK_TYPE, payload);
        try {
            responsePacket.write(oStream);
        }
        catch (IOException e) {
            return HeloHandler.writeFailResponse(oStream, "Could not write HELO response packet");
        }
        if (client.getIsWaiting()) {
            byte[] waitPayload = new byte[1];
            JdwpDdmsPacket waitPacket = JdwpDdmsPacket.create(JdwpDdmsPacket.encodeChunkType("WAIT"), waitPayload);
            try {
                waitPacket.write(oStream);
            }
            catch (IOException e) {
                return HeloHandler.writeFailResponse(oStream, "Could not write WAIT packet");
            }
        }
        return true;
    }
}

