/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.sourcelookup;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.internal.ui.views.launch.DebugElementAdapterFactory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.contexts.IDebugContextService;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class SourceLookupService
implements IDebugContextListener,
ISourceDisplay {
    private IWorkbenchWindow fWindow;
    private IDebugContextService fDebugContextService;
    static /* synthetic */ Class class$0;

    public SourceLookupService(IWorkbenchWindow window) {
        this.fWindow = window;
        this.fDebugContextService = DebugUITools.getDebugContextManager().getContextService(window);
        this.fDebugContextService.addDebugContextListener(this);
    }

    public void dispose() {
        this.fDebugContextService.removeDebugContextListener(this);
        this.fWindow = null;
    }

    public synchronized void debugContextChanged(DebugContextEvent event) {
        if ((event.getFlags() & 1) > 0) {
            this.displaySource(event.getContext(), event.getDebugContextProvider().getPart(), false);
        }
    }

    protected synchronized void displaySource(ISelection selection, IWorkbenchPart part, boolean force) {
        IStructuredSelection structuredSelection;
        if (this.fWindow == null) {
            return;
        }
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            Object context = structuredSelection.getFirstElement();
            IWorkbenchPage page = null;
            page = part == null ? this.fWindow.getActivePage() : part.getSite().getPage();
            this.displaySource(context, page, force);
        }
    }

    public void displaySource(Object context, IWorkbenchPage page, boolean forceSourceLookup) {
        if (context instanceof IAdaptable) {
            ISourceDisplay adapter;
            IAdaptable adaptable = (IAdaptable)context;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.debug.ui.sourcelookup.ISourceDisplay");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((adapter = (ISourceDisplay)adaptable.getAdapter((Class)clazz)) == null && !(context instanceof PlatformObject)) {
                DebugElementAdapterFactory debugElementAdapterFactory = new DebugElementAdapterFactory();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.debug.ui.sourcelookup.ISourceDisplay");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                adapter = (ISourceDisplay)debugElementAdapterFactory.getAdapter(context, clazz2);
            }
            if (adapter != null) {
                adapter.displaySource(context, page, forceSourceLookup);
            }
        }
    }
}

