/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.eclipse.monitor;

import com.android.ide.eclipse.monitor.MonitorPlugin;
import com.android.ide.eclipse.monitor.MonitorWorkbenchAdvisor;
import com.android.ide.eclipse.monitor.SdkLocationChooserDialog;
import com.android.ide.eclipse.monitor.SdkToolsLocator;
import com.android.prefs.AndroidLocation;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class MonitorApplication
implements IApplication {
    private static final String SDK_PATH_ENVVAR = "com.android.sdk.path";
    private static final String MONITOR_WORKSPACE_PATH = "monitor-workspace";

    public Object start(IApplicationContext context) throws Exception {
        Display display = PlatformUI.createDisplay();
        Location instanceLoc = Platform.getInstanceLocation();
        IPath workspacePath = new Path(AndroidLocation.getFolder()).append(MONITOR_WORKSPACE_PATH);
        instanceLoc.set(workspacePath.toFile().toURI().toURL(), true);
        String sdkPath = this.findSdkPath(display);
        if (!this.isValidSdkLocation(sdkPath)) {
            return -1;
        }
        MonitorPlugin.getDefault().setSdkFolder(new File(sdkPath));
        try {
            int returnCode = PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new MonitorWorkbenchAdvisor());
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            display.dispose();
        }
    }

    public void stop() {
        if (!PlatformUI.isWorkbenchRunning()) {
            return;
        }
        final IWorkbench workbench = PlatformUI.getWorkbench();
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    private String findSdkPath(Display display) {
        String toolsFolder;
        File libFolder;
        String sdkLocation = System.getProperty(SDK_PATH_ENVVAR);
        if (this.isValidSdkLocation(sdkLocation)) {
            return sdkLocation;
        }
        sdkLocation = System.getenv(SDK_PATH_ENVVAR);
        if (this.isValidSdkLocation(sdkLocation)) {
            return sdkLocation;
        }
        Location install = Platform.getInstallLocation();
        if (install != null && install.getURL() != null && (libFolder = new File(install.getURL().getFile()).getParentFile()) != null && (toolsFolder = libFolder.getParent()) != null && this.isValidSdkLocation(sdkLocation = new File(toolsFolder).getParent())) {
            MonitorPlugin.getDdmsPreferenceStore().setLastSdkPath(sdkLocation);
            return sdkLocation;
        }
        sdkLocation = MonitorPlugin.getDdmsPreferenceStore().getLastSdkPath();
        if (this.isValidSdkLocation(sdkLocation)) {
            return sdkLocation;
        }
        sdkLocation = this.getSdkLocationFromUser(new Shell(display));
        if (this.isValidSdkLocation(sdkLocation)) {
            MonitorPlugin.getDdmsPreferenceStore().setLastSdkPath(sdkLocation);
        }
        return sdkLocation;
    }

    private boolean isValidSdkLocation(String sdkLocation) {
        if (sdkLocation == null) {
            return false;
        }
        if (sdkLocation.trim().length() == 0) {
            return false;
        }
        SdkToolsLocator locator = new SdkToolsLocator(new File(sdkLocation));
        return locator.isValidInstallation() == SdkToolsLocator.SdkInstallStatus.VALID;
    }

    private String getSdkLocationFromUser(Shell shell) {
        SdkLocationChooserDialog dlg = new SdkLocationChooserDialog(shell);
        if (dlg.open() == 0) {
            return dlg.getPath();
        }
        return null;
    }
}

