/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.util.ThreadLocalCachedByteArray;
import com.intellij.util.SystemProperties;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.text.StringFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.iq80.snappy.CorruptionException;
import org.iq80.snappy.Snappy;
import org.jetbrains.annotations.NotNull;

public class CompressionUtil {
    private static final int COMPRESSION_THRESHOLD = 64;
    private static final ThreadLocalCachedByteArray spareBufferLocal = new ThreadLocalCachedByteArray();
    private static final AtomicInteger myCompressionRequests = new AtomicInteger();
    private static final AtomicLong myCompressionTime = new AtomicLong();
    private static final AtomicInteger myDecompressionRequests = new AtomicInteger();
    private static final AtomicLong myDecompressionTime = new AtomicLong();
    private static final AtomicLong myDecompressedSize = new AtomicLong();
    private static final AtomicLong mySizeBeforeCompression = new AtomicLong();
    private static final AtomicLong mySizeAfterCompression = new AtomicLong();
    public static final boolean DUMP_COMPRESSION_STATS = SystemProperties.getBooleanProperty("idea.dump.compression.stats", false);
    private static final int STRING_COMPRESSION_THRESHOLD = 1024;

    public static int writeCompressed(@NotNull DataOutput out, @NotNull byte[] bytes, int length) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/CompressionUtil", "writeCompressed"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/util/CompressionUtil", "writeCompressed"));
        }
        if (length > 64) {
            byte[] compressedOutputBuffer = spareBufferLocal.getBuffer(Snappy.maxCompressedLength((int)length));
            int compressedSize = Snappy.compress((byte[])bytes, (int)0, (int)length, (byte[])compressedOutputBuffer, (int)0);
            DataInputOutputUtil.writeINT(out, -compressedSize);
            out.write(compressedOutputBuffer, 0, compressedSize);
            return compressedSize;
        }
        DataInputOutputUtil.writeINT(out, length);
        out.write(bytes, 0, length);
        return length;
    }

    public static int writeCompressedWithoutOriginalBufferLength(@NotNull DataOutput out, @NotNull byte[] bytes, int length) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/util/CompressionUtil", "writeCompressedWithoutOriginalBufferLength"));
        }
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/util/CompressionUtil", "writeCompressedWithoutOriginalBufferLength"));
        }
        long started = DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L;
        byte[] compressedOutputBuffer = spareBufferLocal.getBuffer(Snappy.maxCompressedLength((int)length));
        int compressedSize = Snappy.compress((byte[])bytes, (int)0, (int)length, (byte[])compressedOutputBuffer, (int)0);
        long time = (DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L) - started;
        mySizeAfterCompression.addAndGet(compressedSize);
        mySizeBeforeCompression.addAndGet(length);
        int requests = myCompressionRequests.incrementAndGet();
        long l = myCompressionTime.addAndGet(time);
        if (DUMP_COMPRESSION_STATS && requests % 1000 == 0) {
            System.out.println("Compressed " + requests + " times, size:" + mySizeBeforeCompression + "->" + mySizeAfterCompression + " for " + l / 1000000L + "ms");
        }
        DataInputOutputUtil.writeINT(out, compressedSize);
        out.write(compressedOutputBuffer, 0, compressedSize);
        return compressedSize;
    }

    @NotNull
    public static byte[] readCompressedWithoutOriginalBufferLength(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/CompressionUtil", "readCompressedWithoutOriginalBufferLength"));
        }
        int size = DataInputOutputUtil.readINT(in);
        byte[] bytes = spareBufferLocal.getBuffer(size);
        in.readFully(bytes, 0, size);
        int decompressedRequests = myDecompressionRequests.incrementAndGet();
        long started = DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L;
        byte[] decompressedResult = Snappy.uncompress((byte[])bytes, (int)0, (int)size);
        long doneTime = (DUMP_COMPRESSION_STATS ? System.nanoTime() : 0L) - started;
        long decompressedSize = myDecompressedSize.addAndGet(size);
        long decompressedTime = myDecompressionTime.addAndGet(doneTime);
        if (DUMP_COMPRESSION_STATS && decompressedRequests % 1000 == 0) {
            System.out.println("Decompressed " + decompressedRequests + " times, size: " + decompressedSize + " for " + decompressedTime / 1000000L + "ms");
        }
        if (decompressedResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "readCompressedWithoutOriginalBufferLength"));
        }
        return decompressedResult;
    }

    @NotNull
    public static byte[] readCompressed(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/util/CompressionUtil", "readCompressed"));
        }
        int size = DataInputOutputUtil.readINT(in);
        if (size < 0) {
            byte[] bytes = spareBufferLocal.getBuffer(-size);
            in.readFully(bytes, 0, -size);
            byte[] byArray = Snappy.uncompress((byte[])bytes, (int)0, (int)(-size));
            if (byArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "readCompressed"));
            }
            return byArray;
        }
        byte[] bytes = new byte[size];
        in.readFully(bytes);
        if (bytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "readCompressed"));
        }
        return bytes;
    }

    @NotNull
    public static CharSequence uncompressCharSequence(@NotNull Object string, @NotNull Charset charset) {
        String string2;
        block6: {
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/util/CompressionUtil", "uncompressCharSequence"));
            }
            if (charset == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/util/CompressionUtil", "uncompressCharSequence"));
            }
            if (string instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)string;
                if (charSequence == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "uncompressCharSequence"));
                }
                return charSequence;
            }
            byte[] b = (byte[])string;
            try {
                int uncompressedLength = Snappy.getUncompressedLength((byte[])b, (int)0);
                byte[] bytes = spareBufferLocal.getBuffer(uncompressedLength);
                int bytesLength = Snappy.uncompress((byte[])b, (int)0, (int)b.length, (byte[])bytes, (int)0);
                string2 = new String(bytes, 0, bytesLength, charset);
                if (string2 != null) break block6;
            }
            catch (CorruptionException ex) {
                throw new RuntimeException(ex);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "uncompressCharSequence"));
        }
        return string2;
    }

    @NotNull
    public static Object compressCharSequence(@NotNull CharSequence string, @NotNull Charset charset) {
        byte[] byArray;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/util/CompressionUtil", "compressCharSequence"));
        }
        if (charset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charset", "com/intellij/util/CompressionUtil", "compressCharSequence"));
        }
        if (string.length() < 1024) {
            if (string instanceof CharBuffer && ((CharBuffer)string).capacity() > 1024) {
                string = string.toString();
            }
            CharSequence charSequence = string;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "compressCharSequence"));
            }
            return charSequence;
        }
        try {
            byArray = Snappy.compress((byte[])string.toString().getBytes(charset));
        }
        catch (CorruptionException ex) {
            ex.printStackTrace();
            CharSequence charSequence = string;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "compressCharSequence"));
            }
            return charSequence;
        }
        if (byArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "compressCharSequence"));
        }
        return byArray;
    }

    @NotNull
    public static Object compressStringRawBytes(@NotNull CharSequence string) {
        Object object;
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/util/CompressionUtil", "compressStringRawBytes"));
        }
        int length = string.length();
        if (length < 1024) {
            if (string instanceof CharBuffer && ((CharBuffer)string).capacity() > 1024) {
                string = string.toString();
            }
            CharSequence charSequence = string;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "compressStringRawBytes"));
            }
            return charSequence;
        }
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(length);
            DataOutputStream out = new DataOutputStream(bytes);
            DataInputOutputUtil.writeINT(out, length);
            for (int i = 0; i < length; ++i) {
                char c = string.charAt(i);
                DataInputOutputUtil.writeINT(out, c);
            }
            byte[] compressedBytes = Snappy.compress((byte[])bytes.toByteArray());
            object = compressedBytes.length < length * 2 ? compressedBytes : (Object)string;
        }
        catch (CorruptionException ex) {
            ex.printStackTrace();
            CharSequence charSequence = string;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "compressStringRawBytes"));
            }
            return charSequence;
        }
        catch (IOException e) {
            e.printStackTrace();
            CharSequence charSequence = string;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "compressStringRawBytes"));
            }
            return charSequence;
        }
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "compressStringRawBytes"));
        }
        return object;
    }

    @NotNull
    public static CharSequence uncompressStringRawBytes(@NotNull Object compressed) {
        String string;
        if (compressed == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compressed", "com/intellij/util/CompressionUtil", "uncompressStringRawBytes"));
        }
        if (compressed instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)compressed;
            if (charSequence == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "uncompressStringRawBytes"));
            }
            return charSequence;
        }
        byte[] b = (byte[])compressed;
        try {
            int uncompressedLength = Snappy.getUncompressedLength((byte[])b, (int)0);
            byte[] bytes = spareBufferLocal.getBuffer(uncompressedLength);
            int bytesLength = Snappy.uncompress((byte[])b, (int)0, (int)b.length, (byte[])bytes, (int)0);
            ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes, 0, bytesLength);
            DataInputStream in = new DataInputStream(byteStream);
            int len = DataInputOutputUtil.readINT(in);
            char[] chars = new char[len];
            for (int i = 0; i < len; ++i) {
                int c = DataInputOutputUtil.readINT(in);
                chars[i] = (char)c;
            }
            string = StringFactory.createShared(chars);
        }
        catch (CorruptionException ex) {
            throw new RuntimeException(ex);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/CompressionUtil", "uncompressStringRawBytes"));
        }
        return string;
    }
}

