/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.security;

import com.intellij.util.containers.ContainerUtilRt;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;

public class CompositeX509TrustManager
implements X509TrustManager {
    private final List<X509TrustManager> myManagers;

    public CompositeX509TrustManager(TrustManager[] ... managerSets) {
        if (managerSets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managerSets", "com/intellij/security/CompositeX509TrustManager", "<init>"));
        }
        this.myManagers = ContainerUtilRt.newArrayList();
        TrustManager[][] trustManagerArray = managerSets;
        int n = trustManagerArray.length;
        for (int i = 0; i < n; ++i) {
            TrustManager[] set;
            for (TrustManager manager : set = trustManagerArray[i]) {
                if (!(manager instanceof X509TrustManager)) continue;
                this.myManagers.add((X509TrustManager)manager);
            }
        }
    }

    public void checkClientTrusted(X509Certificate[] certificates, String s) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    public void checkServerTrusted(X509Certificate[] certificates, String s) throws CertificateException {
        for (X509TrustManager manager : this.myManagers) {
            try {
                manager.checkServerTrusted(certificates, s);
                return;
            }
            catch (CertificateException certificateException) {
            }
        }
        throw new CertificateException("No trusting managers found for " + s);
    }

    @NotNull
    public X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[]{};
        if (x509CertificateArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/security/CompositeX509TrustManager", "getAcceptedIssuers"));
        }
        return x509CertificateArray;
    }
}

