/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class StubTree
extends ObjectStubTree<StubElement<?>> {
    public StubTree(@NotNull PsiFileStub root) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/StubTree", "<init>"));
        }
        this(root, true);
    }

    public StubTree(@NotNull PsiFileStub root, boolean withBackReference) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/StubTree", "<init>"));
        }
        super((ObjectStubBase)((Object)root), withBackReference);
    }

    @Override
    @NotNull
    public List<StubElement<?>> getPlainListFromAllRoots() {
        PsiFileStub[] roots = this.getRoot().getStubRoots();
        if (roots.length == 1) {
            List<StubElement<?>> list = super.getPlainListFromAllRoots();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubTree", "getPlainListFromAllRoots"));
            }
            return list;
        }
        List<StubElement<?>> list = ContainerUtil.concat(roots, stub -> {
            ObjectStubTree existingTree = (ObjectStubTree)stub.getUserData(STUB_TO_TREE_REFERENCE);
            return existingTree != null ? existingTree.getPlainList() : new StubTree((PsiFileStub)stub, false).getPlainList();
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubTree", "getPlainListFromAllRoots"));
        }
        return list;
    }

    @Override
    @NotNull
    public PsiFileStub getRoot() {
        PsiFileStub psiFileStub = (PsiFileStub)((Object)this.myRoot);
        if (psiFileStub == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubTree", "getRoot"));
        }
        return psiFileStub;
    }
}

