/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.ASTNode;
import com.intellij.lang.FileASTNode;
import com.intellij.lang.LighterAST;
import com.intellij.lang.LighterASTNode;
import com.intellij.lang.TreeBackedLighterAST;
import com.intellij.openapi.diagnostic.LogUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.StubBuilder;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.stubs.ILightStubElementType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.PsiFileStubImpl;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.ILightStubFileElementType;
import com.intellij.psi.tree.IStubFileElementType;
import com.intellij.util.containers.BooleanStack;
import com.intellij.util.containers.Stack;
import gnu.trove.TIntStack;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LightStubBuilder
implements StubBuilder {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.stubs.LightStubBuilder");
    public static final ThreadLocal<LighterAST> FORCED_AST = new ThreadLocal();

    @Override
    public StubElement buildStubTree(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        LighterAST tree = FORCED_AST.get();
        if (tree == null) {
            FileType fileType = file.getFileType();
            if (!(fileType instanceof LanguageFileType)) {
                LOG.error("File is not of LanguageFileType: " + fileType + ", " + file);
                return null;
            }
            assert (file instanceof PsiFileImpl);
            IStubFileElementType contentType = ((PsiFileImpl)file).getElementTypeForStubBuilder();
            if (contentType == null) {
                LOG.error("File is not of IStubFileElementType: " + file);
                return null;
            }
            FileASTNode node = file.getNode();
            tree = node.getElementType() instanceof ILightStubFileElementType ? node.getLighterAST() : new TreeBackedLighterAST(node);
        } else {
            FORCED_AST.set(null);
        }
        if (tree == null) {
            return null;
        }
        StubElement rootStub = this.createStubForFile(file, tree);
        this.buildStubTree(tree, tree.getRoot(), rootStub);
        return rootStub;
    }

    @NotNull
    protected StubElement createStubForFile(@NotNull PsiFile file, @NotNull LighterAST tree) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        PsiFileStubImpl<PsiFile> psiFileStubImpl = new PsiFileStubImpl<PsiFile>(file);
        if (psiFileStubImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder", "createStubForFile"));
        }
        return psiFileStubImpl;
    }

    protected void buildStubTree(@NotNull LighterAST tree, @NotNull LighterASTNode root, @NotNull StubElement rootStub) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        if (rootStub == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootStub", "com/intellij/psi/stubs/LightStubBuilder", "buildStubTree"));
        }
        Stack<LighterASTNode> parents = new Stack<LighterASTNode>();
        TIntStack childNumbers = new TIntStack();
        BooleanStack parentsStubbed = new BooleanStack();
        Stack<List> kinderGarden = new Stack<List>();
        Stack<StubElement> parentStubs = new Stack<StubElement>();
        LighterASTNode parent = null;
        LighterASTNode element = root;
        List children = null;
        int childNumber = 0;
        StubElement parentStub = rootStub;
        boolean immediateParentStubbed = true;
        block0: while (element != null) {
            List kids;
            boolean hasStub;
            StubElement stub = LightStubBuilder.createStub(tree, element, parentStub);
            boolean bl = hasStub = stub != parentStub || parent == null;
            if (hasStub && !immediateParentStubbed) {
                ((ObjectStubBase)((Object)stub)).markDangling();
            }
            if (!(parent != null && this.skipNode(tree, parent, element) || (kids = tree.getChildren(element)).isEmpty())) {
                if (parent != null) {
                    parents.push(parent);
                    childNumbers.push(childNumber);
                    kinderGarden.push(children);
                    parentStubs.push(parentStub);
                    parentsStubbed.push(immediateParentStubbed);
                }
                parent = element;
                immediateParentStubbed = hasStub;
                children = kids;
                childNumber = 0;
                element = children.get(0);
                parentStub = stub;
                if (!this.skipNode(tree, parent, element)) continue;
            }
            while (children != null && ++childNumber < children.size()) {
                element = (LighterASTNode)children.get(childNumber);
                if (this.skipNode(tree, parent, element)) continue;
                continue block0;
            }
            element = null;
            while (!parents.isEmpty()) {
                parent = (LighterASTNode)parents.pop();
                childNumber = childNumbers.pop();
                children = (List)kinderGarden.pop();
                parentStub = (StubElement)parentStubs.pop();
                immediateParentStubbed = parentsStubbed.pop();
                while (++childNumber < children.size()) {
                    element = (LighterASTNode)children.get(childNumber);
                    if (this.skipNode(tree, parent, element)) continue;
                    continue block0;
                }
                element = null;
            }
        }
    }

    @NotNull
    private static StubElement createStub(LighterAST tree, LighterASTNode element, StubElement parentStub) {
        IElementType elementType = element.getTokenType();
        if (elementType instanceof IStubElementType) {
            if (elementType instanceof ILightStubElementType) {
                ILightStubElementType lightElementType = (ILightStubElementType)elementType;
                if (lightElementType.shouldCreateStub(tree, element, parentStub)) {
                    Object StubT = lightElementType.createStub(tree, element, parentStub);
                    if (StubT == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder", "createStub"));
                    }
                    return StubT;
                }
            } else {
                LOG.error("Element is not of ILightStubElementType: " + LogUtil.objectAndClass(elementType) + ", " + element);
            }
        }
        StubElement stubElement = parentStub;
        if (stubElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/LightStubBuilder", "createStub"));
        }
        return stubElement;
    }

    private boolean skipNode(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/LightStubBuilder", "skipNode"));
        }
        if (tree instanceof TreeBackedLighterAST) {
            return this.skipChildProcessingWhenBuildingStubs(((TreeBackedLighterAST)tree).unwrap(parent), ((TreeBackedLighterAST)tree).unwrap(node));
        }
        return this.skipChildProcessingWhenBuildingStubs(tree, parent, node);
    }

    @Override
    public boolean skipChildProcessingWhenBuildingStubs(@NotNull ASTNode parent, @NotNull ASTNode node) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }

    protected boolean skipChildProcessingWhenBuildingStubs(@NotNull LighterAST tree, @NotNull LighterASTNode parent, @NotNull LighterASTNode node) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/psi/stubs/LightStubBuilder", "skipChildProcessingWhenBuildingStubs"));
        }
        return false;
    }
}

