/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionProvider;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class ElementDescriptionUtil {
    private ElementDescriptionUtil() {
    }

    @NotNull
    public static String getElementDescription(@NotNull PsiElement element, @NotNull ElementDescriptionLocation location) {
        String result;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/ElementDescriptionUtil", "getElementDescription"));
        }
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/intellij/psi/ElementDescriptionUtil", "getElementDescription"));
        }
        for (ElementDescriptionProvider provider : Extensions.getExtensions(ElementDescriptionProvider.EP_NAME)) {
            String result2 = provider.getElementDescription(element, location);
            if (result2 == null) continue;
            String string = result2;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ElementDescriptionUtil", "getElementDescription"));
            }
            return string;
        }
        ElementDescriptionProvider defaultProvider = location.getDefaultProvider();
        if (defaultProvider != null && (result = defaultProvider.getElementDescription(element, location)) != null) {
            String string = result;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ElementDescriptionUtil", "getElementDescription"));
            }
            return string;
        }
        String string = element.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/ElementDescriptionUtil", "getElementDescription"));
        }
        return string;
    }
}

