/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.event.DocumentEvent;
import org.jetbrains.annotations.NotNull;

class PersistentRangeMarkerUtil {
    PersistentRangeMarkerUtil() {
    }

    static boolean shouldTranslateViaDiff(@NotNull DocumentEvent e, int rangeStart, int rangeEnd) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/editor/impl/PersistentRangeMarkerUtil", "shouldTranslateViaDiff"));
        }
        if (e.isWholeTextReplaced()) {
            return true;
        }
        if (e.getOffset() >= rangeEnd || e.getOffset() + e.getOldLength() <= rangeStart) {
            return false;
        }
        return (double)Math.max(e.getNewLength(), e.getOldLength()) * 1.0 / (double)e.getDocument().getTextLength() >= 0.8;
    }
}

