/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CompositeFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomFoldingBuilder
extends FoldingBuilderEx
implements PossiblyDumbAware {
    private CustomFoldingProvider myDefaultProvider;
    private static final RegistryValue myMaxLookupDepth = Registry.get("custom.folding.max.lookup.depth");
    private static final ThreadLocal<Set<ASTNode>> ourCustomRegionElements = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public final FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        ourCustomRegionElements.set(new HashSet());
        ArrayList<FoldingDescriptor> descriptors = new ArrayList<FoldingDescriptor>();
        try {
            if (CustomFoldingProvider.getAllProviders().length > 0) {
                this.myDefaultProvider = null;
                ASTNode rootNode = root.getNode();
                if (rootNode != null) {
                    this.addCustomFoldingRegionsRecursively(new FoldingStack(rootNode), rootNode, descriptors, 0);
                }
            }
            this.buildLanguageFoldRegions(descriptors, root, document, quick);
        }
        finally {
            ourCustomRegionElements.set(null);
        }
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    @Override
    @NotNull
    public final FoldingDescriptor[] buildFoldRegions(@NotNull ASTNode node, @NotNull Document document) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        FoldingDescriptor[] foldingDescriptorArray = this.buildFoldRegions(node.getPsi(), document, false);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    protected abstract void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> var1, @NotNull PsiElement var2, @NotNull Document var3, boolean var4);

    private void addCustomFoldingRegionsRecursively(@NotNull FoldingStack foldingStack, @NotNull ASTNode node, @NotNull List<FoldingDescriptor> descriptors, int currDepth) {
        if (foldingStack == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "foldingStack", "com/intellij/lang/folding/CustomFoldingBuilder", "addCustomFoldingRegionsRecursively"));
        }
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CustomFoldingBuilder", "addCustomFoldingRegionsRecursively"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "com/intellij/lang/folding/CustomFoldingBuilder", "addCustomFoldingRegionsRecursively"));
        }
        FoldingStack localFoldingStack = this.isCustomFoldingRoot(node) ? new FoldingStack(node) : foldingStack;
        for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (this.isCustomRegionStart(child)) {
                localFoldingStack.push(child);
                continue;
            }
            if (this.isCustomRegionEnd(child)) {
                if (localFoldingStack.isEmpty()) continue;
                ASTNode startNode = (ASTNode)localFoldingStack.pop();
                int startOffset = startNode.getTextRange().getStartOffset();
                TextRange range = new TextRange(startOffset, child.getTextRange().getEndOffset());
                startNode.getPsi().putUserData(CompositeFoldingBuilder.FOLDING_BUILDER, this);
                descriptors.add(new FoldingDescriptor(startNode, range));
                Set<ASTNode> nodeSet = ourCustomRegionElements.get();
                nodeSet.add(startNode);
                nodeSet.add(child);
                continue;
            }
            if (currDepth >= myMaxLookupDepth.asInteger()) continue;
            this.addCustomFoldingRegionsRecursively(localFoldingStack, child, descriptors, currDepth + 1);
        }
    }

    @Override
    public final String getPlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        String elementText;
        CustomFoldingProvider defaultProvider;
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CustomFoldingBuilder", "getPlaceholderText"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/lang/folding/CustomFoldingBuilder", "getPlaceholderText"));
        }
        if (this.isCustomFoldingCandidate(node) && (defaultProvider = this.getDefaultProvider(elementText = node.getText())) != null && defaultProvider.isCustomRegionStart(elementText)) {
            return defaultProvider.getPlaceholderText(elementText);
        }
        return this.getLanguagePlaceholderText(node, range);
    }

    protected abstract String getLanguagePlaceholderText(@NotNull ASTNode var1, @NotNull TextRange var2);

    @Override
    public final String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CustomFoldingBuilder", "getPlaceholderText"));
        }
        return "...";
    }

    @Override
    public final boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CustomFoldingBuilder", "isCollapsedByDefault"));
        }
        if (this.isCustomRegionStart(node)) {
            String childText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(childText);
            return defaultProvider != null && defaultProvider.isCollapsedByDefault(childText);
        }
        return this.isRegionCollapsedByDefault(node);
    }

    protected abstract boolean isRegionCollapsedByDefault(@NotNull ASTNode var1);

    public final boolean isCustomRegionStart(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CustomFoldingBuilder", "isCustomRegionStart"));
        }
        if (this.isCustomFoldingCandidate(node)) {
            String nodeText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(nodeText);
            return defaultProvider != null && defaultProvider.isCustomRegionStart(nodeText);
        }
        return false;
    }

    protected final boolean isCustomRegionEnd(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CustomFoldingBuilder", "isCustomRegionEnd"));
        }
        if (this.isCustomFoldingCandidate(node)) {
            String nodeText = node.getText();
            CustomFoldingProvider defaultProvider = this.getDefaultProvider(nodeText);
            return defaultProvider != null && defaultProvider.isCustomRegionEnd(nodeText);
        }
        return false;
    }

    protected static boolean isCustomRegionElement(PsiElement element) {
        Set<ASTNode> set = ourCustomRegionElements.get();
        return set != null && element != null && set.contains(element.getNode());
    }

    @Nullable
    private CustomFoldingProvider getDefaultProvider(String elementText) {
        if (this.myDefaultProvider == null) {
            for (CustomFoldingProvider provider : CustomFoldingProvider.getAllProviders()) {
                if (!provider.isCustomRegionStart(elementText) && !provider.isCustomRegionEnd(elementText)) continue;
                this.myDefaultProvider = provider;
            }
        }
        return this.myDefaultProvider;
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CustomFoldingBuilder", "isCustomFoldingCandidate"));
        }
        return node.getPsi() instanceof PsiComment;
    }

    public final boolean isCustomFoldingCandidate(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/lang/folding/CustomFoldingBuilder", "isCustomFoldingCandidate"));
        }
        ASTNode node = element.getNode();
        return node != null && this.isCustomFoldingCandidate(node);
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/lang/folding/CustomFoldingBuilder", "isCustomFoldingRoot"));
        }
        return node.getFirstChildNode() != null;
    }

    @Override
    public boolean isDumbAware() {
        return true;
    }

    private static class FoldingStack
    extends Stack<ASTNode> {
        @NotNull
        private final ASTNode owner;

        private FoldingStack(@NotNull ASTNode owner) {
            if (owner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/lang/folding/CustomFoldingBuilder$FoldingStack", "<init>"));
            }
            super(1);
            this.owner = owner;
        }

        @NotNull
        public ASTNode getOwner() {
            ASTNode aSTNode = this.owner;
            if (aSTNode == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/folding/CustomFoldingBuilder$FoldingStack", "getOwner"));
            }
            return aSTNode;
        }
    }
}

