/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.syntax;

import com.google.clearsilver.jsilver.syntax.analysis.DepthFirstAdapter;
import com.google.clearsilver.jsilver.syntax.node.AAltCommand;
import com.google.clearsilver.jsilver.syntax.node.ACallCommand;
import com.google.clearsilver.jsilver.syntax.node.ADataCommand;
import com.google.clearsilver.jsilver.syntax.node.ADefCommand;
import com.google.clearsilver.jsilver.syntax.node.AEachCommand;
import com.google.clearsilver.jsilver.syntax.node.AEscapeCommand;
import com.google.clearsilver.jsilver.syntax.node.AEvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AIfCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopIncCommand;
import com.google.clearsilver.jsilver.syntax.node.ALoopToCommand;
import com.google.clearsilver.jsilver.syntax.node.ALvarCommand;
import com.google.clearsilver.jsilver.syntax.node.ANameCommand;
import com.google.clearsilver.jsilver.syntax.node.ANoopCommand;
import com.google.clearsilver.jsilver.syntax.node.ASetCommand;
import com.google.clearsilver.jsilver.syntax.node.AUvarCommand;
import com.google.clearsilver.jsilver.syntax.node.AVarCommand;
import com.google.clearsilver.jsilver.syntax.node.AWithCommand;
import com.google.clearsilver.jsilver.syntax.node.Start;
import com.google.clearsilver.jsilver.syntax.node.TData;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StructuralWhitespaceStripper
extends DepthFirstAdapter {
    private static final String IWS = "[^\\S\\n]*";
    private static final Pattern INLINE_WHITESPACE = Pattern.compile("[^\\S\\n]*");
    private static final Pattern STARTS_WITH_NEWLINE = Pattern.compile("^[^\\S\\n]*\\n");
    private static final Pattern ENDS_WITH_NEWLINE = Pattern.compile("\\n[^\\S\\n]*$");
    private static final Pattern LEADING_WHITESPACE_AND_NEWLINE = Pattern.compile("^[^\\S\\n]*\\n(.*)$", 32);
    private static final Pattern TRAILING_WHITESPACE = Pattern.compile("^(.*?)[^\\S\\n]*$", 32);
    private boolean maybeChompWhitespace = true;
    private boolean currentLineContainsInlineComplexCommand = false;
    private ADataCommand firstChompedData = null;
    private List<ADataCommand> whitespaceData = new ArrayList<ADataCommand>();

    private static boolean isInlineWhitespace(String text) {
        return INLINE_WHITESPACE.matcher(text).matches();
    }

    private static boolean startsWithNewline(String text) {
        return STARTS_WITH_NEWLINE.matcher(text).find();
    }

    private static boolean endsWithNewline(String text) {
        return ENDS_WITH_NEWLINE.matcher(text).find();
    }

    private static String stripLeadingWhitespaceAndNewline(String text) {
        Matcher matcher = LEADING_WHITESPACE_AND_NEWLINE.matcher(text);
        if (!matcher.matches()) {
            throw new IllegalStateException("Text '" + text + "' should have leading whitespace/newline.");
        }
        return matcher.group(1);
    }

    private static String stripTrailingWhitespace(String text) {
        Matcher matcher = TRAILING_WHITESPACE.matcher(text);
        if (!matcher.matches()) {
            throw new AssertionError((Object)"Error in regular expression");
        }
        return matcher.group(1);
    }

    private static ADataCommand stripLeadingWhitespaceAndNewline(ADataCommand data) {
        if (data != null) {
            String text = StructuralWhitespaceStripper.stripLeadingWhitespaceAndNewline(data.getData().getText());
            if (text.isEmpty()) {
                data.replaceBy(new ANoopCommand());
                data = null;
            } else {
                data.setData(new TData(text));
            }
        }
        return data;
    }

    private static void stripTrailingWhitespace(ADataCommand data) {
        if (data != null) {
            String text = StructuralWhitespaceStripper.stripTrailingWhitespace(data.getData().getText());
            if (text.isEmpty()) {
                data.replaceBy(new ANoopCommand());
            } else {
                data.setData(new TData(text));
            }
        }
    }

    private static void removeWhitespace(List<ADataCommand> whitespaceData) {
        for (ADataCommand data : whitespaceData) {
            data.replaceBy(new ANoopCommand());
        }
        whitespaceData.clear();
    }

    @Override
    public void caseStart(Start node) {
        super.caseStart(node);
        if (this.maybeChompWhitespace) {
            StructuralWhitespaceStripper.stripTrailingWhitespace(this.firstChompedData);
            StructuralWhitespaceStripper.removeWhitespace(this.whitespaceData);
            this.firstChompedData = null;
        }
        if (this.firstChompedData != null) {
            throw new IllegalStateException("Unexpected first data node.");
        }
        if (!this.whitespaceData.isEmpty()) {
            throw new IllegalStateException("Unexpected data nodes.");
        }
    }

    @Override
    public void caseADataCommand(ADataCommand data) {
        String originalText = data.getData().getText();
        if (this.maybeChompWhitespace) {
            if (StructuralWhitespaceStripper.isInlineWhitespace(originalText)) {
                this.whitespaceData.add(data);
                return;
            }
            if (StructuralWhitespaceStripper.startsWithNewline(originalText)) {
                StructuralWhitespaceStripper.stripTrailingWhitespace(this.firstChompedData);
                StructuralWhitespaceStripper.removeWhitespace(this.whitespaceData);
                data = StructuralWhitespaceStripper.stripLeadingWhitespaceAndNewline(data);
                this.currentLineContainsInlineComplexCommand = false;
            } else {
                this.abortWhitespaceChompingForCurrentLine();
            }
        }
        this.maybeChompWhitespace = StructuralWhitespaceStripper.endsWithNewline(originalText);
        this.firstChompedData = this.maybeChompWhitespace ? data : null;
    }

    private void abortWhitespaceChompingForCurrentLine() {
        this.maybeChompWhitespace = false;
        this.currentLineContainsInlineComplexCommand = false;
        this.whitespaceData.clear();
    }

    @Override
    public void inAAltCommand(AAltCommand node) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inACallCommand(ACallCommand node) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inAEvarCommand(AEvarCommand node) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inALvarCommand(ALvarCommand node) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inANameCommand(ANameCommand node) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inASetCommand(ASetCommand node) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inAUvarCommand(AUvarCommand node) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    @Override
    public void inAVarCommand(AVarCommand node) {
        this.abortWhitespaceChompingForCurrentLine();
    }

    public void enterComplexCommand() {
        this.currentLineContainsInlineComplexCommand = true;
    }

    public void exitComplexCommand() {
        if (this.currentLineContainsInlineComplexCommand) {
            this.abortWhitespaceChompingForCurrentLine();
        }
    }

    @Override
    public void caseAAltCommand(AAltCommand node) {
        this.enterComplexCommand();
        super.caseAAltCommand(node);
        this.exitComplexCommand();
    }

    @Override
    public void caseADefCommand(ADefCommand node) {
        this.enterComplexCommand();
        super.caseADefCommand(node);
        this.exitComplexCommand();
    }

    @Override
    public void caseAEachCommand(AEachCommand node) {
        this.enterComplexCommand();
        super.caseAEachCommand(node);
        this.exitComplexCommand();
    }

    @Override
    public void caseAEscapeCommand(AEscapeCommand node) {
        this.enterComplexCommand();
        super.caseAEscapeCommand(node);
        this.exitComplexCommand();
    }

    @Override
    public void caseAIfCommand(AIfCommand node) {
        this.enterComplexCommand();
        super.caseAIfCommand(node);
        this.exitComplexCommand();
    }

    @Override
    public void caseALoopCommand(ALoopCommand node) {
        this.enterComplexCommand();
        super.caseALoopCommand(node);
        this.exitComplexCommand();
    }

    @Override
    public void caseALoopIncCommand(ALoopIncCommand node) {
        this.enterComplexCommand();
        super.caseALoopIncCommand(node);
        this.exitComplexCommand();
    }

    @Override
    public void caseALoopToCommand(ALoopToCommand node) {
        this.enterComplexCommand();
        super.caseALoopToCommand(node);
        this.exitComplexCommand();
    }

    @Override
    public void caseAWithCommand(AWithCommand node) {
        this.enterComplexCommand();
        super.caseAWithCommand(node);
        this.exitComplexCommand();
    }
}

