/*
 * Decompiled with CFR 0.152.
 */
package com.google.clearsilver.jsilver.functions.escape;

import com.google.clearsilver.jsilver.functions.TextFilter;
import java.io.IOException;

public abstract class SimpleEscapingFunction
implements TextFilter {
    private static final int CHAR_INDEX_LIMIT = 256;
    private String[] ESCAPE_STRINGS;

    protected SimpleEscapingFunction(char[] ESCAPE_CHARS) {
        this.setEscapeChars(ESCAPE_CHARS);
    }

    protected SimpleEscapingFunction() {
        this.ESCAPE_STRINGS = new String[0];
    }

    protected void setEscapeChars(char[] ESCAPE_CHARS) throws AssertionError {
        char c;
        int n = -1;
        for (char c2 : ESCAPE_CHARS) {
            if (c2 <= c) continue;
            c = c2;
        }
        if (c >= '\u0100') {
            throw new AssertionError((Object)"Cannot escape characters with values above 256");
        }
        this.ESCAPE_STRINGS = new String[c + true];
        for (char c2 : ESCAPE_CHARS) {
            this.ESCAPE_STRINGS[c2] = this.getEscapeString(c2);
        }
    }

    protected abstract String getEscapeString(char var1);

    public void filter(String in, Appendable out) throws IOException {
        int pos;
        int len = in.length();
        int start = pos = 0;
        while (pos < len) {
            String escapeString;
            char chr = in.charAt(pos);
            if (chr < this.ESCAPE_STRINGS.length && (escapeString = this.ESCAPE_STRINGS[chr]) != null) {
                if (pos > start) {
                    out.append(in, start, pos);
                }
                out.append(escapeString);
                start = ++pos;
                continue;
            }
            ++pos;
        }
        if (pos > start) {
            out.append(in, start, pos);
        }
    }
}

