/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmuilib;

import com.android.ddmlib.Log;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class ImageLoader {
    private static final String PATH = "/images/";
    private final HashMap<String, Image> mLoadedImages = new HashMap();
    private static final HashMap<Class<?>, ImageLoader> mInstances = new HashMap();
    private final Class<?> mClass;

    private ImageLoader(Class<?> theClass) {
        if (theClass == null) {
            theClass = ImageLoader.class;
        }
        this.mClass = theClass;
    }

    public static ImageLoader getDdmUiLibLoader() {
        return ImageLoader.getLoader(null);
    }

    public static ImageLoader getLoader(Class<?> theClass) {
        ImageLoader instance = mInstances.get(theClass);
        if (instance == null) {
            instance = new ImageLoader(theClass);
            mInstances.put(theClass, instance);
        }
        return instance;
    }

    public static void dispose() {
        for (ImageLoader loader : mInstances.values()) {
            loader.doDispose();
        }
    }

    private synchronized void doDispose() {
        for (Image image : this.mLoadedImages.values()) {
            image.dispose();
        }
        this.mLoadedImages.clear();
    }

    public ImageDescriptor loadDescriptor(String filename) {
        URL url = this.mClass.getResource(PATH + filename);
        return ImageDescriptor.createFromURL(url);
    }

    public synchronized Image loadImage(String filename, Display display) {
        Image img = this.mLoadedImages.get(filename);
        if (img == null) {
            String tmp = PATH + filename;
            InputStream imageStream = this.mClass.getResourceAsStream(tmp);
            if (imageStream != null) {
                img = new Image((Device)display, imageStream);
                this.mLoadedImages.put(filename, img);
            }
            if (img == null) {
                throw new RuntimeException("Failed to load " + tmp);
            }
        }
        return img;
    }

    public Image loadImage(Display display, String fileName, int width, int height, Color phColor) {
        Image img = this.loadImage(fileName, display);
        if (img == null) {
            Log.w((String)"ddms", (String)("Couldn't load " + fileName));
            if (width != -1 && height != -1) {
                return ImageLoader.createPlaceHolderArt(display, width, height, phColor != null ? phColor : display.getSystemColor(9));
            }
            return null;
        }
        return img;
    }

    public static Image createPlaceHolderArt(Display display, int width, int height, Color color) {
        Image img = new Image((Device)display, width, height);
        GC gc = new GC((Drawable)img);
        gc.setForeground(color);
        gc.drawLine(0, 0, width, height);
        gc.drawLine(0, height - 1, width, -1);
        gc.dispose();
        return img;
    }
}

