/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.blame;

import com.android.ide.common.blame.SourceFilePosition;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;

public final class Message {
    private final Kind mKind;
    private final String mText;
    private final List<SourceFilePosition> mSourceFilePositions;
    private final String mRawMessage;
    private final Optional<String> mToolName;

    public Message(Kind kind, String text, SourceFilePosition sourceFilePosition, SourceFilePosition ... sourceFilePositions) {
        this.mKind = kind;
        this.mText = text;
        this.mRawMessage = text;
        this.mSourceFilePositions = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(sourceFilePosition)).add(sourceFilePositions)).build();
        this.mToolName = Optional.absent();
    }

    public Message(Kind kind, String text, String rawMessage, String toolName, SourceFilePosition sourceFilePosition, SourceFilePosition ... sourceFilePositions) {
        this.mKind = kind;
        this.mText = text;
        this.mRawMessage = rawMessage;
        this.mToolName = Optional.fromNullable(toolName);
        this.mSourceFilePositions = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(sourceFilePosition)).add(sourceFilePositions)).build();
    }

    public Message(Kind kind, String text, String rawMessage, Optional<String> toolName, ImmutableList<SourceFilePosition> positions) {
        this.mKind = kind;
        this.mText = text;
        this.mRawMessage = rawMessage;
        this.mToolName = toolName;
        this.mSourceFilePositions = positions.isEmpty() ? ImmutableList.of(SourceFilePosition.UNKNOWN) : positions;
    }

    public Kind getKind() {
        return this.mKind;
    }

    public String getText() {
        return this.mText;
    }

    public List<SourceFilePosition> getSourceFilePositions() {
        return this.mSourceFilePositions;
    }

    public String getRawMessage() {
        return this.mRawMessage;
    }

    public Optional<String> getToolName() {
        return this.mToolName;
    }

    public String getSourcePath() {
        File file = this.mSourceFilePositions.get(0).getFile().getSourceFile();
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    @Deprecated
    public int getLineNumber() {
        return this.mSourceFilePositions.get(0).getPosition().getStartLine() + 1;
    }

    @Deprecated
    public int getColumn() {
        return this.mSourceFilePositions.get(0).getPosition().getStartColumn() + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message that = (Message)o;
        return Objects.equal((Object)this.mKind, (Object)that.mKind) && Objects.equal(this.mText, that.mText) && Objects.equal(this.mRawMessage, that.mRawMessage) && Objects.equal(this.mToolName, that.mToolName) && Objects.equal(this.mSourceFilePositions, that.mSourceFilePositions);
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.mKind, this.mText, this.mSourceFilePositions});
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(this).add("kind", (Object)this.mKind).add("text", this.mText).add("sources", this.mSourceFilePositions);
        if (!this.mText.equals(this.mRawMessage)) {
            toStringHelper.add("original message", this.mRawMessage);
        }
        if (this.mToolName.isPresent()) {
            toStringHelper.add("tool name", this.mToolName);
        }
        return toStringHelper.toString();
    }

    public static enum Kind {
        ERROR,
        WARNING,
        INFO,
        STATISTICS,
        UNKNOWN,
        SIMPLE;


        public static Kind findIgnoringCase(String s, Kind defaultKind) {
            for (Kind kind : Kind.values()) {
                if (!kind.toString().equalsIgnoreCase(s)) continue;
                return kind;
            }
            return defaultKind;
        }

        public static Kind findIgnoringCase(String s) {
            return Kind.findIgnoringCase(s, null);
        }
    }
}

