/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.OleEnumFORMATETC;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.IEnumFORMATETC;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private static final int RETRY_LIMIT = 10;
    private Display display;
    private COMObject iDataObject;
    private int refCount;
    private Transfer[] transferAgents = new Transfer[0];
    private Object[] data = new Object[0];
    private int CFSTR_PREFERREDDROPEFFECT;
    static /* synthetic */ Class class$0;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
        TCHAR tCHAR = new TCHAR(0, "Preferred DropEffect", true);
        this.CFSTR_PREFERREDDROPEFFECT = OS.RegisterClipboardFormat(tCHAR);
        this.createCOMInterfaces();
        this.AddRef();
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int n) {
        this.checkWidget();
        if ((n & 1) != 0 && COM.OleIsCurrentClipboard(this.iDataObject.getAddress()) == 0) {
            COM.OleSetClipboard(0);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (COM.OleIsCurrentClipboard(this.iDataObject.getAddress()) == 0) {
            COM.OleFlushClipboard();
        }
        this.Release();
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getContents(Transfer transfer, int n) {
        Object object;
        block12: {
            Object object2;
            block11: {
                this.checkWidget();
                if (transfer == null) {
                    DND.error(4);
                }
                if ((n & 1) == 0) {
                    return null;
                }
                int[] nArray = new int[1];
                int n2 = 0;
                int n3 = COM.OleGetClipboard(nArray);
                while (true) {
                    if (n3 == 0 || n2++ >= 10) {
                        if (n3 == 0) break;
                        return null;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Throwable throwable) {}
                    object = new MSG();
                    OS.PeekMessage((MSG)object, 0, 0, 0, 2);
                    n3 = COM.OleGetClipboard(nArray);
                }
                object = new IDataObject(nArray[0]);
                try {
                    TransferData[] transferDataArray = transfer.getSupportedTypes();
                    int n4 = 0;
                    while (n4 < transferDataArray.length) {
                        if (((IDataObject)object).QueryGetData(transferDataArray[n4].formatetc) == 0) {
                            TransferData transferData = transferDataArray[n4];
                            transferData.pIDataObject = nArray[0];
                            object2 = transfer.nativeToJava(transferData);
                            Object var10_11 = null;
                            break block11;
                        }
                        ++n4;
                    }
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    ((IUnknown)object).Release();
                    throw throwable;
                }
            }
            ((IUnknown)object).Release();
            return object2;
        }
        Object var10_13 = null;
        ((IUnknown)object).Release();
        return null;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray) {
        this.setContents(objectArray, transferArray, 1);
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray, int n) {
        this.checkWidget();
        if (objectArray == null || transferArray == null || objectArray.length != transferArray.length || objectArray.length == 0) {
            DND.error(5);
        }
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (objectArray[n2] == null || transferArray[n2] == null || !transferArray[n2].validate(objectArray[n2])) {
                DND.error(5);
            }
            ++n2;
        }
        if ((n & 1) == 0) {
            return;
        }
        this.data = objectArray;
        this.transferAgents = transferArray;
        n2 = COM.OleSetClipboard(this.iDataObject.getAddress());
        int n3 = 0;
        while (n2 != 0 && n3++ < 10) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {}
            MSG mSG = new MSG();
            OS.PeekMessage(mSG, 0, 0, 0, 2);
            n2 = COM.OleSetClipboard(this.iDataObject.getAddress());
        }
        if (n2 != 0) {
            DND.error(2002);
        }
    }

    private int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private void createCOMInterfaces() {
        int[] nArray = new int[12];
        nArray[0] = 2;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 3;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 1;
        nArray[11] = 1;
        this.iDataObject = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Clipboard.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Clipboard.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Clipboard.this.Release();
            }

            public int method3(int[] nArray) {
                return Clipboard.this.GetData(nArray[0], nArray[1]);
            }

            public int method5(int[] nArray) {
                return Clipboard.this.QueryGetData(nArray[0]);
            }

            public int method8(int[] nArray) {
                return Clipboard.this.EnumFormatEtc(nArray[0], nArray[1]);
            }
        };
    }

    private void disposeCOMInterfaces() {
        if (this.iDataObject != null) {
            this.iDataObject.dispose();
        }
        this.iDataObject = null;
    }

    private int EnumFormatEtc(int n, int n2) {
        Object[] objectArray;
        if (n == 2) {
            return -2147467263;
        }
        TransferData[] transferDataArray = new TransferData[]{};
        int n3 = 0;
        while (n3 < this.transferAgents.length) {
            objectArray = this.transferAgents[n3].getSupportedTypes();
            TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + objectArray.length];
            System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
            System.arraycopy(objectArray, 0, transferDataArray2, transferDataArray.length, objectArray.length);
            transferDataArray = transferDataArray2;
            ++n3;
        }
        OleEnumFORMATETC oleEnumFORMATETC = new OleEnumFORMATETC();
        oleEnumFORMATETC.AddRef();
        objectArray = new FORMATETC[transferDataArray.length + 1];
        int n4 = 0;
        while (n4 < transferDataArray.length) {
            objectArray[n4] = transferDataArray[n4].formatetc;
            ++n4;
        }
        FORMATETC fORMATETC = new FORMATETC();
        fORMATETC.cfFormat = this.CFSTR_PREFERREDDROPEFFECT;
        fORMATETC.dwAspect = 1;
        fORMATETC.lindex = -1;
        fORMATETC.tymed = 1;
        objectArray[objectArray.length - 1] = fORMATETC;
        oleEnumFORMATETC.setFormats((FORMATETC[])objectArray);
        OS.MoveMemory(n2, new int[]{oleEnumFORMATETC.getAddress()}, OS.PTR_SIZEOF);
        return 0;
    }

    private int GetData(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147024809;
        }
        if (this.QueryGetData(n) != 0) {
            return -2147221404;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, n, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        transferData.stgmedium = new STGMEDIUM();
        transferData.result = -2147467259;
        if (transferData.type == this.CFSTR_PREFERREDDROPEFFECT) {
            STGMEDIUM sTGMEDIUM = new STGMEDIUM();
            sTGMEDIUM.tymed = 1;
            sTGMEDIUM.unionField = OS.GlobalAlloc(64, 4);
            OS.MoveMemory(sTGMEDIUM.unionField, new int[]{1}, 4);
            sTGMEDIUM.pUnkForRelease = 0;
            COM.MoveMemory(n2, sTGMEDIUM, STGMEDIUM.sizeof);
            return 0;
        }
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.transferAgents.length) {
            if (this.transferAgents[n4].isSupportedType(transferData)) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        if (n3 == -1) {
            return -2147221404;
        }
        this.transferAgents[n3].javaToNative(this.data[n3], transferData);
        COM.MoveMemory(n2, transferData.stgmedium, STGMEDIUM.sizeof);
        return transferData.result;
    }

    private int QueryGetData(int n) {
        if (this.transferAgents == null) {
            return -2147467259;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, n, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        if (transferData.type == this.CFSTR_PREFERREDDROPEFFECT) {
            return 0;
        }
        int n2 = 0;
        while (n2 < this.transferAgents.length) {
            if (this.transferAgents[n2].isSupportedType(transferData)) {
                return 0;
            }
            ++n2;
        }
        return -2147221404;
    }

    private int QueryInterface(int n, int n2) {
        if (n == 0 || n2 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDataObject)) {
            OS.MoveMemory(n2, new int[]{this.iDataObject.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(n2, new int[1], OS.PTR_SIZEOF);
        return -2147467262;
    }

    private int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.data = new Object[0];
            this.transferAgents = new Transfer[0];
            this.disposeCOMInterfaces();
            COM.CoFreeUnusedLibraries();
        }
        return this.refCount;
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int n) {
        this.checkWidget();
        if ((n & 1) == 0) {
            return new TransferData[0];
        }
        FORMATETC[] fORMATETCArray = this._getAvailableTypes();
        TransferData[] transferDataArray = new TransferData[fORMATETCArray.length];
        int n2 = 0;
        while (n2 < fORMATETCArray.length) {
            transferDataArray[n2] = new TransferData();
            transferDataArray[n2].type = fORMATETCArray[n2].cfFormat;
            transferDataArray[n2].formatetc = fORMATETCArray[n2];
            ++n2;
        }
        return transferDataArray;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        FORMATETC[] fORMATETCArray = this._getAvailableTypes();
        String[] stringArray = new String[fORMATETCArray.length];
        int n = 128;
        int n2 = 0;
        while (n2 < fORMATETCArray.length) {
            TCHAR tCHAR = new TCHAR(0, n);
            int n3 = OS.GetClipboardFormatName(fORMATETCArray[n2].cfFormat, tCHAR, n);
            if (n3 != 0) {
                stringArray[n2] = tCHAR.toString(0, n3);
            } else {
                switch (fORMATETCArray[n2].cfFormat) {
                    case 15: {
                        stringArray[n2] = "CF_HDROP";
                        break;
                    }
                    case 1: {
                        stringArray[n2] = "CF_TEXT";
                        break;
                    }
                    case 2: {
                        stringArray[n2] = "CF_BITMAP";
                        break;
                    }
                    case 3: {
                        stringArray[n2] = "CF_METAFILEPICT";
                        break;
                    }
                    case 4: {
                        stringArray[n2] = "CF_SYLK";
                        break;
                    }
                    case 5: {
                        stringArray[n2] = "CF_DIF";
                        break;
                    }
                    case 6: {
                        stringArray[n2] = "CF_TIFF";
                        break;
                    }
                    case 7: {
                        stringArray[n2] = "CF_OEMTEXT";
                        break;
                    }
                    case 8: {
                        stringArray[n2] = "CF_DIB";
                        break;
                    }
                    case 9: {
                        stringArray[n2] = "CF_PALETTE";
                        break;
                    }
                    case 10: {
                        stringArray[n2] = "CF_PENDATA";
                        break;
                    }
                    case 11: {
                        stringArray[n2] = "CF_RIFF";
                        break;
                    }
                    case 12: {
                        stringArray[n2] = "CF_WAVE";
                        break;
                    }
                    case 13: {
                        stringArray[n2] = "CF_UNICODETEXT";
                        break;
                    }
                    case 14: {
                        stringArray[n2] = "CF_ENHMETAFILE";
                        break;
                    }
                    case 16: {
                        stringArray[n2] = "CF_LOCALE";
                        break;
                    }
                    case 17: {
                        stringArray[n2] = "CF_MAX";
                        break;
                    }
                    default: {
                        stringArray[n2] = "UNKNOWN";
                    }
                }
            }
            ++n2;
        }
        return stringArray;
    }

    private FORMATETC[] _getAvailableTypes() {
        FORMATETC[] fORMATETCArray = new FORMATETC[]{};
        int[] nArray = new int[1];
        if (COM.OleGetClipboard(nArray) != 0) {
            return fORMATETCArray;
        }
        IDataObject iDataObject = new IDataObject(nArray[0]);
        int[] nArray2 = new int[1];
        int n = iDataObject.EnumFormatEtc(1, nArray2);
        iDataObject.Release();
        if (n != 0) {
            return fORMATETCArray;
        }
        IEnumFORMATETC iEnumFORMATETC = new IEnumFORMATETC(nArray2[0]);
        int n2 = OS.GlobalAlloc(64, FORMATETC.sizeof);
        int[] nArray3 = new int[1];
        iEnumFORMATETC.Reset();
        while (iEnumFORMATETC.Next(1, n2, nArray3) == 0 && nArray3[0] == 1) {
            FORMATETC fORMATETC = new FORMATETC();
            COM.MoveMemory(fORMATETC, n2, FORMATETC.sizeof);
            FORMATETC[] fORMATETCArray2 = new FORMATETC[fORMATETCArray.length + 1];
            System.arraycopy(fORMATETCArray, 0, fORMATETCArray2, 0, fORMATETCArray.length);
            fORMATETCArray2[fORMATETCArray.length] = fORMATETC;
            fORMATETCArray = fORMATETCArray2;
        }
        OS.GlobalFree(n2);
        iEnumFORMATETC.Release();
        return fORMATETCArray;
    }
}

