/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.gmscore.tools.apk.arsc;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import com.google.devrel.gmscore.tools.apk.arsc.Chunk;
import com.google.devrel.gmscore.tools.apk.arsc.SerializableResource;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class BinaryResourceFile
implements SerializableResource {
    private final List<Chunk> chunks = new ArrayList<Chunk>();

    public BinaryResourceFile(byte[] buf) {
        ByteBuffer buffer = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
        while (buffer.remaining() > 0) {
            this.chunks.add(Chunk.newInstance(buffer));
        }
    }

    public static BinaryResourceFile fromInputStream(InputStream is) throws IOException {
        byte[] buf = ByteStreams.toByteArray(is);
        return new BinaryResourceFile(buf);
    }

    public List<Chunk> getChunks() {
        return Collections.unmodifiableList(this.chunks);
    }

    @Override
    public byte[] toByteArray() throws IOException {
        return this.toByteArray(false);
    }

    @Override
    public byte[] toByteArray(boolean shrink) throws IOException {
        ByteArrayDataOutput output = ByteStreams.newDataOutput();
        for (Chunk chunk : this.chunks) {
            output.write(chunk.toByteArray(shrink));
        }
        return output.toByteArray();
    }
}

