/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.util.HashMap;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRendererFilter;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class MenuManagerShowProcessor
implements IMenuListener2 {
    @Inject
    private EModelService modelService;
    @Inject
    private IRendererFactory rendererFactory;
    @Inject
    private MenuManagerRenderer renderer;
    private HashMap<Menu, Runnable> pendingCleanup = new HashMap();

    private static void trace(String msg, Widget menu, MMenu menuModel) {
        WorkbenchSWTActivator.trace((String)"/trace/menus", (String)(String.valueOf(msg) + ": " + menu + ": " + menuModel), null);
    }

    public void menuAboutToShow(IMenuManager manager) {
        AbstractPartRenderer obj;
        if (!(manager instanceof MenuManager)) {
            return;
        }
        MenuManager menuManager = (MenuManager)manager;
        MMenu menuModel = this.renderer.getMenuModel(menuManager);
        Menu menu = menuManager.getMenu();
        if (menuModel != null && menuManager != null) {
            this.cleanUp(menu, menuModel, menuManager);
        }
        if (menuModel instanceof MPopupMenu) {
            this.showPopup(menu, (MPopupMenu)menuModel, menuManager);
        }
        if (!((obj = this.rendererFactory.getRenderer((MUIElement)menuModel, (Object)menu.getParent())) instanceof MenuManagerRenderer)) {
            MenuManagerShowProcessor.trace("Not the correct renderer: " + obj, (Widget)menu, menuModel);
            return;
        }
        MenuManagerRenderer renderer = (MenuManagerRenderer)obj;
        if (menuModel.getWidget() == null) {
            renderer.bindWidget((MUIElement)menuModel, menuManager.getMenu());
        }
    }

    public void menuAboutToHide(IMenuManager manager) {
        if (!(manager instanceof MenuManager)) {
            return;
        }
        MenuManager menuManager = (MenuManager)manager;
        MMenu menuModel = this.renderer.getMenuModel(menuManager);
        Menu menu = menuManager.getMenu();
        if (menuModel != null) {
            this.showMenu(menu, menuModel, menuManager);
        }
    }

    private void cleanUp(Menu menu, MMenu menuModel, MenuManager menuManager) {
        MenuManagerShowProcessor.trace("cleanUp", (Widget)menu, null);
        if (this.pendingCleanup.isEmpty()) {
            return;
        }
        Runnable cleanUp = this.pendingCleanup.remove(menu);
        if (cleanUp != null) {
            MenuManagerShowProcessor.trace("cleanUp.run()", (Widget)menu, null);
            cleanUp.run();
        }
    }

    private void showPopup(Menu menu, MPopupMenu menuModel, MenuManager menuManager) {
        IEclipseContext popupContext = menuModel.getContext();
        IEclipseContext parentContext = popupContext.getParent();
        IEclipseContext originalChild = parentContext.getActiveChild();
        popupContext.activate();
        popupContext.set("MenuServiceFilter.original.context", (Object)originalChild);
    }

    private void showMenu(Menu menu, MMenu menuModel, MenuManager menuManager) {
        IEclipseContext evalContext = menuModel instanceof MContext ? ((MContext)menuModel).getContext() : this.modelService.getContainingContext((MUIElement)menuModel);
        MenuManagerRendererFilter.updateElementVisibility(menuModel, this.renderer, menuManager, evalContext, 2, true);
    }
}

