#include "Opcodes.h"

#include "MetadataUtil.h"

namespace hybridclr
{
namespace metadata
{

	OpCodeInfo g_opcodeInfos[(int)OpcodeEnum::__Count] =
	{
		//!!!{{OPCODE_INFO
		{ OpcodeEnum::NOP, "nop", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::NOP, FlowType::Next, 0 },
		{ OpcodeEnum::BREAK, "break", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::BREAK, FlowType::Break, 0 },
		{ OpcodeEnum::LDARG_0, "ldarg.0", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDARG_0, FlowType::Next, 0 },
		{ OpcodeEnum::LDARG_1, "ldarg.1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDARG_1, FlowType::Next, 1 },
		{ OpcodeEnum::LDARG_2, "ldarg.2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDARG_2, FlowType::Next, 2 },
		{ OpcodeEnum::LDARG_3, "ldarg.3", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDARG_3, FlowType::Next, 3 },
		{ OpcodeEnum::LDLOC_0, "ldloc.0", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDLOC_0, FlowType::Next, 0 },
		{ OpcodeEnum::LDLOC_1, "ldloc.1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDLOC_1, FlowType::Next, 1 },
		{ OpcodeEnum::LDLOC_2, "ldloc.2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDLOC_2, FlowType::Next, 2 },
		{ OpcodeEnum::LDLOC_3, "ldloc.3", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDLOC_3, FlowType::Next, 3 },
		{ OpcodeEnum::STLOC_0, "stloc.0", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STLOC_0, FlowType::Next, 0 },
		{ OpcodeEnum::STLOC_1, "stloc.1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STLOC_1, FlowType::Next, 1 },
		{ OpcodeEnum::STLOC_2, "stloc.2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STLOC_2, FlowType::Next, 2 },
		{ OpcodeEnum::STLOC_3, "stloc.3", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STLOC_3, FlowType::Next, 3 },
		{ OpcodeEnum::LDARG_S, "ldarg.s", {}, OutputType::None, ArgType::Data, 1, 255, OpcodeValue::LDARG_S, FlowType::Next, 0 },
		{ OpcodeEnum::LDARGA_S, "ldarga.s", {}, OutputType::None, ArgType::Data, 1, 255, OpcodeValue::LDARGA_S, FlowType::Next, 0 },
		{ OpcodeEnum::STARG_S, "starg.s", {}, OutputType::None, ArgType::Data, 1, 255, OpcodeValue::STARG_S, FlowType::Next, 0 },
		{ OpcodeEnum::LDLOC_S, "ldloc.s", {}, OutputType::None, ArgType::Data, 1, 255, OpcodeValue::LDLOC_S, FlowType::Next, 0 },
		{ OpcodeEnum::LDLOCA_S, "ldloca.s", {}, OutputType::None, ArgType::Data, 1, 255, OpcodeValue::LDLOCA_S, FlowType::Next, 0 },
		{ OpcodeEnum::STLOC_S, "stloc.s", {}, OutputType::None, ArgType::Data, 1, 255, OpcodeValue::STLOC_S, FlowType::Next, 0 },
		{ OpcodeEnum::LDNULL, "ldnull", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDNULL, FlowType::Next, 0 },
		{ OpcodeEnum::LDC_I4_M1, "ldc.i4.m1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDC_I4_M1, FlowType::Next, -1 },
		{ OpcodeEnum::LDC_I4_0, "ldc.i4.0", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDC_I4_0, FlowType::Next, 0 },
		{ OpcodeEnum::LDC_I4_1, "ldc.i4.1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDC_I4_1, FlowType::Next, 1 },
		{ OpcodeEnum::LDC_I4_2, "ldc.i4.2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDC_I4_2, FlowType::Next, 2 },
		{ OpcodeEnum::LDC_I4_3, "ldc.i4.3", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDC_I4_3, FlowType::Next, 3 },
		{ OpcodeEnum::LDC_I4_4, "ldc.i4.4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDC_I4_4, FlowType::Next, 4 },
		{ OpcodeEnum::LDC_I4_5, "ldc.i4.5", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDC_I4_5, FlowType::Next, 5 },
		{ OpcodeEnum::LDC_I4_6, "ldc.i4.6", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDC_I4_6, FlowType::Next, 6 },
		{ OpcodeEnum::LDC_I4_7, "ldc.i4.7", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDC_I4_7, FlowType::Next, 7 },
		{ OpcodeEnum::LDC_I4_8, "ldc.i4.8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDC_I4_8, FlowType::Next, 8 },
		{ OpcodeEnum::LDC_I4_S, "ldc.i4.s", {}, OutputType::None, ArgType::Data, 1, 255, OpcodeValue::LDC_I4_S, FlowType::Next, 0 },
		{ OpcodeEnum::LDC_I4, "ldc.i4", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::LDC_I4, FlowType::Next, 0 },
		{ OpcodeEnum::LDC_I8, "ldc.i8", {}, OutputType::None, ArgType::Data, 8, 255, OpcodeValue::LDC_I8, FlowType::Next, 0 },
		{ OpcodeEnum::LDC_R4, "ldc.r4", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::LDC_R4, FlowType::Next, 0 },
		{ OpcodeEnum::LDC_R8, "ldc.r8", {}, OutputType::None, ArgType::Data, 8, 255, OpcodeValue::LDC_R8, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED99, "unused99", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED99, FlowType::Next, 0 },
		{ OpcodeEnum::DUP, "dup", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::DUP, FlowType::Next, 0 },
		{ OpcodeEnum::POP, "pop", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::POP, FlowType::Next, 0 },
		{ OpcodeEnum::JMP, "jmp", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::JMP, FlowType::Call, 0 },
		{ OpcodeEnum::CALL, "call", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::CALL, FlowType::Call, 0 },
		{ OpcodeEnum::CALLI, "calli", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::CALLI, FlowType::Call, 0 },
		{ OpcodeEnum::RET, "ret", {}, OutputType::None, ArgType::StaticBranch, 0, 255, OpcodeValue::RET, FlowType::Return, 0 },
		{ OpcodeEnum::BR_S, "br.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BR_S, FlowType::Branch, 0 },
		{ OpcodeEnum::BRFALSE_S, "brfalse.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BRFALSE_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BRTRUE_S, "brtrue.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BRTRUE_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BEQ_S, "beq.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BEQ_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BGE_S, "bge.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BGE_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BGT_S, "bgt.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BGT_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BLE_S, "ble.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BLE_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BLT_S, "blt.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BLT_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BNE_UN_S, "bne.un.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BNE_UN_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BGE_UN_S, "bge.un.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BGE_UN_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BGT_UN_S, "bgt.un.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BGT_UN_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BLE_UN_S, "ble.un.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BLE_UN_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BLT_UN_S, "blt.un.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::BLT_UN_S, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BR, "br", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BR, FlowType::Branch, 0 },
		{ OpcodeEnum::BRFALSE, "brfalse", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BRFALSE, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BRTRUE, "brtrue", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BRTRUE, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BEQ, "beq", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BEQ, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BGE, "bge", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BGE, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BGT, "bgt", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BGT, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BLE, "ble", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BLE, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BLT, "blt", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BLT, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BNE_UN, "bne.un", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BNE_UN, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BGE_UN, "bge.un", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BGE_UN, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BGT_UN, "bgt.un", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BGT_UN, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BLE_UN, "ble.un", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BLE_UN, FlowType::CondBranch, 0 },
		{ OpcodeEnum::BLT_UN, "blt.un", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::BLT_UN, FlowType::CondBranch, 0 },
		{ OpcodeEnum::SWITCH, "switch", {}, OutputType::None, ArgType::Switch, -1, 255, OpcodeValue::SWITCH, FlowType::CondBranch, 0 },
		{ OpcodeEnum::LDIND_I1, "ldind.i1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDIND_I1, FlowType::Next, 0 },
		{ OpcodeEnum::LDIND_U1, "ldind.u1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDIND_U1, FlowType::Next, 0 },
		{ OpcodeEnum::LDIND_I2, "ldind.i2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDIND_I2, FlowType::Next, 0 },
		{ OpcodeEnum::LDIND_U2, "ldind.u2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDIND_U2, FlowType::Next, 0 },
		{ OpcodeEnum::LDIND_I4, "ldind.i4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDIND_I4, FlowType::Next, 0 },
		{ OpcodeEnum::LDIND_U4, "ldind.u4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDIND_U4, FlowType::Next, 0 },
		{ OpcodeEnum::LDIND_I8, "ldind.i8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDIND_I8, FlowType::Next, 0 },
		{ OpcodeEnum::LDIND_I, "ldind.i", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDIND_I, FlowType::Next, 0 },
		{ OpcodeEnum::LDIND_R4, "ldind.r4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDIND_R4, FlowType::Next, 0 },
		{ OpcodeEnum::LDIND_R8, "ldind.r8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDIND_R8, FlowType::Next, 0 },
		{ OpcodeEnum::LDIND_REF, "ldind.ref", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDIND_REF, FlowType::Next, 0 },
		{ OpcodeEnum::STIND_REF, "stind.ref", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STIND_REF, FlowType::Next, 0 },
		{ OpcodeEnum::STIND_I1, "stind.i1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STIND_I1, FlowType::Next, 0 },
		{ OpcodeEnum::STIND_I2, "stind.i2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STIND_I2, FlowType::Next, 0 },
		{ OpcodeEnum::STIND_I4, "stind.i4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STIND_I4, FlowType::Next, 0 },
		{ OpcodeEnum::STIND_I8, "stind.i8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STIND_I8, FlowType::Next, 0 },
		{ OpcodeEnum::STIND_R4, "stind.r4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STIND_R4, FlowType::Next, 0 },
		{ OpcodeEnum::STIND_R8, "stind.r8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STIND_R8, FlowType::Next, 0 },
		{ OpcodeEnum::ADD, "add", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::ADD, FlowType::Next, 0 },
		{ OpcodeEnum::SUB, "sub", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::SUB, FlowType::Next, 0 },
		{ OpcodeEnum::MUL, "mul", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::MUL, FlowType::Next, 0 },
		{ OpcodeEnum::DIV, "div", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::DIV, FlowType::Next, 0 },
		{ OpcodeEnum::DIV_UN, "div.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::DIV_UN, FlowType::Next, 0 },
		{ OpcodeEnum::REM, "rem", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::REM, FlowType::Next, 0 },
		{ OpcodeEnum::REM_UN, "rem.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::REM_UN, FlowType::Next, 0 },
		{ OpcodeEnum::AND, "and", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::AND, FlowType::Next, 0 },
		{ OpcodeEnum::OR, "or", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::OR, FlowType::Next, 0 },
		{ OpcodeEnum::XOR, "xor", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::XOR, FlowType::Next, 0 },
		{ OpcodeEnum::SHL, "shl", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::SHL, FlowType::Next, 0 },
		{ OpcodeEnum::SHR, "shr", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::SHR, FlowType::Next, 0 },
		{ OpcodeEnum::SHR_UN, "shr.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::SHR_UN, FlowType::Next, 0 },
		{ OpcodeEnum::NEG, "neg", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::NEG, FlowType::Next, 0 },
		{ OpcodeEnum::NOT, "not", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::NOT, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_I1, "conv.i1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_I1, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_I2, "conv.i2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_I2, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_I4, "conv.i4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_I4, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_I8, "conv.i8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_I8, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_R4, "conv.r4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_R4, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_R8, "conv.r8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_R8, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_U4, "conv.u4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_U4, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_U8, "conv.u8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_U8, FlowType::Next, 0 },
		{ OpcodeEnum::CALLVIRT, "callvirt", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::CALLVIRT, FlowType::Call, 0 },
		{ OpcodeEnum::CPOBJ, "cpobj", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::CPOBJ, FlowType::Next, 0 },
		{ OpcodeEnum::LDOBJ, "ldobj", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::LDOBJ, FlowType::Next, 0 },
		{ OpcodeEnum::LDSTR, "ldstr", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::LDSTR, FlowType::Next, 0 },
		{ OpcodeEnum::NEWOBJ, "newobj", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::NEWOBJ, FlowType::Call, 0 },
		{ OpcodeEnum::CASTCLASS, "castclass", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::CASTCLASS, FlowType::Next, 0 },
		{ OpcodeEnum::ISINST, "isinst", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::ISINST, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_R_UN, "conv.r.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_R_UN, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED58, "unused58", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED58, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED1, "unused1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED1, FlowType::Next, 0 },
		{ OpcodeEnum::UNBOX, "unbox", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::UNBOX, FlowType::Next, 0 },
		{ OpcodeEnum::THROW, "throw", {}, OutputType::None, ArgType::StaticBranch, 0, 255, OpcodeValue::THROW, FlowType::Throw, 0 },
		{ OpcodeEnum::LDFLD, "ldfld", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::LDFLD, FlowType::Next, 0 },
		{ OpcodeEnum::LDFLDA, "ldflda", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::LDFLDA, FlowType::Next, 0 },
		{ OpcodeEnum::STFLD, "stfld", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::STFLD, FlowType::Next, 0 },
		{ OpcodeEnum::LDSFLD, "ldsfld", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::LDSFLD, FlowType::Next, 0 },
		{ OpcodeEnum::LDSFLDA, "ldsflda", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::LDSFLDA, FlowType::Next, 0 },
		{ OpcodeEnum::STSFLD, "stsfld", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::STSFLD, FlowType::Next, 0 },
		{ OpcodeEnum::STOBJ, "stobj", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::STOBJ, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_I1_UN, "conv.ovf.i1.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_I1_UN, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_I2_UN, "conv.ovf.i2.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_I2_UN, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_I4_UN, "conv.ovf.i4.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_I4_UN, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_I8_UN, "conv.ovf.i8.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_I8_UN, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_U1_UN, "conv.ovf.u1.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_U1_UN, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_U2_UN, "conv.ovf.u2.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_U2_UN, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_U4_UN, "conv.ovf.u4.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_U4_UN, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_U8_UN, "conv.ovf.u8.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_U8_UN, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_I_UN, "conv.ovf.i.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_I_UN, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_U_UN, "conv.ovf.u.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_U_UN, FlowType::Next, 0 },
		{ OpcodeEnum::BOX, "box", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::BOX, FlowType::Next, 0 },
		{ OpcodeEnum::NEWARR, "newarr", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::NEWARR, FlowType::Next, 0 },
		{ OpcodeEnum::LDLEN, "ldlen", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDLEN, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEMA, "ldelema", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::LDELEMA, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM_I1, "ldelem.i1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDELEM_I1, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM_U1, "ldelem.u1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDELEM_U1, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM_I2, "ldelem.i2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDELEM_I2, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM_U2, "ldelem.u2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDELEM_U2, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM_I4, "ldelem.i4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDELEM_I4, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM_U4, "ldelem.u4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDELEM_U4, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM_I8, "ldelem.i8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDELEM_I8, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM_I, "ldelem.i", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDELEM_I, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM_R4, "ldelem.r4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDELEM_R4, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM_R8, "ldelem.r8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDELEM_R8, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM_REF, "ldelem.ref", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::LDELEM_REF, FlowType::Next, 0 },
		{ OpcodeEnum::STELEM_I, "stelem.i", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STELEM_I, FlowType::Next, 0 },
		{ OpcodeEnum::STELEM_I1, "stelem.i1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STELEM_I1, FlowType::Next, 0 },
		{ OpcodeEnum::STELEM_I2, "stelem.i2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STELEM_I2, FlowType::Next, 0 },
		{ OpcodeEnum::STELEM_I4, "stelem.i4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STELEM_I4, FlowType::Next, 0 },
		{ OpcodeEnum::STELEM_I8, "stelem.i8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STELEM_I8, FlowType::Next, 0 },
		{ OpcodeEnum::STELEM_R4, "stelem.r4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STELEM_R4, FlowType::Next, 0 },
		{ OpcodeEnum::STELEM_R8, "stelem.r8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STELEM_R8, FlowType::Next, 0 },
		{ OpcodeEnum::STELEM_REF, "stelem.ref", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STELEM_REF, FlowType::Next, 0 },
		{ OpcodeEnum::LDELEM, "ldelem", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::LDELEM, FlowType::Next, 0 },
		{ OpcodeEnum::STELEM, "stelem", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::STELEM, FlowType::Next, 0 },
		{ OpcodeEnum::UNBOX_ANY, "unbox.any", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::UNBOX_ANY, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED5, "unused5", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED5, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED6, "unused6", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED6, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED7, "unused7", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED7, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED8, "unused8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED8, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED9, "unused9", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED9, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED10, "unused10", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED10, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED11, "unused11", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED11, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED12, "unused12", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED12, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED13, "unused13", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED13, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED14, "unused14", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED14, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED15, "unused15", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED15, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED16, "unused16", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED16, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED17, "unused17", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED17, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_I1, "conv.ovf.i1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_I1, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_U1, "conv.ovf.u1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_U1, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_I2, "conv.ovf.i2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_I2, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_U2, "conv.ovf.u2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_U2, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_I4, "conv.ovf.i4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_I4, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_U4, "conv.ovf.u4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_U4, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_I8, "conv.ovf.i8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_I8, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_U8, "conv.ovf.u8", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_U8, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED50, "unused50", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED50, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED18, "unused18", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED18, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED19, "unused19", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED19, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED20, "unused20", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED20, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED21, "unused21", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED21, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED22, "unused22", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED22, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED23, "unused23", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED23, FlowType::Next, 0 },
		{ OpcodeEnum::REFANYVAL, "refanyval", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::REFANYVAL, FlowType::Next, 0 },
		{ OpcodeEnum::CKFINITE, "ckfinite", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CKFINITE, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED24, "unused24", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED24, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED25, "unused25", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED25, FlowType::Next, 0 },
		{ OpcodeEnum::MKREFANY, "mkrefany", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::MKREFANY, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED59, "unused59", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED59, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED60, "unused60", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED60, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED61, "unused61", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED61, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED62, "unused62", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED62, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED63, "unused63", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED63, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED64, "unused64", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED64, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED65, "unused65", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED65, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED66, "unused66", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED66, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED67, "unused67", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED67, FlowType::Next, 0 },
		{ OpcodeEnum::LDTOKEN, "ldtoken", {}, OutputType::None, ArgType::Data, 4, 255, OpcodeValue::LDTOKEN, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_U2, "conv.u2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_U2, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_U1, "conv.u1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_U1, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_I, "conv.i", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_I, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_I, "conv.ovf.i", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_I, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_OVF_U, "conv.ovf.u", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_OVF_U, FlowType::Next, 0 },
		{ OpcodeEnum::ADD_OVF, "add.ovf", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::ADD_OVF, FlowType::Next, 0 },
		{ OpcodeEnum::ADD_OVF_UN, "add.ovf.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::ADD_OVF_UN, FlowType::Next, 0 },
		{ OpcodeEnum::MUL_OVF, "mul.ovf", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::MUL_OVF, FlowType::Next, 0 },
		{ OpcodeEnum::MUL_OVF_UN, "mul.ovf.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::MUL_OVF_UN, FlowType::Next, 0 },
		{ OpcodeEnum::SUB_OVF, "sub.ovf", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::SUB_OVF, FlowType::Next, 0 },
		{ OpcodeEnum::SUB_OVF_UN, "sub.ovf.un", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::SUB_OVF_UN, FlowType::Next, 0 },
		{ OpcodeEnum::ENDFINALLY, "endfinally", {}, OutputType::None, ArgType::StaticBranch, 0, 255, OpcodeValue::ENDFINALLY, FlowType::Return, 0 },
		{ OpcodeEnum::LEAVE, "leave", {}, OutputType::None, ArgType::BranchTarget, 4, 255, OpcodeValue::LEAVE, FlowType::Branch, 0 },
		{ OpcodeEnum::LEAVE_S, "leave.s", {}, OutputType::None, ArgType::BranchTarget, 1, 255, OpcodeValue::LEAVE_S, FlowType::Branch, 0 },
		{ OpcodeEnum::STIND_I, "stind.i", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::STIND_I, FlowType::Next, 0 },
		{ OpcodeEnum::CONV_U, "conv.u", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::CONV_U, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED26, "unused26", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED26, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED27, "unused27", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED27, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED28, "unused28", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED28, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED29, "unused29", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED29, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED30, "unused30", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED30, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED31, "unused31", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED31, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED32, "unused32", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED32, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED33, "unused33", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED33, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED34, "unused34", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED34, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED35, "unused35", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED35, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED36, "unused36", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED36, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED37, "unused37", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED37, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED38, "unused38", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED38, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED39, "unused39", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED39, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED40, "unused40", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED40, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED41, "unused41", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED41, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED42, "unused42", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED42, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED43, "unused43", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED43, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED44, "unused44", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED44, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED45, "unused45", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED45, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED46, "unused46", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED46, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED47, "unused47", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED47, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED48, "unused48", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::UNUSED48, FlowType::Next, 0 },
		{ OpcodeEnum::PREFIX7, "prefix7", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::PREFIX7, FlowType::Meta, 0 },
		{ OpcodeEnum::PREFIX6, "prefix6", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::PREFIX6, FlowType::Meta, 0 },
		{ OpcodeEnum::PREFIX5, "prefix5", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::PREFIX5, FlowType::Meta, 0 },
		{ OpcodeEnum::PREFIX4, "prefix4", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::PREFIX4, FlowType::Meta, 0 },
		{ OpcodeEnum::PREFIX3, "prefix3", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::PREFIX3, FlowType::Meta, 0 },
		{ OpcodeEnum::PREFIX2, "prefix2", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::PREFIX2, FlowType::Meta, 0 },
		{ OpcodeEnum::PREFIX1, "prefix1", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::PREFIX1, FlowType::Meta, 0 },
		{ OpcodeEnum::PREFIXREF, "prefixref", {}, OutputType::None, ArgType::None, 0, 255, OpcodeValue::PREFIXREF, FlowType::Meta, 0 },
		{ OpcodeEnum::ARGLIST, "arglist", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::ARGLIST, FlowType::Next, 0 },
		{ OpcodeEnum::CEQ, "ceq", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::CEQ, FlowType::Next, 0 },
		{ OpcodeEnum::CGT, "cgt", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::CGT, FlowType::Next, 0 },
		{ OpcodeEnum::CGT_UN, "cgt.un", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::CGT_UN, FlowType::Next, 0 },
		{ OpcodeEnum::CLT, "clt", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::CLT, FlowType::Next, 0 },
		{ OpcodeEnum::CLT_UN, "clt.un", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::CLT_UN, FlowType::Next, 0 },
		{ OpcodeEnum::LDFTN, "ldftn", {}, OutputType::None, ArgType::Data, 4, 254, OpcodeValue::LDFTN, FlowType::Next, 0 },
		{ OpcodeEnum::LDVIRTFTN, "ldvirtftn", {}, OutputType::None, ArgType::Data, 4, 254, OpcodeValue::LDVIRTFTN, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED56, "unused56", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::UNUSED56, FlowType::Next, 0 },
		{ OpcodeEnum::LDARG, "ldarg", {}, OutputType::None, ArgType::Data, 2, 254, OpcodeValue::LDARG, FlowType::Next, 0 },
		{ OpcodeEnum::LDARGA, "ldarga", {}, OutputType::None, ArgType::Data, 2, 254, OpcodeValue::LDARGA, FlowType::Next, 0 },
		{ OpcodeEnum::STARG, "starg", {}, OutputType::None, ArgType::Data, 2, 254, OpcodeValue::STARG, FlowType::Next, 0 },
		{ OpcodeEnum::LDLOC, "ldloc", {}, OutputType::None, ArgType::Data, 2, 254, OpcodeValue::LDLOC, FlowType::Next, 0 },
		{ OpcodeEnum::LDLOCA, "ldloca", {}, OutputType::None, ArgType::Data, 2, 254, OpcodeValue::LDLOCA, FlowType::Next, 0 },
		{ OpcodeEnum::STLOC, "stloc", {}, OutputType::None, ArgType::Data, 2, 254, OpcodeValue::STLOC, FlowType::Next, 0 },
		{ OpcodeEnum::LOCALLOC, "localloc", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::LOCALLOC, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED57, "unused57", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::UNUSED57, FlowType::Next, 0 },
		{ OpcodeEnum::ENDFILTER, "endfilter", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::ENDFILTER, FlowType::Return, 0 },
		{ OpcodeEnum::UNALIGNED_, "unaligned.", {}, OutputType::None, ArgType::Data, 1, 254, OpcodeValue::UNALIGNED_, FlowType::Meta, 0 },
		{ OpcodeEnum::VOLATILE_, "volatile.", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::VOLATILE_, FlowType::Meta, 0 },
		{ OpcodeEnum::TAIL_, "tail.", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::TAIL_, FlowType::Meta, 0 },
		{ OpcodeEnum::INITOBJ, "initobj", {}, OutputType::None, ArgType::Data, 4, 254, OpcodeValue::INITOBJ, FlowType::Next, 0 },
		{ OpcodeEnum::CONSTRAINED_, "constrained.", {}, OutputType::None, ArgType::Data, 4, 254, OpcodeValue::CONSTRAINED_, FlowType::Meta, 0 },
		{ OpcodeEnum::CPBLK, "cpblk", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::CPBLK, FlowType::Next, 0 },
		{ OpcodeEnum::INITBLK, "initblk", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::INITBLK, FlowType::Next, 0 },
		{ OpcodeEnum::NO_, "no.", {}, OutputType::None, ArgType::Data, 1, 254, OpcodeValue::NO_, FlowType::Next, 0 },
		{ OpcodeEnum::RETHROW, "rethrow", {}, OutputType::None, ArgType::StaticBranch, 0, 254, OpcodeValue::RETHROW, FlowType::Throw, 0 },
		{ OpcodeEnum::UNUSED, "unused", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::UNUSED, FlowType::Next, 0 },
		{ OpcodeEnum::SIZEOF, "sizeof", {}, OutputType::None, ArgType::Data, 4, 254, OpcodeValue::SIZEOF, FlowType::Next, 0 },
		{ OpcodeEnum::REFANYTYPE, "refanytype", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::REFANYTYPE, FlowType::Next, 0 },
		{ OpcodeEnum::READONLY_, "readonly.", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::READONLY_, FlowType::Meta, 0 },
		{ OpcodeEnum::UNUSED53, "unused53", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::UNUSED53, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED54, "unused54", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::UNUSED54, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED55, "unused55", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::UNUSED55, FlowType::Next, 0 },
		{ OpcodeEnum::UNUSED70, "unused70", {}, OutputType::None, ArgType::None, 0, 254, OpcodeValue::UNUSED70, FlowType::Next, 0 },
		{ OpcodeEnum::ILLEGAL, "illegal", {}, OutputType::None, ArgType::None, 0, 0, OpcodeValue::ILLEGAL, FlowType::Meta, 0 },
		{ OpcodeEnum::ENDMAC, "endmac", {}, OutputType::None, ArgType::None, 0, 0, OpcodeValue::ENDMAC, FlowType::Meta, 0 },

		//!!!}}OPCODE_INFO
	};

	const OpCodeInfo* DecodeOpCodeInfo(const byte*& ip, const byte* end)
	{
		if (ip >= end)
		{
			return nullptr;
		}
		byte c = *ip;
		if (c < (byte)OpcodeValue::PREFIX7)
		{
			return &g_opcodeInfos[c];
		}
		else if (c == (byte)OpcodeValue::PREFIX1)
		{
			++ip;
			if (ip >= end)
			{
				return nullptr;
			}
			return &g_opcodeInfos[(int)(*ip) + (int)OpcodeEnum::ARGLIST];
		}
		else
		{
			IL2CPP_ASSERT(false && "unknown prefix");
			return nullptr;
		}
	}

	uint32_t GetOpCodeSize(const byte*& ip, const OpCodeInfo* opCodeInfo)
	{
		if (opCodeInfo->inlineType != ArgType::Switch)
		{
			return 1 + opCodeInfo->inlineParam;
		}
		else
		{
			return metadata::GetI4LittleEndian(ip + 1) * 4 + 5;
		}
	}
}
}