#pragma once

#include "../CommonDef.h"

#include "metadata/GenericMetadata.h"

namespace hybridclr
{
namespace metadata
{
	class MetadataPool
	{
	public:
		static void Initialize();
		static const Il2CppType* GetPooledIl2CppType(const Il2CppType& type);
		static const Il2CppType* GetPooledArrayType(const Il2CppType& type, const Il2CppType* newEleType);
		static const Il2CppArrayType* GetPooledIl2CppArrayType(const Il2CppArrayType& arrayType);
		static const Il2CppGenericInst* GetPooledIl2CppGenericInst(const Il2CppType** types, uint32_t typeCount);
		static const Il2CppGenericInst* GetPooledIl2CppGenericInstFast(const Il2CppType** types, uint32_t typeCount);
		static const Il2CppGenericClass* GetPooledIl2CppGenericClass(const Il2CppType* genericTypeDefinition, const Il2CppGenericInst* inst);
		static const Il2CppGenericMethod* GetPooledIl2CppGenericMethod(const Il2CppGenericMethod& genericMethod);

		static void RegisterIl2CppType(const Il2CppType* type);
		static void RegisterIl2CppGenericInst(const Il2CppGenericInst* genericInst);
		static void RegisterIl2CppGenericClass(const Il2CppGenericClass* genericClass);
		static void RegisterIl2CppGenericMethod(const Il2CppGenericMethod* genericMethod);

		static void WalkAllGenericClasses(il2cpp::metadata::GenericMetadata::GenericClassWalkCallback callback, void* context);
	};
}
}