#include "../encryption/EncryptionVM.h"

#include "vm/Exception.h"

namespace hybridclr
{
namespace encryption
{
	void EncryptionVM::Decrypt(const void* ops, size_t opLength, const byte* key, byte* data, uint32_t dataLength)
	{
		if (dataLength == 0)
		{
			return;
		}
		for (size_t i = 0; i < opLength; i++)
		{
			byte op = ((byte*)ops)[i];
			switch (op)
			{
				//!!!{{INSTRUCTIONS
			// Seed:718782596
			case 0:{ uint32_t xIndex = 3144567432 % dataLength; uint32_t shift = (uint32_t)(key[43] + 2838457666u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 1:{ uint32_t xIndex = 4181712683 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[66] ^ 253u); }break;
			case 2:{ uint32_t xIndex1 = 2838457666 % dataLength; uint32_t xIndex2 = ((uint32_t)key[253] + 1949119948u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 3:{ uint32_t xIndex1 = 3848527613 % dataLength; uint32_t xIndex2 = ((uint32_t)key[204] + 1196240223u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 4:{ uint32_t xIndex = 1949119948 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[95] - 166u); }break;
			case 5:{ uint32_t xIndex1 = 1196240223 % dataLength; uint32_t xIndex2 = ((uint32_t)key[166] + 1523629777u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 6:{ uint32_t xIndex1 = 845763238 % dataLength; uint32_t xIndex2 = ((uint32_t)key[209] + 2664883792u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 7:{ uint32_t xIndex1 = 1523629777 % dataLength; uint32_t xIndex2 = ((uint32_t)key[80] + 3955174355u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 8:{ uint32_t xIndex1 = 2664883792 % dataLength; uint32_t xIndex2 = ((uint32_t)key[211] + 2282104650u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 9:{ uint32_t xIndex1 = 3955174355 % dataLength; uint32_t xIndex2 = ((uint32_t)key[74] + 2153894117u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 10:{ uint32_t xIndex1 = 2282104650 % dataLength; uint32_t xIndex2 = ((uint32_t)key[229] + 3979149332u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 11:{ uint32_t xIndex = 2153894117 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[20] ^ 135u); }break;
			case 12:{ uint32_t xIndex = 3979149332 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[135] ^ 46u); }break;
			case 13:{ uint32_t xIndex1 = 752938631 % dataLength; uint32_t xIndex2 = ((uint32_t)key[46] + 4275751225u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 14:{ uint32_t xIndex1 = 74755886 % dataLength; uint32_t xIndex2 = ((uint32_t)key[57] + 2092197656u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 15:{ uint32_t xIndex = 4275751225 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[24] - 123u); }break;
			case 16:{ uint32_t xIndex = 2092197656 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[123] - 82u); }break;
			case 17:{ uint32_t xIndex = 2863909243 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[82] ^ 205u); }break;
			case 18:{ uint32_t xIndex = 503377490 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[205] - 92u); }break;
			case 19:{ uint32_t xIndex1 = 2959580109 % dataLength; uint32_t xIndex2 = ((uint32_t)key[92] + 467882159u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 20:{ uint32_t xIndex = 1203322716 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[175] ^ 182u); }break;
			case 21:{ uint32_t xIndex = 467882159 % dataLength; uint32_t shift = (uint32_t)(key[182] + 1697676449u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 22:{ uint32_t xIndex = 4294453430 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[161] - 224u); }break;
			case 23:{ uint32_t xIndex = 1697676449 % dataLength; uint32_t shift = (uint32_t)(key[224] + 1459181603u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 24:{ uint32_t xIndex = 663940320 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[35] ^ 90u); }break;
			case 25:{ uint32_t xIndex = 1459181603 % dataLength; uint32_t shift = (uint32_t)(key[90] + 1445846965u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 26:{ uint32_t xIndex = 1057808986 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[181] ^ 164u); }break;
			case 27:{ uint32_t xIndex1 = 1445846965 % dataLength; uint32_t xIndex2 = ((uint32_t)key[164] + 2077357015u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 28:{ uint32_t xIndex = 3425178532 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[215] - 62u); }break;
			case 29:{ uint32_t xIndex = 2077357015 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[62] ^ 9u); }break;
			case 30:{ uint32_t xIndex1 = 754638654 % dataLength; uint32_t xIndex2 = ((uint32_t)key[9] + 1286772648u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 31:{ uint32_t xIndex = 3124525321 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[168] ^ 203u); }break;
			case 32:{ uint32_t xIndex = 1286772648 % dataLength; uint32_t shift = (uint32_t)(key[203] + 2406163298u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 33:{ uint32_t xIndex = 1364162507 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[98] - 157u); }break;
			case 34:{ uint32_t xIndex1 = 2406163298 % dataLength; uint32_t xIndex2 = ((uint32_t)key[157] + 902012140u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 35:{ uint32_t xIndex1 = 829504669 % dataLength; uint32_t xIndex2 = ((uint32_t)key[236] + 726562815u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 36:{ uint32_t xIndex1 = 902012140 % dataLength; uint32_t xIndex2 = ((uint32_t)key[255] + 3189240518u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 37:{ uint32_t xIndex = 726562815 % dataLength; uint32_t shift = (uint32_t)(key[198] + 4205665905u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 38:{ uint32_t xIndex = 3189240518 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[113] ^ 112u); }break;
			case 39:{ uint32_t xIndex = 4205665905 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[112] ^ 115u); }break;
			case 40:{ uint32_t xIndex1 = 948406128 % dataLength; uint32_t xIndex2 = ((uint32_t)key[115] + 1815138666u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 41:{ uint32_t xIndex = 3973695603 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[106] ^ 133u); }break;
			case 42:{ uint32_t xIndex1 = 1815138666 % dataLength; uint32_t xIndex2 = ((uint32_t)key[133] + 3746167604u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 43:{ uint32_t xIndex1 = 661803653 % dataLength; uint32_t xIndex2 = ((uint32_t)key[52] + 4204690727u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 44:{ uint32_t xIndex = 3746167604 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[39] - 78u); }break;
			case 45:{ uint32_t xIndex1 = 4204690727 % dataLength; uint32_t xIndex2 = ((uint32_t)key[78] + 1106627801u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 46:{ uint32_t xIndex = 2701034318 % dataLength; uint32_t shift = (uint32_t)(key[217] + 3946437688u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 47:{ uint32_t xIndex1 = 1106627801 % dataLength; uint32_t xIndex2 = ((uint32_t)key[56] + 832563739u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 48:{ uint32_t xIndex1 = 3946437688 % dataLength; uint32_t xIndex2 = ((uint32_t)key[27] + 2747731058u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 49:{ uint32_t xIndex = 832563739 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[114] - 109u); }break;
			case 50:{ uint32_t xIndex1 = 2747731058 % dataLength; uint32_t xIndex2 = ((uint32_t)key[109] + 1064128124u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 51:{ uint32_t xIndex = 427147629 % dataLength; uint32_t shift = (uint32_t)(key[124] + 908829519u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 52:{ uint32_t xIndex1 = 1064128124 % dataLength; uint32_t xIndex2 = ((uint32_t)key[79] + 3740381398u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 53:{ uint32_t xIndex = 908829519 % dataLength; uint32_t shift = (uint32_t)(key[214] + 2831967297u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 54:{ uint32_t xIndex = 3740381398 % dataLength; uint32_t shift = (uint32_t)(key[65] + 2099623424u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 55:{ uint32_t xIndex = 2831967297 % dataLength; uint32_t shift = (uint32_t)(key[0] + 2936896707u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 56:{ uint32_t xIndex1 = 2099623424 % dataLength; uint32_t xIndex2 = ((uint32_t)key[195] + 4268422266u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 57:{ uint32_t xIndex1 = 2936896707 % dataLength; uint32_t xIndex2 = ((uint32_t)key[122] + 1262758229u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 58:{ uint32_t xIndex = 4268422266 % dataLength; uint32_t shift = (uint32_t)(key[85] + 3042162372u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 59:{ uint32_t xIndex1 = 1262758229 % dataLength; uint32_t xIndex2 = ((uint32_t)key[196] + 1090751095u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 60:{ uint32_t xIndex = 3042162372 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[119] - 94u); }break;
			case 61:{ uint32_t xIndex = 1090751095 % dataLength; uint32_t shift = (uint32_t)(key[94] + 3014378665u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 62:{ uint32_t xIndex1 = 3444087646 % dataLength; uint32_t xIndex2 = ((uint32_t)key[169] + 3545969864u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 63:{ uint32_t xIndex = 3014378665 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[200] ^ 107u); }break;
			case 64:{ uint32_t xIndex = 3545969864 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[107] - 130u); }break;
			case 65:{ uint32_t xIndex = 1584537707 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[130] ^ 61u); }break;
			case 66:{ uint32_t xIndex = 2527963522 % dataLength; uint32_t shift = (uint32_t)(key[61] + 2769769484u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 67:{ uint32_t xIndex1 = 1504324157 % dataLength; uint32_t xIndex2 = ((uint32_t)key[12] + 1062720159u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 68:{ uint32_t xIndex1 = 2769769484 % dataLength; uint32_t xIndex2 = ((uint32_t)key[159] + 233726694u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 69:{ uint32_t xIndex1 = 1062720159 % dataLength; uint32_t xIndex2 = ((uint32_t)key[230] + 1364364817u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 70:{ uint32_t xIndex = 233726694 % dataLength; uint32_t shift = (uint32_t)(key[17] + 2753460368u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 71:{ uint32_t xIndex = 1364364817 % dataLength; uint32_t shift = (uint32_t)(key[144] + 2508289299u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 72:{ uint32_t xIndex = 2753460368 % dataLength; uint32_t shift = (uint32_t)(key[19] + 32787338u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 73:{ uint32_t xIndex1 = 2508289299 % dataLength; uint32_t xIndex2 = ((uint32_t)key[138] + 3237504037u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 74:{ uint32_t xIndex1 = 32787338 % dataLength; uint32_t xIndex2 = ((uint32_t)key[37] + 3829810772u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 75:{ uint32_t xIndex = 3237504037 % dataLength; uint32_t shift = (uint32_t)(key[84] + 3506314183u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 76:{ uint32_t xIndex1 = 3829810772 % dataLength; uint32_t xIndex2 = ((uint32_t)key[199] + 1608656750u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 77:{ uint32_t xIndex1 = 3506314183 % dataLength; uint32_t xIndex2 = ((uint32_t)key[110] + 1766023289u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 78:{ uint32_t xIndex1 = 1608656750 % dataLength; uint32_t xIndex2 = ((uint32_t)key[121] + 3412566360u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 79:{ uint32_t xIndex1 = 1766023289 % dataLength; uint32_t xIndex2 = ((uint32_t)key[88] + 148052667u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 80:{ uint32_t xIndex = 3412566360 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[187] ^ 146u); }break;
			case 81:{ uint32_t xIndex = 148052667 % dataLength; uint32_t shift = (uint32_t)(key[146] + 4085479181u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 82:{ uint32_t xIndex = 1224211090 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[13] ^ 156u); }break;
			case 83:{ uint32_t xIndex1 = 4085479181 % dataLength; uint32_t xIndex2 = ((uint32_t)key[156] + 3689940463u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 84:{ uint32_t xIndex = 1986178460 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[239] ^ 246u); }break;
			case 85:{ uint32_t xIndex = 3689940463 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[246] - 225u); }break;
			case 86:{ uint32_t xIndex = 1068959990 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[225] ^ 32u); }break;
			case 87:{ uint32_t xIndex1 = 4198816737 % dataLength; uint32_t xIndex2 = ((uint32_t)key[32] + 3731009891u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 88:{ uint32_t xIndex = 4016230176 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[99] ^ 154u); }break;
			case 89:{ uint32_t xIndex1 = 3731009891 % dataLength; uint32_t xIndex2 = ((uint32_t)key[154] + 2360053u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 90:{ uint32_t xIndex = 2957366938 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[245] - 228u); }break;
			case 91:{ uint32_t xIndex = 2360053 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[228] - 23u); }break;
			case 92:{ uint32_t xIndex1 = 2573380068 % dataLength; uint32_t xIndex2 = ((uint32_t)key[23] + 1477715838u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 93:{ uint32_t xIndex1 = 1724592407 % dataLength; uint32_t xIndex2 = ((uint32_t)key[126] + 3370229833u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 94:{ uint32_t xIndex1 = 1477715838 % dataLength; uint32_t xIndex2 = ((uint32_t)key[73] + 1961894376u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 95:{ uint32_t xIndex1 = 3370229833 % dataLength; uint32_t xIndex2 = ((uint32_t)key[232] + 3490699531u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 96:{ uint32_t xIndex1 = 1961894376 % dataLength; uint32_t xIndex2 = ((uint32_t)key[11] + 1354694562u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 97:{ uint32_t xIndex1 = 3490699531 % dataLength; uint32_t xIndex2 = ((uint32_t)key[162] + 3367413725u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 98:{ uint32_t xIndex = 1354694562 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[221] - 44u); }break;
			case 99:{ uint32_t xIndex = 3367413725 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[44] - 63u); }break;
			case 100:{ uint32_t xIndex1 = 573594412 % dataLength; uint32_t xIndex2 = ((uint32_t)key[63] + 3258229510u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 101:{ uint32_t xIndex = 2203139391 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[6] ^ 177u); }break;
			case 102:{ uint32_t xIndex1 = 3258229510 % dataLength; uint32_t xIndex2 = ((uint32_t)key[177] + 3290675632u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 103:{ uint32_t xIndex = 2649247153 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[176] - 179u); }break;
			case 104:{ uint32_t xIndex = 3290675632 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[179] ^ 170u); }break;
			case 105:{ uint32_t xIndex1 = 1579037107 % dataLength; uint32_t xIndex2 = ((uint32_t)key[170] + 3365668293u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 106:{ uint32_t xIndex1 = 2149094826 % dataLength; uint32_t xIndex2 = ((uint32_t)key[197] + 690610548u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 107:{ uint32_t xIndex1 = 3365668293 % dataLength; uint32_t xIndex2 = ((uint32_t)key[116] + 1223150183u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 108:{ uint32_t xIndex = 690610548 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[103] - 142u); }break;
			case 109:{ uint32_t xIndex1 = 1223150183 % dataLength; uint32_t xIndex2 = ((uint32_t)key[142] + 350979097u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 110:{ uint32_t xIndex1 = 375888782 % dataLength; uint32_t xIndex2 = ((uint32_t)key[25] + 3703944824u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 111:{ uint32_t xIndex1 = 350979097 % dataLength; uint32_t xIndex2 = ((uint32_t)key[120] + 297098075u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 112:{ uint32_t xIndex1 = 3703944824 % dataLength; uint32_t xIndex2 = ((uint32_t)key[91] + 157006002u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 113:{ uint32_t xIndex1 = 297098075 % dataLength; uint32_t xIndex2 = ((uint32_t)key[178] + 1798880429u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 114:{ uint32_t xIndex = 157006002 % dataLength; uint32_t shift = (uint32_t)(key[173] + 111238332u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 115:{ uint32_t xIndex = 1798880429 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[188] ^ 143u); }break;
			case 116:{ uint32_t xIndex1 = 111238332 % dataLength; uint32_t xIndex2 = ((uint32_t)key[143] + 1284518166u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 117:{ uint32_t xIndex = 3742922895 % dataLength; uint32_t shift = (uint32_t)(key[22] + 4207010689u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 118:{ uint32_t xIndex1 = 1284518166 % dataLength; uint32_t xIndex2 = ((uint32_t)key[129] + 986855488u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 119:{ uint32_t xIndex = 4207010689 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[64] ^ 3u); }break;
			case 120:{ uint32_t xIndex = 986855488 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[3] - 186u); }break;
			case 121:{ uint32_t xIndex = 3479238147 % dataLength; uint32_t shift = (uint32_t)(key[186] + 4067781781u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 122:{ uint32_t xIndex1 = 895846586 % dataLength; uint32_t xIndex2 = ((uint32_t)key[149] + 2673667332u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 123:{ uint32_t xIndex1 = 4067781781 % dataLength; uint32_t xIndex2 = ((uint32_t)key[4] + 2551244727u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 124:{ uint32_t xIndex = 2673667332 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[183] - 158u); }break;
			case 125:{ uint32_t xIndex = 2551244727 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[158] - 233u); }break;
			case 126:{ uint32_t xIndex1 = 1822786462 % dataLength; uint32_t xIndex2 = ((uint32_t)key[233] + 184114952u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 127:{ uint32_t xIndex1 = 1007029225 % dataLength; uint32_t xIndex2 = ((uint32_t)key[8] + 965779883u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 128:{ uint32_t xIndex1 = 184114952 % dataLength; uint32_t xIndex2 = ((uint32_t)key[171] + 2741446082u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 129:{ uint32_t xIndex = 965779883 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[194] ^ 125u); }break;
			case 130:{ uint32_t xIndex1 = 2741446082 % dataLength; uint32_t xIndex2 = ((uint32_t)key[125] + 18264652u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 131:{ uint32_t xIndex1 = 3980309885 % dataLength; uint32_t xIndex2 = ((uint32_t)key[76] + 455260127u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 132:{ uint32_t xIndex1 = 18264652 % dataLength; uint32_t xIndex2 = ((uint32_t)key[223] + 254980902u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 133:{ uint32_t xIndex = 455260127 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[38] ^ 81u); }break;
			case 134:{ uint32_t xIndex1 = 254980902 % dataLength; uint32_t xIndex2 = ((uint32_t)key[81] + 2938063568u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 135:{ uint32_t xIndex1 = 1670815057 % dataLength; uint32_t xIndex2 = ((uint32_t)key[208] + 588774995u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 136:{ uint32_t xIndex1 = 2938063568 % dataLength; uint32_t xIndex2 = ((uint32_t)key[83] + 4049973194u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 137:{ uint32_t xIndex1 = 588774995 % dataLength; uint32_t xIndex2 = ((uint32_t)key[202] + 1040529253u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 138:{ uint32_t xIndex1 = 4049973194 % dataLength; uint32_t xIndex2 = ((uint32_t)key[101] + 1325190292u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 139:{ uint32_t xIndex = 1040529253 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[148] ^ 7u); }break;
			case 140:{ uint32_t xIndex = 1325190292 % dataLength; uint32_t shift = (uint32_t)(key[7] + 2916540334u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 141:{ uint32_t xIndex1 = 2672003335 % dataLength; uint32_t xIndex2 = ((uint32_t)key[174] + 2836805561u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 142:{ uint32_t xIndex1 = 2916540334 % dataLength; uint32_t xIndex2 = ((uint32_t)key[185] + 2463898520u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 143:{ uint32_t xIndex = 2836805561 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[152] ^ 251u); }break;
			case 144:{ uint32_t xIndex = 2463898520 % dataLength; uint32_t shift = (uint32_t)(key[251] + 884623058u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 145:{ uint32_t xIndex = 296659963 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[210] - 77u); }break;
			case 146:{ uint32_t xIndex = 884623058 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[77] ^ 220u); }break;
			case 147:{ uint32_t xIndex1 = 2973602381 % dataLength; uint32_t xIndex2 = ((uint32_t)key[220] + 898431791u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 148:{ uint32_t xIndex1 = 4264647644 % dataLength; uint32_t xIndex2 = ((uint32_t)key[47] + 3284478262u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 149:{ uint32_t xIndex = 898431791 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[54] - 33u); }break;
			case 150:{ uint32_t xIndex = 3284478262 % dataLength; uint32_t shift = (uint32_t)(key[33] + 1341911392u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 151:{ uint32_t xIndex = 2406185761 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[96] - 163u); }break;
			case 152:{ uint32_t xIndex1 = 1341911392 % dataLength; uint32_t xIndex2 = ((uint32_t)key[163] + 1116867290u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 153:{ uint32_t xIndex = 3497020067 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[218] - 53u); }break;
			case 154:{ uint32_t xIndex1 = 1116867290 % dataLength; uint32_t xIndex2 = ((uint32_t)key[53] + 1649049636u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 155:{ uint32_t xIndex1 = 601908789 % dataLength; uint32_t xIndex2 = ((uint32_t)key[36] + 599567959u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 156:{ uint32_t xIndex = 1649049636 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[87] ^ 190u); }break;
			case 157:{ uint32_t xIndex = 599567959 % dataLength; uint32_t shift = (uint32_t)(key[190] + 323028873u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 158:{ uint32_t xIndex = 3192172478 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[137] - 40u); }break;
			case 159:{ uint32_t xIndex = 323028873 % dataLength; uint32_t shift = (uint32_t)(key[40] + 308050507u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 160:{ uint32_t xIndex1 = 587131944 % dataLength; uint32_t xIndex2 = ((uint32_t)key[75] + 3362659298u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 161:{ uint32_t xIndex1 = 308050507 % dataLength; uint32_t xIndex2 = ((uint32_t)key[226] + 971658013u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 162:{ uint32_t xIndex = 3362659298 % dataLength; uint32_t shift = (uint32_t)(key[29] + 2312264044u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 163:{ uint32_t xIndex1 = 971658013 % dataLength; uint32_t xIndex2 = ((uint32_t)key[108] + 1320436351u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 164:{ uint32_t xIndex1 = 2312264044 % dataLength; uint32_t xIndex2 = ((uint32_t)key[127] + 3174077254u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 165:{ uint32_t xIndex1 = 1320436351 % dataLength; uint32_t xIndex2 = ((uint32_t)key[70] + 1770355953u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 166:{ uint32_t xIndex = 3174077254 % dataLength; uint32_t shift = (uint32_t)(key[241] + 2946051056u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 167:{ uint32_t xIndex = 1770355953 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[240] - 243u); }break;
			case 168:{ uint32_t xIndex = 2946051056 % dataLength; uint32_t shift = (uint32_t)(key[243] + 883137002u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 169:{ uint32_t xIndex1 = 618060531 % dataLength; uint32_t xIndex2 = ((uint32_t)key[234] + 2765879557u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 170:{ uint32_t xIndex = 883137002 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[5] - 180u); }break;
			case 171:{ uint32_t xIndex = 2765879557 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[180] - 167u); }break;
			case 172:{ uint32_t xIndex1 = 1791428532 % dataLength; uint32_t xIndex2 = ((uint32_t)key[167] + 595063758u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 173:{ uint32_t xIndex1 = 3036239783 % dataLength; uint32_t xIndex2 = ((uint32_t)key[206] + 1307278169u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 174:{ uint32_t xIndex1 = 595063758 % dataLength; uint32_t xIndex2 = ((uint32_t)key[89] + 355651768u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 175:{ uint32_t xIndex1 = 1307278169 % dataLength; uint32_t xIndex2 = ((uint32_t)key[184] + 2988903579u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 176:{ uint32_t xIndex1 = 355651768 % dataLength; uint32_t xIndex2 = ((uint32_t)key[155] + 1859888370u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 177:{ uint32_t xIndex = 2988903579 % dataLength; uint32_t shift = (uint32_t)(key[242] + 4198103021u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 178:{ uint32_t xIndex1 = 1859888370 % dataLength; uint32_t xIndex2 = ((uint32_t)key[237] + 1595583228u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 179:{ uint32_t xIndex = 4198103021 % dataLength; uint32_t shift = (uint32_t)(key[252] + 4181036495u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 180:{ uint32_t xIndex = 1595583228 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[207] ^ 86u); }break;
			case 181:{ uint32_t xIndex = 4181036495 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[86] - 193u); }break;
			case 182:{ uint32_t xIndex1 = 4154323286 % dataLength; uint32_t xIndex2 = ((uint32_t)key[193] + 1399323264u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 183:{ uint32_t xIndex = 3781796545 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[128] ^ 67u); }break;
			case 184:{ uint32_t xIndex = 1399323264 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[67] - 250u); }break;
			case 185:{ uint32_t xIndex = 2482548547 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[250] ^ 213u); }break;
			case 186:{ uint32_t xIndex = 1620270330 % dataLength; uint32_t shift = (uint32_t)(key[213] + 4046676804u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 187:{ uint32_t xIndex1 = 437055445 % dataLength; uint32_t xIndex2 = ((uint32_t)key[68] + 4239820023u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 188:{ uint32_t xIndex = 4046676804 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[247] ^ 222u); }break;
			case 189:{ uint32_t xIndex = 4239820023 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[222] ^ 41u); }break;
			case 190:{ uint32_t xIndex = 339323870 % dataLength; uint32_t shift = (uint32_t)(key[41] + 4270377288u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 191:{ uint32_t xIndex1 = 414880553 % dataLength; uint32_t xIndex2 = ((uint32_t)key[72] + 3051053803u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 192:{ uint32_t xIndex = 4270377288 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[235] ^ 2u); }break;
			case 193:{ uint32_t xIndex1 = 3051053803 % dataLength; uint32_t xIndex2 = ((uint32_t)key[2] + 627146941u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 194:{ uint32_t xIndex1 = 1302061570 % dataLength; uint32_t xIndex2 = ((uint32_t)key[189] + 4167782540u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 195:{ uint32_t xIndex1 = 627146941 % dataLength; uint32_t xIndex2 = ((uint32_t)key[140] + 2314067231u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 196:{ uint32_t xIndex = 4167782540 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[31] ^ 102u); }break;
			case 197:{ uint32_t xIndex = 2314067231 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[102] - 145u); }break;
			case 198:{ uint32_t xIndex = 678839142 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[145] ^ 16u); }break;
			case 199:{ uint32_t xIndex = 3135040657 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[16] - 147u); }break;
			case 200:{ uint32_t xIndex1 = 1142512912 % dataLength; uint32_t xIndex2 = ((uint32_t)key[147] + 4237972490u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 201:{ uint32_t xIndex1 = 130205587 % dataLength; uint32_t xIndex2 = ((uint32_t)key[10] + 80235173u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 202:{ uint32_t xIndex1 = 4237972490 % dataLength; uint32_t xIndex2 = ((uint32_t)key[165] + 93360852u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 203:{ uint32_t xIndex1 = 80235173 % dataLength; uint32_t xIndex2 = ((uint32_t)key[212] + 250689095u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 204:{ uint32_t xIndex = 93360852 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[71] ^ 238u); }break;
			case 205:{ uint32_t xIndex1 = 250689095 % dataLength; uint32_t xIndex2 = ((uint32_t)key[238] + 4019408633u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 206:{ uint32_t xIndex1 = 2291324910 % dataLength; uint32_t xIndex2 = ((uint32_t)key[249] + 1062327768u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 207:{ uint32_t xIndex = 4019408633 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[216] ^ 59u); }break;
			case 208:{ uint32_t xIndex = 1062327768 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[59] ^ 18u); }break;
			case 209:{ uint32_t xIndex1 = 2156297531 % dataLength; uint32_t xIndex2 = ((uint32_t)key[18] + 2127949197u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 210:{ uint32_t xIndex1 = 2944914194 % dataLength; uint32_t xIndex2 = ((uint32_t)key[141] + 526731804u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 211:{ uint32_t xIndex = 2127949197 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[28] - 111u); }break;
			case 212:{ uint32_t xIndex = 526731804 % dataLength; uint32_t shift = (uint32_t)(key[111] + 3462564214u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 213:{ uint32_t xIndex1 = 1744449647 % dataLength; uint32_t xIndex2 = ((uint32_t)key[118] + 1575246433u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 214:{ uint32_t xIndex = 3462564214 % dataLength; uint32_t shift = (uint32_t)(key[97] + 2644399008u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 215:{ uint32_t xIndex1 = 1575246433 % dataLength; uint32_t xIndex2 = ((uint32_t)key[160] + 811738083u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 216:{ uint32_t xIndex = 2644399008 % dataLength; uint32_t shift = (uint32_t)(key[227] + 3962666778u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 217:{ uint32_t xIndex1 = 811738083 % dataLength; uint32_t xIndex2 = ((uint32_t)key[26] + 3735226741u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 218:{ uint32_t xIndex1 = 3962666778 % dataLength; uint32_t xIndex2 = ((uint32_t)key[117] + 3474953828u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 219:{ uint32_t xIndex1 = 3735226741 % dataLength; uint32_t xIndex2 = ((uint32_t)key[100] + 3118885783u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 220:{ uint32_t xIndex1 = 3474953828 % dataLength; uint32_t xIndex2 = ((uint32_t)key[151] + 1238136830u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 221:{ uint32_t xIndex = 3118885783 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[254] - 201u); }break;
			case 222:{ uint32_t xIndex1 = 1238136830 % dataLength; uint32_t xIndex2 = ((uint32_t)key[201] + 2468279912u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 223:{ uint32_t xIndex1 = 3667570377 % dataLength; uint32_t xIndex2 = ((uint32_t)key[104] + 1668635531u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 224:{ uint32_t xIndex = 2468279912 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[139] ^ 34u); }break;
			case 225:{ uint32_t xIndex1 = 1668635531 % dataLength; uint32_t xIndex2 = ((uint32_t)key[34] + 709639773u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 226:{ uint32_t xIndex1 = 347633698 % dataLength; uint32_t xIndex2 = ((uint32_t)key[93] + 2095683500u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 227:{ uint32_t xIndex = 709639773 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[172] - 191u); }break;
			case 228:{ uint32_t xIndex1 = 2095683500 % dataLength; uint32_t xIndex2 = ((uint32_t)key[191] + 1095484294u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 229:{ uint32_t xIndex1 = 1555531711 % dataLength; uint32_t xIndex2 = ((uint32_t)key[134] + 2797923377u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 230:{ uint32_t xIndex = 1095484294 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[49] ^ 48u); }break;
			case 231:{ uint32_t xIndex = 2797923377 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[48] - 51u); }break;
			case 232:{ uint32_t xIndex = 522706480 % dataLength; uint32_t shift = (uint32_t)(key[51] + 3490831914u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 233:{ uint32_t xIndex1 = 3561210931 % dataLength; uint32_t xIndex2 = ((uint32_t)key[42] + 3916573765u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 234:{ uint32_t xIndex = 3490831914 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[69] ^ 244u); }break;
			case 235:{ uint32_t xIndex = 3916573765 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[244] - 231u); }break;
			case 236:{ uint32_t xIndex = 476147188 % dataLength; uint32_t shift = (uint32_t)(key[231] + 40864782u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 237:{ uint32_t xIndex = 3591578855 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[14] ^ 153u); }break;
			case 238:{ uint32_t xIndex1 = 40864782 % dataLength; uint32_t xIndex2 = ((uint32_t)key[153] + 2697014008u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 239:{ uint32_t xIndex = 1043706521 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[248] ^ 219u); }break;
			case 240:{ uint32_t xIndex1 = 2697014008 % dataLength; uint32_t xIndex2 = ((uint32_t)key[219] + 1116131634u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 241:{ uint32_t xIndex = 3996450267 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[50] - 45u); }break;
			case 242:{ uint32_t xIndex1 = 1116131634 % dataLength; uint32_t xIndex2 = ((uint32_t)key[45] + 689518908u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 243:{ uint32_t xIndex1 = 2075751213 % dataLength; uint32_t xIndex2 = ((uint32_t)key[60] + 3821200143u) % dataLength; byte temp = data[xIndex1]; data[xIndex1] = data[xIndex2]; data[xIndex2] = temp; }break;
			case 244:{ uint32_t xIndex = 689518908 % dataLength; uint32_t shift = (uint32_t)(key[15] + 3260739990u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 245:{ uint32_t xIndex1 = 3821200143 % dataLength; uint32_t xIndex2 = ((uint32_t)key[150] + 3053691393u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 246:{ uint32_t xIndex1 = 3260739990 % dataLength; uint32_t xIndex2 = ((uint32_t)key[1] + 3139894464u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 247:{ uint32_t xIndex1 = 3053691393 % dataLength; uint32_t xIndex2 = ((uint32_t)key[192] + 538224771u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 248:{ uint32_t xIndex = 3139894464 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[131] ^ 58u); }break;
			case 249:{ uint32_t xIndex1 = 538224771 % dataLength; uint32_t xIndex2 = ((uint32_t)key[58] + 4283085589u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 250:{ uint32_t xIndex = 372535610 % dataLength; uint32_t shift = (uint32_t)(key[21] + 4078377348u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 251:{ uint32_t xIndex = 4283085589 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] - (uint32_t)key[132] - 55u); }break;
			case 252:{ uint32_t xIndex = 4078377348 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[55] ^ 30u); }break;
			case 253:{ uint32_t xIndex = 2520015415 % dataLength; uint32_t shift = (uint32_t)(key[30] + 2869516905u) % 8; data[xIndex] = (byte)(((uint32_t)data[xIndex] >> shift) | ((uint32_t)data[xIndex] << (8 - shift))); }break;
			case 254:{ uint32_t xIndex1 = 1313149982 % dataLength; uint32_t xIndex2 = ((uint32_t)key[105] + 2320069512u) % dataLength; byte a = data[xIndex1]; byte b = data[xIndex2] - 1; data[xIndex1] = a - b; data[xIndex2] = b; }break;
			case 255:{ uint32_t xIndex = 2869516905 % dataLength; data[xIndex] = (byte)((uint32_t)data[xIndex] ^ (uint32_t)key[136] ^ 43u); }break;


				//!!!}}INSTRUCTIONS
			}
		}
	}

}
}

