#include "RuntimeApi.h"

#include "vm/Runtime.h"

#include "vm/InternalCalls.h"
#include "vm/Array.h"
#include "vm/Exception.h"

#include "codegen/il2cpp-codegen.h"
#include "metadata/MetadataModule.h"
#include "RuntimeConfig.h"
#include "metadata/Assembly.h"

namespace hybridclr
{
	void RuntimeApi::RegisterInternalCalls()
	{
		il2cpp::vm::InternalCalls::Add("HybridCLR.RuntimeApi::LoadMetadataForAOTAssembly(System.Byte[],HybridCLR.HomologousImageMode)", (Il2CppMethodPointer)LoadMetadataForAOTAssembly);
		il2cpp::vm::InternalCalls::Add("HybridCLR.RuntimeApi::GetRuntimeOption(HybridCLR.RuntimeOptionId)", (Il2CppMethodPointer)GetRuntimeOption);
		il2cpp::vm::InternalCalls::Add("HybridCLR.RuntimeApi::SetRuntimeOption(HybridCLR.RuntimeOptionId,System.Int32)", (Il2CppMethodPointer)SetRuntimeOption);
		il2cpp::vm::InternalCalls::Add("HybridCLR.RuntimeApi::IsFullGenericSharingEnabled()", (Il2CppMethodPointer)IsFullGenericSharingEnabled);
		il2cpp::vm::InternalCalls::Add("HybridCLR.RuntimeApi::LoadDifferentialHybridAssembly(System.Byte[],System.Byte[])", (Il2CppMethodPointer)LoadDifferentialHybridAssembly);
	}

	int32_t RuntimeApi::LoadMetadataForAOTAssembly(Il2CppArray* dllBytes, int32_t mode)
	{
		if (!dllBytes)
		{
			il2cpp::vm::Exception::RaiseNullReferenceException();
		}
		return (int32_t)hybridclr::metadata::Assembly::LoadMetadataForAOTAssembly(il2cpp::vm::Array::GetFirstElementAddress(dllBytes), il2cpp::vm::Array::GetByteLength(dllBytes), (hybridclr::metadata::HomologousImageMode)mode);
	}

	int32_t RuntimeApi::GetRuntimeOption(int32_t optionId)
	{
		return hybridclr::RuntimeConfig::GetRuntimeOption((hybridclr::RuntimeOptionId)optionId);
	}

	void RuntimeApi::SetRuntimeOption(int32_t optionId, int32_t value)
	{
		hybridclr::RuntimeConfig::SetRuntimeOption((hybridclr::RuntimeOptionId)optionId, value);
	}

	bool RuntimeApi::IsFullGenericSharingEnabled()
	{
#if !HYBRIDCLR_UNITY_2021_OR_NEW
		return false;
#elif HYBRIDCLR_UNITY_2021
		return il2cpp::vm::Runtime::IsFullGenericSharingEnabled();
#else
		return true;
#endif
	}

	int32_t RuntimeApi::LoadDifferentialHybridAssembly(Il2CppArray* dllData, Il2CppArray* optionData)
	{
		if (!dllData)
		{
			il2cpp::vm::Exception::Raise(il2cpp::vm::Exception::GetArgumentNullException("dllData is null"));
		}
		if (!optionData)
		{
			il2cpp::vm::Exception::Raise(il2cpp::vm::Exception::GetArgumentNullException("optionData is null"));
		}
		return (int32_t)hybridclr::metadata::Assembly::LoadDifferentialHybridAssembly(
			il2cpp::vm::Array::GetFirstElementAddress(dllData),
			il2cpp::vm::Array::GetByteLength(dllData),
			il2cpp::vm::Array::GetFirstElementAddress(optionData),
			il2cpp::vm::Array::GetByteLength(optionData));
	}
}
