/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res.decoder;

import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResConfigFlags;
import brut.androlib.res.data.ResID;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResType;
import brut.androlib.res.data.ResTypeSpec;
import brut.androlib.res.data.arsc.ARSCData;
import brut.androlib.res.data.arsc.ARSCHeader;
import brut.androlib.res.data.arsc.EntryData;
import brut.androlib.res.data.arsc.FlagsOffset;
import brut.androlib.res.data.value.ResBagValue;
import brut.androlib.res.data.value.ResFileValue;
import brut.androlib.res.data.value.ResIntBasedValue;
import brut.androlib.res.data.value.ResReferenceValue;
import brut.androlib.res.data.value.ResScalarValue;
import brut.androlib.res.data.value.ResStringValue;
import brut.androlib.res.data.value.ResValue;
import brut.androlib.res.data.value.ResValueFactory;
import brut.androlib.res.decoder.StringBlock;
import brut.util.Duo;
import brut.util.ExtCountingDataInput;
import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Logger;

public class ARSCDecoder {
    private final ExtCountingDataInput mIn;
    private final ResTable mResTable;
    private final List<FlagsOffset> mFlagsOffsets;
    private final boolean mKeepBroken;
    private ARSCHeader mHeader;
    private StringBlock mTableStrings;
    private StringBlock mTypeNames;
    private StringBlock mSpecNames;
    private ResPackage mPkg;
    private ResTypeSpec mTypeSpec;
    private ResType mType;
    private int mResId;
    private int mTypeIdOffset = 0;
    private final HashMap<Integer, Integer> mMissingResSpecMap;
    private final HashMap<Integer, ResTypeSpec> mResTypeSpecs = new HashMap();
    private static final Logger LOGGER = Logger.getLogger(ARSCDecoder.class.getName());

    public static ARSCData decode(InputStream arscStream, boolean findFlagsOffsets, boolean keepBroken) throws AndrolibException {
        return ARSCDecoder.decode(arscStream, findFlagsOffsets, keepBroken, new ResTable());
    }

    public static ARSCData decode(InputStream arscStream, boolean findFlagsOffsets, boolean keepBroken, ResTable resTable) throws AndrolibException {
        try {
            ARSCDecoder decoder = new ARSCDecoder(arscStream, resTable, findFlagsOffsets, keepBroken);
            ResPackage[] pkgs = decoder.readResourceTable();
            return new ARSCData(pkgs, decoder.mFlagsOffsets == null ? null : decoder.mFlagsOffsets.toArray(new FlagsOffset[0]));
        }
        catch (IOException ex) {
            throw new AndrolibException("Could not decode arsc file", ex);
        }
    }

    private ARSCDecoder(InputStream arscStream, ResTable resTable, boolean storeFlagsOffsets, boolean keepBroken) {
        this.mFlagsOffsets = storeFlagsOffsets ? new ArrayList<FlagsOffset>() : null;
        this.mIn = new ExtCountingDataInput(new LittleEndianDataInputStream(arscStream));
        this.mResTable = resTable;
        this.mKeepBroken = keepBroken;
        this.mMissingResSpecMap = new LinkedHashMap<Integer, Integer>();
    }

    private ResPackage[] readResourceTable() throws IOException, AndrolibException {
        LinkedHashSet<ResPackage> pkgs = new LinkedHashSet<ResPackage>();
        int chunkNumber = 1;
        block12: while (true) {
            this.nextChunk();
            LOGGER.fine(String.format("Chunk #%d start=0x%08x type=0x%04x chunkSize=0x%08x", chunkNumber++, this.mIn.position(), this.mHeader.type, this.mHeader.chunkSize));
            switch (this.mHeader.type) {
                case 0: {
                    this.readUnknownChunk();
                    continue block12;
                }
                case 1: {
                    this.readStringPoolChunk();
                    continue block12;
                }
                case 2: {
                    this.readTableChunk();
                    continue block12;
                }
                case 512: {
                    this.mTypeIdOffset = 0;
                    pkgs.add(this.readTablePackage());
                    continue block12;
                }
                case 513: {
                    this.readTableType();
                    continue block12;
                }
                case 514: {
                    ResTypeSpec typeSpec = this.readTableSpecType();
                    this.addTypeSpec(typeSpec);
                    continue block12;
                }
                case 515: {
                    this.readLibraryType();
                    continue block12;
                }
                case 516: {
                    this.readOverlaySpec();
                    continue block12;
                }
                case 517: {
                    this.readOverlayPolicySpec();
                    continue block12;
                }
                case 518: {
                    this.readStagedAliasSpec();
                    continue block12;
                }
            }
            break;
        }
        if (this.mHeader.type != -1) {
            LOGGER.severe(String.format("Unknown chunk type: %04x", this.mHeader.type));
        }
        if (this.mResTable.getConfig().isDecodeResolveModeUsingDummies() && this.mPkg != null && this.mPkg.getResSpecCount() > 0) {
            this.addMissingResSpecs();
        }
        return pkgs.toArray(new ResPackage[0]);
    }

    private void readStringPoolChunk() throws IOException, AndrolibException {
        this.checkChunkType(1);
        this.mTableStrings = StringBlock.readWithoutChunk(this.mIn, this.mHeader.startPosition, this.mHeader.headerSize, this.mHeader.chunkSize);
    }

    private void readTableChunk() throws IOException, AndrolibException {
        this.checkChunkType(2);
        this.mIn.skipInt();
        this.mHeader.checkForUnreadHeader(this.mIn);
    }

    private void readUnknownChunk() throws IOException, AndrolibException {
        this.checkChunkType(0);
        this.mHeader.checkForUnreadHeader(this.mIn);
        LOGGER.warning("Skipping unknown chunk data of size " + this.mHeader.chunkSize);
        this.mHeader.skipChunk(this.mIn);
    }

    private ResPackage readTablePackage() throws IOException, AndrolibException {
        this.checkChunkType(512);
        int id = this.mIn.readInt();
        if (id == 0) {
            id = 2;
            if (this.mResTable.getPackageOriginal() == null && this.mResTable.getPackageRenamed() == null) {
                this.mResTable.setSharedLibrary(true);
            }
        }
        String name = this.mIn.readNullEndedString(128, true);
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        this.mIn.skipInt();
        int splitHeaderSize = 288;
        if (this.mHeader.headerSize == splitHeaderSize) {
            this.mTypeIdOffset = this.mIn.readInt();
        }
        if (this.mTypeIdOffset > 0) {
            LOGGER.warning("Please report this application to Apktool for a fix: https://github.com/iBotPeaches/Apktool/issues/1728");
        }
        this.mHeader.checkForUnreadHeader(this.mIn);
        this.mTypeNames = StringBlock.readWithChunk(this.mIn);
        this.mSpecNames = StringBlock.readWithChunk(this.mIn);
        this.mResId = id << 24;
        this.mPkg = new ResPackage(this.mResTable, id, name);
        return this.mPkg;
    }

    private void readLibraryType() throws AndrolibException, IOException {
        this.checkChunkType(515);
        int libraryCount = this.mIn.readInt();
        this.mHeader.checkForUnreadHeader(this.mIn);
        for (int i = 0; i < libraryCount; ++i) {
            int packageId = this.mIn.readInt();
            String packageName = this.mIn.readNullEndedString(128, true);
            LOGGER.info(String.format("Decoding Shared Library (%s), pkgId: %d", packageName, packageId));
        }
    }

    private void readStagedAliasSpec() throws IOException {
        int count = this.mIn.readInt();
        this.mHeader.checkForUnreadHeader(this.mIn);
        for (int i = 0; i < count; ++i) {
            LOGGER.fine(String.format("Staged alias: 0x%08x -> 0x%08x", this.mIn.readInt(), this.mIn.readInt()));
        }
    }

    private void readOverlaySpec() throws AndrolibException, IOException {
        this.checkChunkType(516);
        String name = this.mIn.readNullEndedString(256, true);
        String actor = this.mIn.readNullEndedString(256, true);
        this.mHeader.checkForUnreadHeader(this.mIn);
        LOGGER.fine(String.format("Overlay name: \"%s\", actor: \"%s\")", name, actor));
    }

    private void readOverlayPolicySpec() throws AndrolibException, IOException {
        this.checkChunkType(517);
        this.mIn.skipInt();
        int count = this.mIn.readInt();
        this.mHeader.checkForUnreadHeader(this.mIn);
        for (int i = 0; i < count; ++i) {
            LOGGER.fine(String.format("Skipping overlay (%h)", this.mIn.readInt()));
        }
    }

    private ResTypeSpec readTableSpecType() throws AndrolibException, IOException {
        this.checkChunkType(514);
        int id = this.mIn.readUnsignedByte();
        this.mIn.skipBytes(1);
        this.mIn.skipBytes(2);
        int entryCount = this.mIn.readInt();
        if (this.mFlagsOffsets != null) {
            this.mFlagsOffsets.add(new FlagsOffset(this.mIn.position(), entryCount));
        }
        this.mHeader.checkForUnreadHeader(this.mIn);
        this.mIn.skipBytes(entryCount * 4);
        this.mTypeSpec = new ResTypeSpec(this.mTypeNames.getString(id - 1), id);
        this.mPkg.addType(this.mTypeSpec);
        return this.mTypeSpec;
    }

    private ResType readTableType() throws IOException, AndrolibException {
        boolean isSparse;
        this.checkChunkType(513);
        int typeId = this.mIn.readUnsignedByte() - this.mTypeIdOffset;
        if (this.mResTypeSpecs.containsKey(typeId)) {
            this.mTypeSpec = this.mResTypeSpecs.get(typeId);
        } else {
            this.mTypeSpec = new ResTypeSpec(this.mTypeNames.getString(typeId - 1), typeId);
            this.addTypeSpec(this.mTypeSpec);
            this.mPkg.addType(this.mTypeSpec);
        }
        this.mResId = 0xFF000000 & this.mResId | this.mTypeSpec.getId() << 16;
        byte typeFlags = this.mIn.readByte();
        this.mIn.skipBytes(2);
        int entryCount = this.mIn.readInt();
        int entriesStart = this.mIn.readInt();
        ResConfigFlags flags = this.readConfigFlags();
        this.mHeader.checkForUnreadHeader(this.mIn);
        boolean isOffset16 = (typeFlags & 2) != 0;
        boolean bl = isSparse = (typeFlags & 1) != 0;
        if (isSparse && !this.mResTable.isMainPkgLoaded()) {
            this.mResTable.setSparseResources(true);
        }
        LinkedHashMap<Integer, Integer> entryOffsetMap = new LinkedHashMap<Integer, Integer>();
        for (int i = 0; i < entryCount; ++i) {
            if (isSparse) {
                entryOffsetMap.put(this.mIn.readUnsignedShort(), this.mIn.readUnsignedShort());
                continue;
            }
            if (isOffset16) {
                entryOffsetMap.put(i, this.mIn.readUnsignedShort());
                continue;
            }
            entryOffsetMap.put(i, this.mIn.readInt());
        }
        if (flags.isInvalid) {
            String resName = this.mTypeSpec.getName() + flags.getQualifiers();
            if (this.mKeepBroken) {
                LOGGER.warning("Invalid config flags detected: " + resName);
            } else {
                LOGGER.warning("Invalid config flags detected. Dropping resources: " + resName);
            }
        }
        this.mType = flags.isInvalid && !this.mKeepBroken ? null : this.mPkg.getOrCreateConfig(flags);
        int noEntry = isOffset16 ? 65535 : -1;
        int entriesStartAligned = this.mHeader.startPosition + entriesStart;
        if (this.mIn.position() < entriesStartAligned) {
            long bytesSkipped = this.mIn.skip(entriesStartAligned - this.mIn.position());
            LOGGER.fine("Skipping: " + bytesSkipped + " byte(s) to align with ResTable_entry start.");
        }
        Iterator bytesSkipped = ((HashMap)entryOffsetMap).keySet().iterator();
        while (bytesSkipped.hasNext()) {
            int i = (Integer)bytesSkipped.next();
            this.mResId = this.mResId & 0xFFFF0000 | i;
            int offset = (Integer)((HashMap)entryOffsetMap).get(i);
            if (offset == noEntry) {
                this.mMissingResSpecMap.put(this.mResId, typeId);
                continue;
            }
            if (this.mIn.position() == this.mHeader.endPosition) {
                int remainingEntries = entryCount - i;
                LOGGER.warning(String.format("End of chunk hit. Skipping remaining entries (%d) in type: %s", remainingEntries, this.mTypeSpec.getName()));
                break;
            }
            EntryData entryData = this.readEntryData();
            if (entryData != null) {
                this.readEntry(entryData);
                continue;
            }
            this.mMissingResSpecMap.put(this.mResId, typeId);
        }
        if (this.mIn.position() < this.mHeader.endPosition) {
            long bytesSkipped2 = this.mIn.skip(this.mHeader.endPosition - this.mIn.position());
            LOGGER.warning("Unknown data detected. Skipping: " + bytesSkipped2 + " byte(s)");
        }
        return this.mType;
    }

    private EntryData readEntryData() throws IOException, AndrolibException {
        ResValue value;
        boolean isCompact;
        short size = this.mIn.readShort();
        short flags = this.mIn.readShort();
        boolean isComplex = (flags & 1) != 0;
        boolean bl = isCompact = (flags & 8) != 0;
        if (size < 0 && !isCompact) {
            throw new AndrolibException("Entry size is under 0 bytes and not compactly packed.");
        }
        int specNamesId = this.mIn.readInt();
        if (specNamesId == -1 && !isCompact) {
            return null;
        }
        if (isCompact) {
            byte type = (byte)(flags >> 8 & 0xFF);
            value = this.readCompactValue(type, specNamesId);
            specNamesId = size;
        } else {
            value = isComplex ? this.readComplexEntry() : this.readValue();
        }
        if (value == null) {
            return null;
        }
        EntryData entryData = new EntryData();
        entryData.mFlags = flags;
        entryData.mSpecNamesId = specNamesId;
        entryData.mValue = value;
        return entryData;
    }

    private void readEntry(EntryData entryData) throws AndrolibException {
        ResResSpec spec;
        int specNamesId = entryData.mSpecNamesId;
        ResValue value = entryData.mValue;
        if (this.mTypeSpec.isString() && value instanceof ResFileValue) {
            value = new ResStringValue(value.toString(), ((ResFileValue)value).getRawIntValue());
        }
        if (this.mType == null) {
            return;
        }
        ResID resId = new ResID(this.mResId);
        if (this.mPkg.hasResSpec(resId)) {
            spec = this.mPkg.getResSpec(resId);
        } else {
            spec = new ResResSpec(resId, this.mSpecNames.getString(specNamesId), this.mPkg, this.mTypeSpec);
            this.mPkg.addResSpec(spec);
            this.mTypeSpec.addResSpec(spec);
        }
        ResResource res = new ResResource(this.mType, spec, value);
        try {
            this.mType.addResource(res);
            spec.addResource(res);
        }
        catch (AndrolibException ex) {
            if (this.mKeepBroken) {
                this.mType.addResource(res, true);
                spec.addResource(res, true);
                LOGGER.warning(String.format("Duplicate Resource Detected. Ignoring duplicate: %s", res));
            }
            throw ex;
        }
    }

    private ResBagValue readComplexEntry() throws IOException, AndrolibException {
        int parent = this.mIn.readInt();
        int count = this.mIn.readInt();
        ResValueFactory factory = this.mPkg.getValueFactory();
        Duo[] items = new Duo[count];
        for (int i = 0; i < count; ++i) {
            int resId = this.mIn.readInt();
            ResIntBasedValue resValue = this.readValue();
            if (resValue == null) continue;
            if (!(resValue instanceof ResScalarValue)) {
                resValue = new ResStringValue(resValue.toString(), resValue.getRawIntValue());
            }
            items[i] = new Duo<Integer, ResScalarValue>(resId, (ResScalarValue)resValue);
        }
        return factory.bagFactory(parent, items, this.mTypeSpec);
    }

    private ResIntBasedValue readCompactValue(byte type, int data) throws AndrolibException {
        return type == 3 ? this.mPkg.getValueFactory().factory(this.mTableStrings.getHTML(data), data) : this.mPkg.getValueFactory().factory(type, data, null);
    }

    private ResIntBasedValue readValue() throws IOException, AndrolibException {
        short size = this.mIn.readShort();
        if (size < 8) {
            return null;
        }
        this.mIn.skipCheckByte((byte)0);
        byte type = this.mIn.readByte();
        int data = this.mIn.readInt();
        return type == 3 ? this.mPkg.getValueFactory().factory(this.mTableStrings.getHTML(data), data) : this.mPkg.getValueFactory().factory(type, data, null);
    }

    private ResConfigFlags readConfigFlags() throws IOException, AndrolibException {
        int remainingSize;
        int exceedingKnownSize;
        int size = this.mIn.readInt();
        int read = 8;
        if (size < 8) {
            throw new AndrolibException("Config size < 8");
        }
        boolean isInvalid = false;
        short mcc = this.mIn.readShort();
        short mnc = this.mIn.readShort();
        char[] language = new char[]{};
        char[] country = new char[]{};
        if (size >= 12) {
            language = this.unpackLanguageOrRegion(this.mIn.readByte(), this.mIn.readByte(), 'a');
            country = this.unpackLanguageOrRegion(this.mIn.readByte(), this.mIn.readByte(), '0');
            read = 12;
        }
        byte orientation = 0;
        byte touchscreen = 0;
        if (size >= 14) {
            orientation = this.mIn.readByte();
            touchscreen = this.mIn.readByte();
            read = 14;
        }
        int density = 0;
        if (size >= 16) {
            density = this.mIn.readUnsignedShort();
            read = 16;
        }
        byte keyboard = 0;
        byte navigation = 0;
        byte inputFlags = 0;
        byte grammaticalInflection = 0;
        if (size >= 20) {
            keyboard = this.mIn.readByte();
            navigation = this.mIn.readByte();
            inputFlags = this.mIn.readByte();
            grammaticalInflection = this.mIn.readByte();
            read = 20;
        }
        short screenWidth = 0;
        short screenHeight = 0;
        short sdkVersion = 0;
        if (size >= 28) {
            screenWidth = this.mIn.readShort();
            screenHeight = this.mIn.readShort();
            sdkVersion = this.mIn.readShort();
            this.mIn.skipBytes(2);
            read = 28;
        }
        byte screenLayout = 0;
        byte uiMode = 0;
        short smallestScreenWidthDp = 0;
        if (size >= 32) {
            screenLayout = this.mIn.readByte();
            uiMode = this.mIn.readByte();
            smallestScreenWidthDp = this.mIn.readShort();
            read = 32;
        }
        short screenWidthDp = 0;
        short screenHeightDp = 0;
        if (size >= 36) {
            screenWidthDp = this.mIn.readShort();
            screenHeightDp = this.mIn.readShort();
            read = 36;
        }
        char[] localeScript = null;
        char[] localeVariant = null;
        if (size >= 48) {
            localeScript = this.readVariantLengthString(4).toCharArray();
            localeVariant = this.readVariantLengthString(8).toCharArray();
            read = 48;
        }
        byte screenLayout2 = 0;
        byte colorMode = 0;
        if (size >= 52) {
            screenLayout2 = this.mIn.readByte();
            colorMode = this.mIn.readByte();
            this.mIn.skipBytes(2);
            read = 52;
        }
        char[] localeNumberingSystem = null;
        if (size >= 60) {
            localeNumberingSystem = this.readVariantLengthString(8).toCharArray();
            read = 60;
        }
        if ((exceedingKnownSize = size - 64) > 0) {
            byte[] buf = new byte[exceedingKnownSize];
            read += exceedingKnownSize;
            this.mIn.readFully(buf);
            BigInteger exceedingBI = new BigInteger(1, buf);
            if (exceedingBI.equals(BigInteger.ZERO)) {
                LOGGER.fine(String.format("Config flags size > %d, but exceeding bytes are all zero, so it should be ok.", 64));
            } else {
                LOGGER.warning(String.format("Config flags size > %d. Size = %d. Exceeding bytes: 0x%X.", 64, size, exceedingBI));
                isInvalid = true;
            }
        }
        if ((remainingSize = size - read) > 0) {
            this.mIn.skipBytes(remainingSize);
        }
        return new ResConfigFlags(mcc, mnc, language, country, orientation, touchscreen, density, keyboard, navigation, inputFlags, grammaticalInflection, screenWidth, screenHeight, sdkVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, localeScript, localeVariant, screenLayout2, colorMode, localeNumberingSystem, isInvalid, size);
    }

    private char[] unpackLanguageOrRegion(byte in0, byte in1, char base) {
        if ((in0 >> 7 & 1) == 1) {
            int first = in1 & 0x1F;
            int second = ((in1 & 0xE0) >> 5) + ((in0 & 3) << 3);
            int third = (in0 & 0x7C) >> 2;
            return new char[]{(char)(first + base), (char)(second + base), (char)(third + base)};
        }
        return new char[]{(char)in0, (char)in1};
    }

    private String readVariantLengthString(int maxLength) throws IOException {
        short ch;
        StringBuilder string = new StringBuilder(16);
        while (maxLength-- != 0 && (ch = (short)this.mIn.readByte()) != 0) {
            string.append((char)ch);
        }
        this.mIn.skipBytes(maxLength);
        return string.toString();
    }

    private void addTypeSpec(ResTypeSpec resTypeSpec) {
        this.mResTypeSpecs.put(resTypeSpec.getId(), resTypeSpec);
    }

    private void addMissingResSpecs() throws AndrolibException {
        for (int resId : this.mMissingResSpecMap.keySet()) {
            int typeId = this.mMissingResSpecMap.get(resId);
            String resName = "APKTOOL_DUMMY_" + Integer.toHexString(resId);
            ResID id = new ResID(resId);
            ResResSpec spec = new ResResSpec(id, resName, this.mPkg, this.mResTypeSpecs.get(typeId));
            if (this.mPkg.hasResSpec(id)) continue;
            this.mPkg.addResSpec(spec);
            spec.getType().addResSpec(spec);
            ResType resType = this.mPkg.getOrCreateConfig(new ResConfigFlags());
            ResReferenceValue value = new ResReferenceValue(this.mPkg, 0, "");
            ResResource res = new ResResource(resType, spec, value);
            resType.addResource(res);
            spec.addResource(res);
        }
    }

    private ARSCHeader nextChunk() throws IOException {
        this.mHeader = ARSCHeader.read(this.mIn);
        return this.mHeader;
    }

    private void checkChunkType(int expectedType) throws AndrolibException {
        if (this.mHeader.type != expectedType) {
            throw new AndrolibException(String.format("Invalid chunk type: expected=0x%08x, got=0x%08x", expectedType, this.mHeader.type));
        }
    }
}

