/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.res;

import brut.androlib.Config;
import brut.androlib.apk.ApkInfo;
import brut.androlib.exceptions.AndrolibException;
import brut.androlib.res.data.ResPackage;
import brut.androlib.res.data.ResResSpec;
import brut.androlib.res.data.ResResource;
import brut.androlib.res.data.ResTable;
import brut.androlib.res.data.ResValuesFile;
import brut.androlib.res.decoder.AXmlResourceParser;
import brut.androlib.res.decoder.AndroidManifestResourceParser;
import brut.androlib.res.decoder.Res9patchStreamDecoder;
import brut.androlib.res.decoder.ResFileDecoder;
import brut.androlib.res.decoder.ResRawStreamDecoder;
import brut.androlib.res.decoder.ResStreamDecoderContainer;
import brut.androlib.res.decoder.XmlPullStreamDecoder;
import brut.androlib.res.util.ExtMXSerializer;
import brut.androlib.res.util.ExtXmlSerializer;
import brut.androlib.res.xml.ResValuesXmlSerializable;
import brut.androlib.res.xml.ResXmlPatcher;
import brut.directory.Directory;
import brut.directory.DirectoryException;
import brut.directory.FileDirectory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.xmlpull.v1.XmlSerializer;

public class ResourcesDecoder {
    private static final Logger LOGGER = Logger.getLogger(ResourcesDecoder.class.getName());
    private final Config mConfig;
    private final ApkInfo mApkInfo;
    private final ResTable mResTable;
    private final Map<String, String> mResFileMapping = new HashMap<String, String>();
    private static final String[] IGNORED_PACKAGES = new String[]{"android", "com.htc", "com.lge", "com.lge.internal", "yi", "flyme", "air.com.adobe.appentry", "FFFFFFFFFFFFFFFFFFFFFF"};

    public ResourcesDecoder(Config config, ApkInfo apkInfo) {
        this.mConfig = config;
        this.mApkInfo = apkInfo;
        this.mResTable = new ResTable(this.mConfig, this.mApkInfo);
    }

    public Map<String, String> getResFileMapping() {
        return this.mResFileMapping;
    }

    public void decodeManifest(File outDir) throws AndrolibException {
        if (!this.mApkInfo.hasManifest()) {
            return;
        }
        AndroidManifestResourceParser axmlParser = new AndroidManifestResourceParser(this.mResTable);
        XmlPullStreamDecoder fileDecoder = new XmlPullStreamDecoder(axmlParser, this.getResXmlSerializer());
        try {
            Directory inApk = this.mApkInfo.getApkFile().getDirectory();
            FileDirectory out = new FileDirectory(outDir);
            if (this.mApkInfo.hasResources()) {
                LOGGER.info("Decoding AndroidManifest.xml with resources...");
            } else {
                LOGGER.info("Decoding AndroidManifest.xml with only framework resources...");
            }
            InputStream inputStream = inApk.getFileInput("AndroidManifest.xml");
            OutputStream outputStream = out.getFileOutput("AndroidManifest.xml");
            fileDecoder.decodeManifest(inputStream, outputStream);
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        if (this.mApkInfo.hasResources() && !this.mConfig.analysisMode) {
            this.adjustPackageManifest(outDir.getAbsolutePath() + File.separator + "AndroidManifest.xml");
            ResXmlPatcher.removeManifestVersions(new File(outDir.getAbsolutePath() + File.separator + "AndroidManifest.xml"));
            this.mApkInfo.packageInfo.forcedPackageId = String.valueOf(this.mResTable.getPackageId());
        }
    }

    public void updateApkInfo(File outDir) throws AndrolibException {
        this.mResTable.initApkInfo(this.mApkInfo, outDir);
    }

    private void adjustPackageManifest(String filePath) throws AndrolibException {
        ResPackage resPackage = this.mResTable.getCurrentResPackage();
        String pkgOriginal = resPackage.getName();
        String pkgRenamed = this.mResTable.getPackageRenamed();
        this.mResTable.setPackageId(resPackage.getId());
        this.mResTable.setPackageOriginal(pkgOriginal);
        if (pkgOriginal == null || pkgRenamed == null || pkgOriginal.equalsIgnoreCase(pkgRenamed) || Arrays.asList(IGNORED_PACKAGES).contains(pkgOriginal)) {
            LOGGER.info("Regular manifest package...");
        } else {
            LOGGER.info("Renamed manifest package found! Replacing " + pkgRenamed + " with " + pkgOriginal);
            ResXmlPatcher.renameManifestPackage(new File(filePath), pkgOriginal);
        }
    }

    public void decodeResources(File outDir) throws AndrolibException {
        Directory outRes;
        Directory in;
        if (!this.mApkInfo.hasResources()) {
            return;
        }
        this.mResTable.loadMainPkg(this.mApkInfo.getApkFile());
        ResStreamDecoderContainer decoders = new ResStreamDecoderContainer();
        decoders.setDecoder("raw", new ResRawStreamDecoder());
        decoders.setDecoder("9patch", new Res9patchStreamDecoder());
        AXmlResourceParser axmlParser = new AXmlResourceParser(this.mResTable);
        decoders.setDecoder("xml", new XmlPullStreamDecoder(axmlParser, this.getResXmlSerializer()));
        ResFileDecoder fileDecoder = new ResFileDecoder(decoders);
        try {
            FileDirectory out = new FileDirectory(outDir);
            in = this.mApkInfo.getApkFile().getDirectory();
            outRes = out.createDir("res");
        }
        catch (DirectoryException ex) {
            throw new AndrolibException(ex);
        }
        ExtMXSerializer xmlSerializer = this.getResXmlSerializer();
        for (ResPackage pkg : this.mResTable.listMainPackages()) {
            LOGGER.info("Decoding file-resources...");
            for (ResResource res : pkg.listFiles()) {
                fileDecoder.decode(res, in, outRes, this.mResFileMapping);
            }
            LOGGER.info("Decoding values */* XMLs...");
            for (ResValuesFile valuesFile : pkg.listValuesFiles()) {
                this.generateValuesFile(valuesFile, outRes, xmlSerializer);
            }
            this.generatePublicXml(pkg, outRes, xmlSerializer);
        }
        AndrolibException decodeError = axmlParser.getFirstError();
        if (decodeError != null) {
            throw decodeError;
        }
    }

    private ExtMXSerializer getResXmlSerializer() {
        ExtMXSerializer serial = new ExtMXSerializer();
        serial.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "    ");
        serial.setProperty("http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", System.getProperty("line.separator"));
        serial.setProperty("DEFAULT_ENCODING", "utf-8");
        serial.setDisabledAttrEscape(true);
        return serial;
    }

    private void generateValuesFile(ResValuesFile valuesFile, Directory out, ExtXmlSerializer serial) throws AndrolibException {
        try {
            OutputStream outStream = out.getFileOutput(valuesFile.getPath());
            serial.setOutput(outStream, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResResource res : valuesFile.listResources()) {
                if (valuesFile.isSynthesized(res)) continue;
                ((ResValuesXmlSerializable)((Object)res.getValue())).serializeToResValuesXml(serial, res);
            }
            serial.endTag(null, "resources");
            serial.newLine();
            serial.endDocument();
            serial.flush();
            outStream.close();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate: " + valuesFile.getPath(), ex);
        }
    }

    private void generatePublicXml(ResPackage pkg, Directory out, XmlSerializer serial) throws AndrolibException {
        try {
            OutputStream outStream = out.getFileOutput("values/public.xml");
            serial.setOutput(outStream, null);
            serial.startDocument(null, null);
            serial.startTag(null, "resources");
            for (ResResSpec spec : pkg.listResSpecs()) {
                serial.startTag(null, "public");
                serial.attribute(null, "type", spec.getType().getName());
                serial.attribute(null, "name", spec.getName());
                serial.attribute(null, "id", String.format("0x%08x", spec.getId().id));
                serial.endTag(null, "public");
            }
            serial.endTag(null, "resources");
            serial.endDocument();
            serial.flush();
            outStream.close();
        }
        catch (DirectoryException | IOException ex) {
            throw new AndrolibException("Could not generate public.xml file", ex);
        }
    }
}

