/*
 * Decompiled with CFR 0.152.
 */
package sun.util.calendar;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.CRC32;
import sun.security.action.GetPropertyAction;
import sun.util.calendar.ZoneInfo;

public final class ZoneInfoFile {
    private static String versionId;
    private static final Map<String, ZoneInfo> zones;
    private static Map<String, String> aliases;
    private static byte[][] ruleArray;
    private static String[] regions;
    private static int[] indices;
    private static final boolean USE_OLDMAPPING;
    private static String[][] oldMappings;
    private static final long UTC1900 = -2208988800L;
    private static final long UTC2037 = 2145916799L;
    private static final long LDT2037 = 2114380800L;
    private static final long CURRT;
    static final int SECONDS_PER_DAY = 86400;
    static final int DAYS_PER_CYCLE = 146097;
    static final long DAYS_0000_TO_1970 = 719528L;
    private static final int[] toCalendarDOW;
    private static final int[] toSTZTime;
    private static final long OFFSET_MASK = 15L;
    private static final long DST_MASK = 240L;
    private static final int DST_NSHIFT = 4;
    private static final int TRANSITION_NSHIFT = 12;
    private static final int LASTYEAR = 2037;

    public static String[] getZoneIds() {
        int n = regions.length + oldMappings.length;
        if (!USE_OLDMAPPING) {
            n += 3;
        }
        String[] stringArray = Arrays.copyOf(regions, n);
        int n2 = regions.length;
        if (!USE_OLDMAPPING) {
            stringArray[n2++] = "EST";
            stringArray[n2++] = "HST";
            stringArray[n2++] = "MST";
        }
        for (int i = 0; i < oldMappings.length; ++i) {
            stringArray[n2++] = oldMappings[i][0];
        }
        return stringArray;
    }

    public static String[] getZoneIds(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : ZoneInfoFile.getZoneIds()) {
            ZoneInfo zoneInfo = ZoneInfoFile.getZoneInfo(string);
            if (zoneInfo.getRawOffset() != n) continue;
            arrayList.add(string);
        }
        Object[] objectArray = arrayList.toArray(new String[arrayList.size()]);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static ZoneInfo getZoneInfo(String string) {
        if (string == null) {
            return null;
        }
        ZoneInfo zoneInfo = ZoneInfoFile.getZoneInfo0(string);
        if (zoneInfo != null) {
            zoneInfo = (ZoneInfo)zoneInfo.clone();
            zoneInfo.setID(string);
        }
        return zoneInfo;
    }

    private static ZoneInfo getZoneInfo0(String string) {
        try {
            int n;
            ZoneInfo zoneInfo = zones.get(string);
            if (zoneInfo != null) {
                return zoneInfo;
            }
            String string2 = string;
            if (aliases.containsKey(string)) {
                string2 = aliases.get(string);
            }
            if ((n = Arrays.binarySearch(regions, string2)) < 0) {
                return null;
            }
            byte[] byArray = ruleArray[indices[n]];
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            zoneInfo = ZoneInfoFile.getZoneInfo(dataInputStream, string2);
            zones.put(string, zoneInfo);
            return zoneInfo;
        }
        catch (Exception exception) {
            throw new RuntimeException("Invalid binary time-zone data: TZDB:" + string + ", version: " + versionId, exception);
        }
    }

    public static Map<String, String> getAliasMap() {
        return Collections.unmodifiableMap(aliases);
    }

    public static String getVersion() {
        return versionId;
    }

    public static ZoneInfo getCustomTimeZone(String string, int n) {
        String string2 = ZoneInfoFile.toCustomID(n);
        return new ZoneInfo(string2, n);
    }

    public static String toCustomID(int n) {
        char c;
        int n2 = n / 60000;
        if (n2 >= 0) {
            c = '+';
        } else {
            c = '-';
            n2 = -n2;
        }
        int n3 = n2 / 60;
        int n4 = n2 % 60;
        char[] cArray = new char[]{'G', 'M', 'T', c, '0', '0', ':', '0', '0'};
        if (n3 >= 10) {
            cArray[4] = (char)(cArray[4] + n3 / 10);
        }
        cArray[5] = (char)(cArray[5] + n3 % 10);
        if (n4 != 0) {
            cArray[7] = (char)(cArray[7] + n4 / 10);
            cArray[8] = (char)(cArray[8] + n4 % 10);
        }
        return new String(cArray);
    }

    private ZoneInfoFile() {
    }

    private static void addOldMapping() {
        for (String[] stringArray : oldMappings) {
            aliases.put(stringArray[0], stringArray[1]);
        }
        if (USE_OLDMAPPING) {
            aliases.put("EST", "America/New_York");
            aliases.put("MST", "America/Denver");
            aliases.put("HST", "Pacific/Honolulu");
        } else {
            zones.put("EST", new ZoneInfo("EST", -18000000));
            zones.put("MST", new ZoneInfo("MST", -25200000));
            zones.put("HST", new ZoneInfo("HST", -36000000));
        }
    }

    public static boolean useOldMapping() {
        return USE_OLDMAPPING;
    }

    private static void load(DataInputStream dataInputStream) throws ClassNotFoundException, IOException {
        int n;
        int n2;
        int n3;
        if (dataInputStream.readByte() != 1) {
            throw new StreamCorruptedException("File format not recognised");
        }
        String string = dataInputStream.readUTF();
        if (!"TZDB".equals(string)) {
            throw new StreamCorruptedException("File format not recognised");
        }
        int n4 = dataInputStream.readShort();
        for (n3 = 0; n3 < n4; ++n3) {
            versionId = dataInputStream.readUTF();
        }
        n3 = dataInputStream.readShort();
        String[] stringArray = new String[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            stringArray[n2] = dataInputStream.readUTF();
        }
        n2 = dataInputStream.readShort();
        ruleArray = new byte[n2][];
        for (n = 0; n < n2; ++n) {
            byte[] byArray = new byte[dataInputStream.readShort()];
            dataInputStream.readFully(byArray);
            ZoneInfoFile.ruleArray[n] = byArray;
        }
        for (n = 0; n < n4; ++n) {
            n3 = dataInputStream.readShort();
            regions = new String[n3];
            indices = new int[n3];
            for (int i = 0; i < n3; ++i) {
                ZoneInfoFile.regions[i] = stringArray[dataInputStream.readShort()];
                ZoneInfoFile.indices[i] = dataInputStream.readShort();
            }
        }
        zones.remove("ROC");
        for (n = 0; n < n4; ++n) {
            int n5 = dataInputStream.readShort();
            aliases.clear();
            for (int i = 0; i < n5; ++i) {
                String string2 = stringArray[dataInputStream.readShort()];
                String string3 = stringArray[dataInputStream.readShort()];
                aliases.put(string2, string3);
            }
        }
        ZoneInfoFile.addOldMapping();
    }

    public static ZoneInfo getZoneInfo(DataInput dataInput, String string) throws Exception {
        int n;
        int n2;
        byte by = dataInput.readByte();
        int n3 = dataInput.readInt();
        long[] lArray = new long[n3];
        for (int i = 0; i < n3; ++i) {
            lArray[i] = ZoneInfoFile.readEpochSec(dataInput);
        }
        int[] nArray = new int[n3 + 1];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            nArray[n2] = ZoneInfoFile.readOffset(dataInput);
        }
        n2 = dataInput.readInt();
        long[] lArray2 = new long[n2];
        for (int i = 0; i < n2; ++i) {
            lArray2[i] = ZoneInfoFile.readEpochSec(dataInput);
        }
        int[] nArray2 = new int[n2 + 1];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = ZoneInfoFile.readOffset(dataInput);
        }
        n = dataInput.readByte();
        ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray = new ZoneOffsetTransitionRule[n];
        for (int i = 0; i < n; ++i) {
            zoneOffsetTransitionRuleArray[i] = new ZoneOffsetTransitionRule(dataInput);
        }
        return ZoneInfoFile.getZoneInfo(string, lArray, nArray, lArray2, nArray2, zoneOffsetTransitionRuleArray);
    }

    public static int readOffset(DataInput dataInput) throws IOException {
        byte by = dataInput.readByte();
        return by == 127 ? dataInput.readInt() : by * 900;
    }

    static long readEpochSec(DataInput dataInput) throws IOException {
        int n = dataInput.readByte() & 0xFF;
        if (n == 255) {
            return dataInput.readLong();
        }
        int n2 = dataInput.readByte() & 0xFF;
        int n3 = dataInput.readByte() & 0xFF;
        long l = (n << 16) + (n2 << 8) + n3;
        return l * 900L - 4575744000L;
    }

    private static ZoneInfo getZoneInfo(String string, long[] lArray, int[] nArray, long[] lArray2, int[] nArray2, ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int[] nArray3 = null;
        boolean bl = false;
        if (lArray.length > 0) {
            n = nArray[nArray.length - 1] * 1000;
            bl = lArray[lArray.length - 1] > CURRT;
        } else {
            n = nArray[0] * 1000;
        }
        Object object = null;
        Object object2 = null;
        int n4 = 0;
        int n5 = 0;
        if (lArray2.length != 0) {
            int n6;
            long l;
            int n7;
            object = new long[250];
            object2 = new int[100];
            int n8 = ZoneInfoFile.getYear(lArray2[lArray2.length - 1], nArray2[lArray2.length - 1]);
            int n9 = 1;
            for (n7 = 0; n7 < lArray2.length && lArray2[n7] < -2208988800L; ++n7) {
            }
            if (n7 < lArray2.length) {
                if (n7 < lArray2.length) {
                    object2[0] = nArray[nArray.length - 1] * 1000;
                    n4 = 1;
                }
                n4 = ZoneInfoFile.addTrans(object, n5++, object2, n4, -2208988800L, nArray2[n7], ZoneInfoFile.getStandardOffset(lArray, nArray, -2208988800L));
            }
            while (n7 < lArray2.length) {
                l = lArray2[n7];
                if (l > 2145916799L) {
                    n8 = 2037;
                    break;
                }
                while (n9 < lArray.length) {
                    long l2 = lArray[n9];
                    if (l2 >= -2208988800L) {
                        if (l2 > l) break;
                        if (l2 < l) {
                            if (n4 + 2 >= ((int[])object2).length) {
                                object2 = Arrays.copyOf(object2, ((int[])object2).length + 100);
                            }
                            if (n5 + 1 >= ((long[])object).length) {
                                object = Arrays.copyOf(object, ((long[])object).length + 100);
                            }
                            n4 = ZoneInfoFile.addTrans(object, n5++, object2, n4, l2, nArray2[n7], nArray[n9 + 1]);
                        }
                    }
                    ++n9;
                }
                if (n4 + 2 >= ((int[])object2).length) {
                    object2 = Arrays.copyOf(object2, ((int[])object2).length + 100);
                }
                if (n5 + 1 >= ((long[])object).length) {
                    object = Arrays.copyOf(object, ((long[])object).length + 100);
                }
                n4 = ZoneInfoFile.addTrans(object, n5++, object2, n4, l, nArray2[n7 + 1], ZoneInfoFile.getStandardOffset(lArray, nArray, l));
                ++n7;
            }
            while (n9 < lArray.length) {
                l = lArray[n9];
                if (l >= -2208988800L) {
                    int n10 = nArray2[n7];
                    n6 = ZoneInfoFile.indexOf(object2, 0, n4, n10);
                    if (n6 == n4) {
                        ++n4;
                    }
                    object[n5++] = l * 1000L << 12 | (long)n6 & 0xFL;
                }
                ++n9;
            }
            if (zoneOffsetTransitionRuleArray.length > 1) {
                while (n8++ < 2037) {
                    for (ZoneOffsetTransitionRule zoneOffsetTransitionRule : zoneOffsetTransitionRuleArray) {
                        long l3 = zoneOffsetTransitionRule.getTransitionEpochSecond(n8);
                        if (n4 + 2 >= ((int[])object2).length) {
                            object2 = Arrays.copyOf(object2, ((int[])object2).length + 100);
                        }
                        if (n5 + 1 >= ((long[])object).length) {
                            object = Arrays.copyOf(object, ((long[])object).length + 100);
                        }
                        n4 = ZoneInfoFile.addTrans(object, n5++, object2, n4, l3, zoneOffsetTransitionRule.offsetAfter, zoneOffsetTransitionRule.standardOffset);
                    }
                }
                ZoneOffsetTransitionRule zoneOffsetTransitionRule = zoneOffsetTransitionRuleArray[zoneOffsetTransitionRuleArray.length - 2];
                ZoneOffsetTransitionRule zoneOffsetTransitionRule2 = zoneOffsetTransitionRuleArray[zoneOffsetTransitionRuleArray.length - 1];
                nArray3 = new int[10];
                if (zoneOffsetTransitionRule.offsetAfter - zoneOffsetTransitionRule.offsetBefore < 0 && zoneOffsetTransitionRule2.offsetAfter - zoneOffsetTransitionRule2.offsetBefore > 0) {
                    ZoneOffsetTransitionRule zoneOffsetTransitionRule3 = zoneOffsetTransitionRule;
                    zoneOffsetTransitionRule = zoneOffsetTransitionRule2;
                    zoneOffsetTransitionRule2 = zoneOffsetTransitionRule3;
                }
                nArray3[0] = zoneOffsetTransitionRule.month - 1;
                byte by = zoneOffsetTransitionRule.dom;
                n6 = zoneOffsetTransitionRule.dow;
                if (n6 == -1) {
                    nArray3[1] = by;
                    nArray3[2] = 0;
                } else if (by < 0 || by >= 24) {
                    nArray3[1] = -1;
                    nArray3[2] = toCalendarDOW[n6];
                } else {
                    nArray3[1] = by;
                    nArray3[2] = -toCalendarDOW[n6];
                }
                nArray3[3] = zoneOffsetTransitionRule.secondOfDay * 1000;
                nArray3[4] = toSTZTime[zoneOffsetTransitionRule.timeDefinition];
                nArray3[5] = zoneOffsetTransitionRule2.month - 1;
                by = zoneOffsetTransitionRule2.dom;
                n6 = zoneOffsetTransitionRule2.dow;
                if (n6 == -1) {
                    nArray3[6] = by;
                    nArray3[7] = 0;
                } else if (by < 0 || by >= 24) {
                    nArray3[6] = -1;
                    nArray3[7] = toCalendarDOW[n6];
                } else {
                    nArray3[6] = by;
                    nArray3[7] = -toCalendarDOW[n6];
                }
                nArray3[8] = zoneOffsetTransitionRule2.secondOfDay * 1000;
                nArray3[9] = toSTZTime[zoneOffsetTransitionRule2.timeDefinition];
                n2 = (zoneOffsetTransitionRule.offsetAfter - zoneOffsetTransitionRule.offsetBefore) * 1000;
                if (string.equals("Africa/Cairo") && nArray3[7] == 6 && nArray3[8] == 0) {
                    nArray3[7] = 5;
                    nArray3[8] = 86400000;
                }
            } else if (n5 > 0) {
                if (n8 < 2037) {
                    l = 2114380800L - (long)(n / 1000);
                    int n11 = ZoneInfoFile.indexOf(object2, 0, n4, n / 1000);
                    if (n11 == n4) {
                        ++n4;
                    }
                    object[n5++] = l * 1000L << 12 | (long)n11 & 0xFL;
                } else if (lArray2.length > 2) {
                    int n12 = lArray2.length;
                    long l4 = lArray2[n12 - 2];
                    n6 = nArray2[n12 - 2 + 1];
                    int n13 = ZoneInfoFile.getStandardOffset(lArray, nArray, l4);
                    long l5 = lArray2[n12 - 1];
                    int n14 = nArray2[n12 - 1 + 1];
                    int n15 = ZoneInfoFile.getStandardOffset(lArray, nArray, l5);
                    if (n6 > n13 && n14 == n15) {
                        n12 = lArray2.length - 2;
                        ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(nArray2[n12]);
                        ZoneOffset zoneOffset2 = ZoneOffset.ofTotalSeconds(nArray2[n12 + 1]);
                        LocalDateTime localDateTime = LocalDateTime.ofEpochSecond(lArray2[n12], 0, zoneOffset);
                        LocalDateTime localDateTime2 = zoneOffset2.getTotalSeconds() > zoneOffset.getTotalSeconds() ? localDateTime : localDateTime.plusSeconds(nArray2[n12 + 1] - nArray2[n12]);
                        n12 = lArray2.length - 1;
                        zoneOffset = ZoneOffset.ofTotalSeconds(nArray2[n12]);
                        zoneOffset2 = ZoneOffset.ofTotalSeconds(nArray2[n12 + 1]);
                        localDateTime = LocalDateTime.ofEpochSecond(lArray2[n12], 0, zoneOffset);
                        LocalDateTime localDateTime3 = zoneOffset2.getTotalSeconds() > zoneOffset.getTotalSeconds() ? localDateTime.plusSeconds(nArray2[n12 + 1] - nArray2[n12]) : localDateTime;
                        nArray3 = new int[]{localDateTime2.getMonthValue() - 1, localDateTime2.getDayOfMonth(), 0, localDateTime2.toLocalTime().toSecondOfDay() * 1000, 0, localDateTime3.getMonthValue() - 1, localDateTime3.getDayOfMonth(), 0, localDateTime3.toLocalTime().toSecondOfDay() * 1000, 0};
                        n2 = (n6 - n13) * 1000;
                    }
                }
            }
            if (object != null && ((long[])object).length != n5) {
                object = n5 == 0 ? null : Arrays.copyOf(object, n5);
            }
            if (object2 != null && ((int[])object2).length != n4) {
                object2 = n4 == 0 ? null : Arrays.copyOf(object2, n4);
            }
            if (object != null) {
                Checksum checksum = new Checksum();
                for (n7 = 0; n7 < ((long[])object).length; ++n7) {
                    long l6 = object[n7];
                    n6 = (int)(l6 >>> 4 & 0xFL);
                    int n16 = n6 == 0 ? 0 : object2[n6];
                    int n17 = (int)(l6 & 0xFL);
                    int n18 = object2[n17];
                    long l7 = l6 >> 12;
                    checksum.update(l7 + (long)n17);
                    checksum.update(n17);
                    checksum.update(n6 == 0 ? -1 : n6);
                }
                n3 = (int)checksum.getValue();
            }
        }
        return new ZoneInfo(string, n, n2, n3, (long[])object, (int[])object2, nArray3, bl);
    }

    private static int getStandardOffset(long[] lArray, int[] nArray, long l) {
        int n;
        for (n = 0; n < lArray.length && l >= lArray[n]; ++n) {
        }
        return nArray[n];
    }

    private static int getYear(long l, int n) {
        long l2;
        long l3;
        long l4 = l + (long)n;
        long l5 = Math.floorDiv(l4, 86400L);
        long l6 = l5 + 719528L;
        long l7 = 0L;
        if ((l6 -= 60L) < 0L) {
            l3 = (l6 + 1L) / 146097L - 1L;
            l7 = l3 * 400L;
            l6 += -l3 * 146097L;
        }
        if ((l2 = l6 - (365L * (l3 = (400L * l6 + 591L) / 146097L) + l3 / 4L - l3 / 100L + l3 / 400L)) < 0L) {
            l2 = l6 - (365L * --l3 + l3 / 4L - l3 / 100L + l3 / 400L);
        }
        l3 += l7;
        int n2 = (int)l2;
        int n3 = (n2 * 5 + 2) / 153;
        int n4 = (n3 + 2) % 12 + 1;
        int n5 = n2 - (n3 * 306 + 5) / 10 + 1;
        return (int)(l3 += (long)(n3 / 10));
    }

    private static int indexOf(int[] nArray, int n, int n2, int n3) {
        n3 *= 1000;
        while (n < n2) {
            if (nArray[n] == n3) {
                return n;
            }
            ++n;
        }
        nArray[n] = n3;
        return n;
    }

    private static int addTrans(long[] lArray, int n, int[] nArray, int n2, long l, int n3, int n4) {
        int n5 = ZoneInfoFile.indexOf(nArray, 0, n2, n3);
        if (n5 == n2) {
            ++n2;
        }
        int n6 = 0;
        if (n3 != n4 && (n6 = ZoneInfoFile.indexOf(nArray, 1, n2, n3 - n4)) == n2) {
            ++n2;
        }
        lArray[n] = l * 1000L << 12 | (long)(n6 << 4) & 0xF0L | (long)n5 & 0xFL;
        return n2;
    }

    static {
        zones = new ConcurrentHashMap<String, ZoneInfo>();
        aliases = new HashMap<String, String>();
        oldMappings = new String[][]{{"ACT", "Australia/Darwin"}, {"AET", "Australia/Sydney"}, {"AGT", "America/Argentina/Buenos_Aires"}, {"ART", "Africa/Cairo"}, {"AST", "America/Anchorage"}, {"BET", "America/Sao_Paulo"}, {"BST", "Asia/Dhaka"}, {"CAT", "Africa/Harare"}, {"CNT", "America/St_Johns"}, {"CST", "America/Chicago"}, {"CTT", "Asia/Shanghai"}, {"EAT", "Africa/Addis_Ababa"}, {"ECT", "Europe/Paris"}, {"IET", "America/Indiana/Indianapolis"}, {"IST", "Asia/Kolkata"}, {"JST", "Asia/Tokyo"}, {"MIT", "Pacific/Apia"}, {"NET", "Asia/Yerevan"}, {"NST", "Pacific/Auckland"}, {"PLT", "Asia/Karachi"}, {"PNT", "America/Phoenix"}, {"PRT", "America/Puerto_Rico"}, {"PST", "America/Los_Angeles"}, {"SST", "Pacific/Guadalcanal"}, {"VST", "Asia/Ho_Chi_Minh"}};
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.timezone.ids.oldmapping", "false")).toLowerCase(Locale.ROOT);
        USE_OLDMAPPING = string.equals("yes") || string.equals("true");
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    String string = System.getProperty("java.home") + File.separator + "lib";
                    try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(new File(string, "tzdb.dat"))));){
                        ZoneInfoFile.load(dataInputStream);
                    }
                }
                catch (Exception exception) {
                    throw new Error(exception);
                }
                return null;
            }
        });
        CURRT = System.currentTimeMillis() / 1000L;
        toCalendarDOW = new int[]{-1, 2, 3, 4, 5, 6, 7, 1};
        toSTZTime = new int[]{2, 0, 1};
    }

    private static class Checksum
    extends CRC32 {
        private Checksum() {
        }

        @Override
        public void update(int n) {
            byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)n};
            this.update(byArray);
        }

        void update(long l) {
            byte[] byArray = new byte[]{(byte)(l >>> 56), (byte)(l >>> 48), (byte)(l >>> 40), (byte)(l >>> 32), (byte)(l >>> 24), (byte)(l >>> 16), (byte)(l >>> 8), (byte)l};
            this.update(byArray);
        }
    }

    private static class ZoneOffsetTransitionRule {
        private final int month;
        private final byte dom;
        private final int dow;
        private final int secondOfDay;
        private final int timeDefinition;
        private final int standardOffset;
        private final int offsetBefore;
        private final int offsetAfter;

        ZoneOffsetTransitionRule(DataInput dataInput) throws IOException {
            int n = dataInput.readInt();
            int n2 = (n & 0x380000) >>> 19;
            int n3 = (n & 0x7C000) >>> 14;
            int n4 = (n & 0xFF0) >>> 4;
            int n5 = (n & 0xC) >>> 2;
            int n6 = n & 3;
            this.month = n >>> 28;
            this.dom = (byte)(((n & 0xFC00000) >>> 22) - 32);
            this.dow = n2 == 0 ? -1 : n2;
            this.secondOfDay = n3 == 31 ? dataInput.readInt() : n3 * 3600;
            this.timeDefinition = (n & 0x3000) >>> 12;
            this.standardOffset = n4 == 255 ? dataInput.readInt() : (n4 - 128) * 900;
            this.offsetBefore = n5 == 3 ? dataInput.readInt() : this.standardOffset + n5 * 1800;
            this.offsetAfter = n6 == 3 ? dataInput.readInt() : this.standardOffset + n6 * 1800;
        }

        long getTransitionEpochSecond(int n) {
            long l = 0L;
            if (this.dom < 0) {
                l = ZoneOffsetTransitionRule.toEpochDay(n, this.month, ZoneOffsetTransitionRule.lengthOfMonth(n, this.month) + 1 + this.dom);
                if (this.dow != -1) {
                    l = ZoneOffsetTransitionRule.previousOrSame(l, this.dow);
                }
            } else {
                l = ZoneOffsetTransitionRule.toEpochDay(n, this.month, this.dom);
                if (this.dow != -1) {
                    l = ZoneOffsetTransitionRule.nextOrSame(l, this.dow);
                }
            }
            int n2 = 0;
            switch (this.timeDefinition) {
                case 0: {
                    n2 = 0;
                    break;
                }
                case 1: {
                    n2 = -this.offsetBefore;
                    break;
                }
                case 2: {
                    n2 = -this.standardOffset;
                }
            }
            return l * 86400L + (long)this.secondOfDay + (long)n2;
        }

        static final boolean isLeapYear(int n) {
            return (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
        }

        static final int lengthOfMonth(int n, int n2) {
            switch (n2) {
                case 2: {
                    return ZoneOffsetTransitionRule.isLeapYear(n) ? 29 : 28;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    return 30;
                }
            }
            return 31;
        }

        static final long toEpochDay(int n, int n2, int n3) {
            long l = n;
            long l2 = n2;
            long l3 = 0L;
            l3 += 365L * l;
            l3 = l >= 0L ? (l3 += (l + 3L) / 4L - (l + 99L) / 100L + (l + 399L) / 400L) : (l3 -= l / -4L - l / -100L + l / -400L);
            l3 += (367L * l2 - 362L) / 12L;
            l3 += (long)(n3 - 1);
            if (l2 > 2L) {
                --l3;
                if (!ZoneOffsetTransitionRule.isLeapYear(n)) {
                    --l3;
                }
            }
            return l3 - 719528L;
        }

        static final long previousOrSame(long l, int n) {
            return ZoneOffsetTransitionRule.adjust(l, n, 1);
        }

        static final long nextOrSame(long l, int n) {
            return ZoneOffsetTransitionRule.adjust(l, n, 0);
        }

        static final long adjust(long l, int n, int n2) {
            int n3 = (int)Math.floorMod(l + 3L, 7L) + 1;
            if (n2 < 2 && n3 == n) {
                return l;
            }
            if ((n2 & 1) == 0) {
                int n4 = n3 - n;
                return l + (long)(n4 >= 0 ? 7 - n4 : -n4);
            }
            int n5 = n - n3;
            return l - (long)(n5 >= 0 ? 7 - n5 : -n5);
        }
    }
}

