/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.KnownOIDs;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AVA;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.RDN;

public class X500Name
implements GeneralNameInterface,
Principal {
    private String dn;
    private String rfc1779Dn;
    private String rfc2253Dn;
    private String canonicalDn;
    private RDN[] names;
    private X500Principal x500Principal;
    private byte[] encoded;
    private volatile List<RDN> rdnList;
    private volatile List<AVA> allAvaList;
    private static final int[] countryName_data = new int[]{2, 5, 4, 6};
    private static final int[] localityName_data = new int[]{2, 5, 4, 7};
    private static final int[] stateName_data = new int[]{2, 5, 4, 8};
    private static final int[] streetAddress_data = new int[]{2, 5, 4, 9};
    private static final int[] orgName_data = new int[]{2, 5, 4, 10};
    private static final int[] orgUnitName_data = new int[]{2, 5, 4, 11};
    private static final int[] title_data = new int[]{2, 5, 4, 12};
    private static final int[] GIVENNAME_DATA = new int[]{2, 5, 4, 42};
    private static final int[] INITIALS_DATA = new int[]{2, 5, 4, 43};
    private static final int[] GENERATIONQUALIFIER_DATA = new int[]{2, 5, 4, 44};
    private static final int[] DNQUALIFIER_DATA = new int[]{2, 5, 4, 46};
    private static final int[] ipAddress_data = new int[]{1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1};
    private static final int[] DOMAIN_COMPONENT_DATA = new int[]{0, 9, 2342, 19200300, 100, 1, 25};
    private static final int[] userid_data = new int[]{0, 9, 2342, 19200300, 100, 1, 1};
    public static final ObjectIdentifier commonName_oid = ObjectIdentifier.of(KnownOIDs.CommonName);
    public static final ObjectIdentifier SERIALNUMBER_OID = ObjectIdentifier.of(KnownOIDs.SerialNumber);
    public static final ObjectIdentifier countryName_oid = ObjectIdentifier.of(KnownOIDs.CountryName);
    public static final ObjectIdentifier localityName_oid = ObjectIdentifier.of(KnownOIDs.LocalityName);
    public static final ObjectIdentifier orgName_oid = ObjectIdentifier.of(KnownOIDs.OrgName);
    public static final ObjectIdentifier orgUnitName_oid = ObjectIdentifier.of(KnownOIDs.OrgUnitName);
    public static final ObjectIdentifier stateName_oid = ObjectIdentifier.of(KnownOIDs.StateName);
    public static final ObjectIdentifier streetAddress_oid = ObjectIdentifier.of(KnownOIDs.StreetAddress);
    public static final ObjectIdentifier title_oid = ObjectIdentifier.of(KnownOIDs.Title);
    public static final ObjectIdentifier DNQUALIFIER_OID = ObjectIdentifier.of(KnownOIDs.DNQualifier);
    public static final ObjectIdentifier SURNAME_OID = ObjectIdentifier.of(KnownOIDs.Surname);
    public static final ObjectIdentifier GIVENNAME_OID = ObjectIdentifier.of(KnownOIDs.GivenName);
    public static final ObjectIdentifier INITIALS_OID = ObjectIdentifier.of(KnownOIDs.Initials);
    public static final ObjectIdentifier GENERATIONQUALIFIER_OID = ObjectIdentifier.of(KnownOIDs.GenerationQualifier);
    public static final ObjectIdentifier ipAddress_oid = ObjectIdentifier.of(KnownOIDs.SkipIPAddress);
    public static final ObjectIdentifier DOMAIN_COMPONENT_OID = ObjectIdentifier.of(KnownOIDs.UCL_DomainComponent);
    public static final ObjectIdentifier userid_oid = ObjectIdentifier.of(KnownOIDs.UCL_UserID);
    private static final Constructor<X500Principal> principalConstructor;
    private static final Field principalField;

    public X500Name(String string) throws IOException {
        this(string, Collections.emptyMap());
    }

    public X500Name(String string, Map<String, String> map) throws IOException {
        this.parseDN(string, map);
    }

    public X500Name(String string, String string2) throws IOException {
        if (string == null) {
            throw new NullPointerException("Name must not be null");
        }
        if (string2.equalsIgnoreCase("RFC2253")) {
            this.parseRFC2253DN(string);
        } else if (string2.equalsIgnoreCase("DEFAULT")) {
            this.parseDN(string, Collections.emptyMap());
        } else {
            throw new IOException("Unsupported format " + string2);
        }
    }

    public X500Name(String string, String string2, String string3, String string4) throws IOException {
        this.names = new RDN[4];
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(string4));
    }

    public X500Name(String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        this.names = new RDN[6];
        this.names[5] = new RDN(1);
        this.names[5].assertion[0] = new AVA(commonName_oid, new DerValue(string));
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(orgUnitName_oid, new DerValue(string2));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(orgName_oid, new DerValue(string3));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(localityName_oid, new DerValue(string4));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(stateName_oid, new DerValue(string5));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(string6));
    }

    public X500Name(RDN[] rDNArray) throws IOException {
        if (rDNArray == null) {
            this.names = new RDN[0];
        } else {
            this.names = (RDN[])rDNArray.clone();
            for (int i = 0; i < this.names.length; ++i) {
                if (this.names[i] != null) continue;
                throw new IOException("Cannot create an X500Name");
            }
        }
    }

    public X500Name(DerValue derValue) throws IOException {
        this(derValue.toDerInputStream());
    }

    public X500Name(DerInputStream derInputStream) throws IOException {
        this.parseDER(derInputStream);
    }

    public X500Name(byte[] byArray) throws IOException {
        DerInputStream derInputStream = new DerInputStream(byArray);
        this.parseDER(derInputStream);
    }

    public List<RDN> rdns() {
        List<RDN> list = this.rdnList;
        if (list == null) {
            this.rdnList = list = Collections.unmodifiableList(Arrays.asList(this.names));
        }
        return list;
    }

    public int size() {
        return this.names.length;
    }

    public List<AVA> allAvas() {
        List<AVA> list = this.allAvaList;
        if (list == null) {
            list = new ArrayList<AVA>();
            for (int i = 0; i < this.names.length; ++i) {
                list.addAll(this.names[i].avas());
            }
            this.allAvaList = list = Collections.unmodifiableList(list);
        }
        return list;
    }

    public int avaSize() {
        return this.allAvas().size();
    }

    public boolean isEmpty() {
        int n = this.names.length;
        for (int i = 0; i < n; ++i) {
            if (this.names[i].assertion.length == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.getRFC2253CanonicalName().hashCode();
    }

    @Override
    public boolean equals(Object object) {
        Object object2;
        if (this == object) {
            return true;
        }
        if (!(object instanceof X500Name)) {
            return false;
        }
        X500Name x500Name = (X500Name)object;
        if (this.canonicalDn != null && x500Name.canonicalDn != null) {
            return this.canonicalDn.equals(x500Name.canonicalDn);
        }
        int n = this.names.length;
        if (n != x500Name.names.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            object2 = this.names[i];
            RDN rDN = x500Name.names[i];
            if (((RDN)object2).assertion.length == rDN.assertion.length) continue;
            return false;
        }
        String string = this.getRFC2253CanonicalName();
        object2 = x500Name.getRFC2253CanonicalName();
        return string.equals(object2);
    }

    private String getString(DerValue derValue) throws IOException {
        if (derValue == null) {
            return null;
        }
        String string = derValue.getAsString();
        if (string == null) {
            throw new IOException("not a DER string encoding, " + derValue.tag);
        }
        return string;
    }

    @Override
    public int getType() {
        return 4;
    }

    public String getCountry() throws IOException {
        DerValue derValue = this.findAttribute(countryName_oid);
        return this.getString(derValue);
    }

    public String getOrganization() throws IOException {
        DerValue derValue = this.findAttribute(orgName_oid);
        return this.getString(derValue);
    }

    public String getOrganizationalUnit() throws IOException {
        DerValue derValue = this.findAttribute(orgUnitName_oid);
        return this.getString(derValue);
    }

    public String getCommonName() throws IOException {
        DerValue derValue = this.findAttribute(commonName_oid);
        return this.getString(derValue);
    }

    public String getLocality() throws IOException {
        DerValue derValue = this.findAttribute(localityName_oid);
        return this.getString(derValue);
    }

    public String getState() throws IOException {
        DerValue derValue = this.findAttribute(stateName_oid);
        return this.getString(derValue);
    }

    public String getDomain() throws IOException {
        DerValue derValue = this.findAttribute(DOMAIN_COMPONENT_OID);
        return this.getString(derValue);
    }

    public String getDNQualifier() throws IOException {
        DerValue derValue = this.findAttribute(DNQUALIFIER_OID);
        return this.getString(derValue);
    }

    public String getSurname() throws IOException {
        DerValue derValue = this.findAttribute(SURNAME_OID);
        return this.getString(derValue);
    }

    public String getGivenName() throws IOException {
        DerValue derValue = this.findAttribute(GIVENNAME_OID);
        return this.getString(derValue);
    }

    public String getInitials() throws IOException {
        DerValue derValue = this.findAttribute(INITIALS_OID);
        return this.getString(derValue);
    }

    public String getGeneration() throws IOException {
        DerValue derValue = this.findAttribute(GENERATIONQUALIFIER_OID);
        return this.getString(derValue);
    }

    public String getIP() throws IOException {
        DerValue derValue = this.findAttribute(ipAddress_oid);
        return this.getString(derValue);
    }

    @Override
    public String toString() {
        if (this.dn == null) {
            this.generateDN();
        }
        return this.dn;
    }

    public String getRFC1779Name() {
        return this.getRFC1779Name(Collections.emptyMap());
    }

    public String getRFC1779Name(Map<String, String> map) throws IllegalArgumentException {
        if (map.isEmpty()) {
            if (this.rfc1779Dn != null) {
                return this.rfc1779Dn;
            }
            this.rfc1779Dn = this.generateRFC1779DN(map);
            return this.rfc1779Dn;
        }
        return this.generateRFC1779DN(map);
    }

    public String getRFC2253Name() {
        return this.getRFC2253Name(Collections.emptyMap());
    }

    public String getRFC2253Name(Map<String, String> map) {
        if (map.isEmpty()) {
            if (this.rfc2253Dn != null) {
                return this.rfc2253Dn;
            }
            this.rfc2253Dn = this.generateRFC2253DN(map);
            return this.rfc2253Dn;
        }
        return this.generateRFC2253DN(map);
    }

    private String generateRFC2253DN(Map<String, String> map) {
        if (this.names.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(48);
        for (int i = this.names.length - 1; i >= 0; --i) {
            if (i < this.names.length - 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.names[i].toRFC2253String(map));
        }
        return stringBuilder.toString();
    }

    public String getRFC2253CanonicalName() {
        if (this.canonicalDn != null) {
            return this.canonicalDn;
        }
        if (this.names.length == 0) {
            this.canonicalDn = "";
            return this.canonicalDn;
        }
        StringBuilder stringBuilder = new StringBuilder(48);
        for (int i = this.names.length - 1; i >= 0; --i) {
            if (i < this.names.length - 1) {
                stringBuilder.append(',');
            }
            stringBuilder.append(this.names[i].toRFC2253String(true));
        }
        this.canonicalDn = stringBuilder.toString();
        return this.canonicalDn;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    private DerValue findAttribute(ObjectIdentifier objectIdentifier) {
        if (this.names != null) {
            for (int i = 0; i < this.names.length; ++i) {
                DerValue derValue = this.names[i].findAttribute(objectIdentifier);
                if (derValue == null) continue;
                return derValue;
            }
        }
        return null;
    }

    public DerValue findMostSpecificAttribute(ObjectIdentifier objectIdentifier) {
        if (this.names != null) {
            for (int i = this.names.length - 1; i >= 0; --i) {
                DerValue derValue = this.names[i].findAttribute(objectIdentifier);
                if (derValue == null) continue;
                return derValue;
            }
        }
        return null;
    }

    private void parseDER(DerInputStream derInputStream) throws IOException {
        DerValue[] derValueArray = null;
        byte[] byArray = derInputStream.toByteArray();
        try {
            derValueArray = derInputStream.getSequence(5);
        }
        catch (IOException iOException) {
            if (byArray == null) {
                derValueArray = null;
            }
            DerValue derValue = new DerValue(48, byArray);
            byArray = derValue.toByteArray();
            derValueArray = new DerInputStream(byArray).getSequence(5);
        }
        if (derValueArray == null) {
            this.names = new RDN[0];
        } else {
            this.names = new RDN[derValueArray.length];
            for (int i = 0; i < derValueArray.length; ++i) {
                this.names[i] = new RDN(derValueArray[i]);
            }
        }
    }

    @Deprecated
    public void emit(DerOutputStream derOutputStream) throws IOException {
        this.encode(derOutputStream);
    }

    @Override
    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i].encode(derOutputStream2);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }

    public byte[] getEncodedInternal() throws IOException {
        if (this.encoded == null) {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i].encode(derOutputStream2);
            }
            derOutputStream.write((byte)48, derOutputStream2);
            this.encoded = derOutputStream.toByteArray();
        }
        return this.encoded;
    }

    public byte[] getEncoded() throws IOException {
        return (byte[])this.getEncodedInternal().clone();
    }

    private void parseDN(String string, Map<String, String> map) throws IOException {
        RDN rDN;
        String string2;
        if (string == null || string.isEmpty()) {
            this.names = new RDN[0];
            return;
        }
        ArrayList<RDN> arrayList = new ArrayList<RDN>();
        int n = 0;
        int n2 = 0;
        String string3 = string;
        int n3 = 0;
        int n4 = string3.indexOf(44);
        int n5 = string3.indexOf(59);
        while (n4 >= 0 || n5 >= 0) {
            int n6 = n5 < 0 ? n4 : (n4 < 0 ? n5 : Math.min(n4, n5));
            if (n6 >= 0 && (n2 += X500Name.countQuotes(string3, n3, n6)) != 1 && !X500Name.escaped(n6, n3, string3)) {
                string2 = string3.substring(n, n6);
                rDN = new RDN(string2, map);
                arrayList.add(rDN);
                n = n6 + 1;
                n2 = 0;
            }
            n3 = n6 + 1;
            n4 = string3.indexOf(44, n3);
            n5 = string3.indexOf(59, n3);
        }
        string2 = string3.substring(n);
        rDN = new RDN(string2, map);
        arrayList.add(rDN);
        Collections.reverse(arrayList);
        this.names = arrayList.toArray(new RDN[arrayList.size()]);
    }

    private void parseRFC2253DN(String string) throws IOException {
        RDN rDN;
        String string2;
        if (string.isEmpty()) {
            this.names = new RDN[0];
            return;
        }
        ArrayList<RDN> arrayList = new ArrayList<RDN>();
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf(44);
        while (n3 >= 0) {
            if (n3 > 0 && !X500Name.escaped(n3, n2, string)) {
                string2 = string.substring(n, n3);
                rDN = new RDN(string2, "RFC2253");
                arrayList.add(rDN);
                n = n3 + 1;
            }
            n2 = n3 + 1;
            n3 = string.indexOf(44, n2);
        }
        string2 = string.substring(n);
        rDN = new RDN(string2, "RFC2253");
        arrayList.add(rDN);
        Collections.reverse(arrayList);
        this.names = arrayList.toArray(new RDN[arrayList.size()]);
    }

    static int countQuotes(String string, int n, int n2) {
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            if ((string.charAt(i) != '\"' || i != n) && (string.charAt(i) != '\"' || string.charAt(i - 1) == '\\')) continue;
            ++n3;
        }
        return n3;
    }

    private static boolean escaped(int n, int n2, String string) {
        if (n == 1 && string.charAt(n - 1) == '\\') {
            return true;
        }
        if (n > 1 && string.charAt(n - 1) == '\\' && string.charAt(n - 2) != '\\') {
            return true;
        }
        if (n > 1 && string.charAt(n - 1) == '\\' && string.charAt(n - 2) == '\\') {
            int n3 = 0;
            --n;
            while (n >= n2) {
                if (string.charAt(n) == '\\') {
                    ++n3;
                }
                --n;
            }
            return n3 % 2 != 0;
        }
        return false;
    }

    private void generateDN() {
        if (this.names.length == 1) {
            this.dn = this.names[0].toString();
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(48);
        if (this.names != null) {
            for (int i = this.names.length - 1; i >= 0; --i) {
                if (i != this.names.length - 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.names[i].toString());
            }
        }
        this.dn = stringBuilder.toString();
    }

    private String generateRFC1779DN(Map<String, String> map) {
        if (this.names.length == 1) {
            return this.names[0].toRFC1779String(map);
        }
        StringBuilder stringBuilder = new StringBuilder(48);
        if (this.names != null) {
            for (int i = this.names.length - 1; i >= 0; --i) {
                if (i != this.names.length - 1) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(this.names[i].toRFC1779String(map));
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        X500Name x500Name;
        int n = generalNameInterface == null ? -1 : (generalNameInterface.getType() != 4 ? -1 : ((x500Name = (X500Name)generalNameInterface).equals(this) ? 0 : (x500Name.names.length == 0 ? 2 : (this.names.length == 0 ? 1 : (x500Name.isWithinSubtree(this) ? 1 : (this.isWithinSubtree(x500Name) ? 2 : 3))))));
        return n;
    }

    private boolean isWithinSubtree(X500Name x500Name) {
        if (this == x500Name) {
            return true;
        }
        if (x500Name == null) {
            return false;
        }
        if (x500Name.names.length == 0) {
            return true;
        }
        if (this.names.length == 0) {
            return false;
        }
        if (this.names.length < x500Name.names.length) {
            return false;
        }
        for (int i = 0; i < x500Name.names.length; ++i) {
            if (this.names[i].equals(x500Name.names[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        return this.names.length;
    }

    public X500Name commonAncestor(X500Name x500Name) {
        int n;
        if (x500Name == null) {
            return null;
        }
        int n2 = x500Name.names.length;
        int n3 = this.names.length;
        if (n3 == 0 || n2 == 0) {
            return null;
        }
        int n4 = n3 < n2 ? n3 : n2;
        for (n = 0; n < n4; ++n) {
            if (this.names[n].equals(x500Name.names[n])) continue;
            if (n != 0) break;
            return null;
        }
        RDN[] rDNArray = new RDN[n];
        for (int i = 0; i < n; ++i) {
            rDNArray[i] = this.names[i];
        }
        X500Name x500Name2 = null;
        try {
            x500Name2 = new X500Name(rDNArray);
        }
        catch (IOException iOException) {
            return null;
        }
        return x500Name2;
    }

    public X500Principal asX500Principal() {
        if (this.x500Principal == null) {
            try {
                Object[] objectArray = new Object[]{this};
                this.x500Principal = principalConstructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                throw new RuntimeException("Unexpected exception", exception);
            }
        }
        return this.x500Principal;
    }

    public static X500Name asX500Name(X500Principal x500Principal) {
        try {
            X500Name x500Name = (X500Name)principalField.get(x500Principal);
            x500Name.x500Principal = x500Principal;
            return x500Name;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unexpected exception", exception);
        }
    }

    static {
        PrivilegedExceptionAction<Object[]> privilegedExceptionAction = new PrivilegedExceptionAction<Object[]>(){

            @Override
            public Object[] run() throws Exception {
                Class<X500Principal> clazz = X500Principal.class;
                Class[] classArray = new Class[]{X500Name.class};
                Constructor constructor = clazz.getDeclaredConstructor(classArray);
                constructor.setAccessible(true);
                Field field = clazz.getDeclaredField("thisX500Name");
                field.setAccessible(true);
                return new Object[]{constructor, field};
            }
        };
        try {
            Constructor constructor;
            Object[] objectArray = AccessController.doPrivileged(privilegedExceptionAction);
            principalConstructor = constructor = (Constructor)objectArray[0];
            principalField = (Field)objectArray[1];
        }
        catch (Exception exception) {
            throw new InternalError("Could not obtain X500Principal access", exception);
        }
    }
}

