/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.KRBError;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.NetClient;

public final class KdcComm {
    private static int defaultKdcRetryLimit;
    private static int defaultKdcTimeout;
    private static int defaultUdpPrefLimit;
    private static final boolean DEBUG;
    private static final String BAD_POLICY_KEY = "krb5.kdc.bad.policy";
    private static int tryLessMaxRetries;
    private static int tryLessTimeout;
    private static BpType badPolicy;
    private String realm;

    public static void initStatic() {
        int n;
        int n2;
        int n3;
        block11: {
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return Security.getProperty(KdcComm.BAD_POLICY_KEY);
                }
            });
            if (string != null) {
                String[] stringArray = (string = string.toLowerCase(Locale.ENGLISH)).split(":");
                if ("tryless".equals(stringArray[0])) {
                    block10: {
                        if (stringArray.length > 1) {
                            String[] stringArray2 = stringArray[1].split(",");
                            try {
                                n3 = Integer.parseInt(stringArray2[0]);
                                if (stringArray2.length > 1) {
                                    tryLessTimeout = Integer.parseInt(stringArray2[1]);
                                }
                                tryLessMaxRetries = n3;
                            }
                            catch (NumberFormatException numberFormatException) {
                                if (!DEBUG) break block10;
                                System.out.println("Invalid krb5.kdc.bad.policy parameter for tryLess: " + string + ", use default");
                            }
                        }
                    }
                    badPolicy = BpType.TRY_LESS;
                } else {
                    badPolicy = "trylast".equals(stringArray[0]) ? BpType.TRY_LAST : BpType.NONE;
                }
            } else {
                badPolicy = BpType.NONE;
            }
            n2 = -1;
            n = -1;
            n3 = -1;
            try {
                Config config = Config.getInstance();
                String string2 = config.get("libdefaults", "kdc_timeout");
                n2 = KdcComm.parseTimeString(string2);
                string2 = config.get("libdefaults", "max_retries");
                n = KdcComm.parsePositiveIntString(string2);
                string2 = config.get("libdefaults", "udp_preference_limit");
                n3 = KdcComm.parsePositiveIntString(string2);
            }
            catch (Exception exception) {
                if (!DEBUG) break block11;
                System.out.println("Exception in getting KDC communication settings, using default value " + exception.getMessage());
            }
        }
        defaultKdcTimeout = n2 > 0 ? n2 : 30000;
        int n4 = defaultKdcRetryLimit = n > 0 ? n : 3;
        defaultUdpPrefLimit = n3 < 0 ? 1465 : (n3 > 32700 ? 32700 : n3);
        KdcAccessibility.reset();
    }

    public KdcComm(String string) throws KrbException {
        if (string == null && (string = Config.getInstance().getDefaultRealm()) == null) {
            throw new KrbException(60, "Cannot find default realm");
        }
        this.realm = string;
    }

    public byte[] send(byte[] byArray) throws IOException, KrbException {
        int n = this.getRealmSpecificValue(this.realm, "udp_preference_limit", defaultUdpPrefLimit);
        boolean bl = n > 0 && byArray != null && byArray.length > n;
        return this.send(byArray, bl);
    }

    private byte[] send(byte[] byArray, boolean bl) throws IOException, KrbException {
        byte[] byArray2;
        block11: {
            String string;
            if (byArray == null) {
                return null;
            }
            Config config = Config.getInstance();
            if (this.realm == null) {
                this.realm = config.getDefaultRealm();
                if (this.realm == null) {
                    throw new KrbException(60, "Cannot find default realm");
                }
            }
            if ((string = config.getKDCList(this.realm)) == null) {
                throw new KrbException("Cannot get kdc for realm " + this.realm);
            }
            Iterator iterator = KdcAccessibility.list(string).iterator();
            if (!iterator.hasNext()) {
                throw new KrbException("Cannot get kdc for realm " + this.realm);
            }
            byArray2 = null;
            try {
                byArray2 = this.sendIfPossible(byArray, (String)iterator.next(), bl);
            }
            catch (Exception exception) {
                boolean bl2 = false;
                while (iterator.hasNext()) {
                    try {
                        byArray2 = this.sendIfPossible(byArray, (String)iterator.next(), bl);
                        bl2 = true;
                        break;
                    }
                    catch (Exception exception2) {
                    }
                }
                if (bl2) break block11;
                throw exception;
            }
        }
        if (byArray2 == null) {
            throw new IOException("Cannot get a KDC reply");
        }
        return byArray2;
    }

    private byte[] sendIfPossible(byte[] byArray, String string, boolean bl) throws IOException, KrbException {
        try {
            byte[] byArray2 = this.send(byArray, string, bl);
            KRBError kRBError = null;
            try {
                kRBError = new KRBError(byArray2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (kRBError != null) {
                if (kRBError.getErrorCode() == 52) {
                    byArray2 = this.send(byArray, string, true);
                } else if (kRBError.getErrorCode() == 29) {
                    throw new KrbException("A service is not available");
                }
            }
            KdcAccessibility.removeBad(string);
            return byArray2;
        }
        catch (Exception exception) {
            if (DEBUG) {
                System.out.println(">>> KrbKdcReq send: error trying " + string);
                exception.printStackTrace(System.out);
            }
            KdcAccessibility.addBad(string);
            throw exception;
        }
    }

    private byte[] send(byte[] byArray, String string, boolean bl) throws IOException, KrbException {
        int n;
        if (byArray == null) {
            return null;
        }
        int n2 = 88;
        int n3 = this.getRealmSpecificValue(this.realm, "max_retries", defaultKdcRetryLimit);
        int n4 = this.getRealmSpecificValue(this.realm, "kdc_timeout", defaultKdcTimeout);
        if (badPolicy == BpType.TRY_LESS && KdcAccessibility.isBad(string)) {
            if (n3 > tryLessMaxRetries) {
                n3 = tryLessMaxRetries;
            }
            if (n4 > tryLessTimeout) {
                n4 = tryLessTimeout;
            }
        }
        String string2 = null;
        String string3 = null;
        if (string.charAt(0) == '[') {
            n = string.indexOf(93, 1);
            if (n == -1) {
                throw new IOException("Illegal KDC: " + string);
            }
            string2 = string.substring(1, n);
            if (n != string.length() - 1) {
                if (string.charAt(n + 1) != ':') {
                    throw new IOException("Illegal KDC: " + string);
                }
                string3 = string.substring(n + 2);
            }
        } else {
            n = string.indexOf(58);
            if (n == -1) {
                string2 = string;
            } else {
                int n5 = string.indexOf(58, n + 1);
                if (n5 > 0) {
                    string2 = string;
                } else {
                    string2 = string.substring(0, n);
                    string3 = string.substring(n + 1);
                }
            }
        }
        if (string3 != null && (n = KdcComm.parsePositiveIntString(string3)) > 0) {
            n2 = n;
        }
        if (DEBUG) {
            System.out.println(">>> KrbKdcReq send: kdc=" + string2 + (bl ? " TCP:" : " UDP:") + n2 + ", timeout=" + n4 + ", number of retries =" + n3 + ", #bytes=" + byArray.length);
        }
        KdcCommunication kdcCommunication = new KdcCommunication(string2, n2, bl, n4, n3, byArray);
        try {
            byte[] byArray2 = AccessController.doPrivileged(kdcCommunication);
            if (DEBUG) {
                System.out.println(">>> KrbKdcReq send: #bytes read=" + (byArray2 != null ? byArray2.length : 0));
            }
            return byArray2;
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (KrbException)exception;
        }
    }

    private static int parseTimeString(String string) {
        if (string == null) {
            return -1;
        }
        if (string.endsWith("s")) {
            int n = KdcComm.parsePositiveIntString(string.substring(0, string.length() - 1));
            return n < 0 ? -1 : n * 1000;
        }
        return KdcComm.parsePositiveIntString(string);
    }

    private int getRealmSpecificValue(String string, String string2, int n) {
        int n2 = n;
        if (string == null) {
            return n2;
        }
        int n3 = -1;
        try {
            String string3 = Config.getInstance().get("realms", string, string2);
            n3 = string2.equals("kdc_timeout") ? KdcComm.parseTimeString(string3) : KdcComm.parsePositiveIntString(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n3 > 0) {
            n2 = n3;
        }
        return n2;
    }

    private static int parsePositiveIntString(String string) {
        if (string == null) {
            return -1;
        }
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    static {
        DEBUG = Krb5.DEBUG;
        tryLessMaxRetries = 1;
        tryLessTimeout = 5000;
        KdcComm.initStatic();
    }

    private static enum BpType {
        NONE,
        TRY_LAST,
        TRY_LESS;

    }

    static class KdcAccessibility {
        private static Set<String> bads = new HashSet<String>();

        KdcAccessibility() {
        }

        private static synchronized void addBad(String string) {
            if (DEBUG) {
                System.out.println(">>> KdcAccessibility: add " + string);
            }
            bads.add(string);
        }

        private static synchronized void removeBad(String string) {
            if (DEBUG) {
                System.out.println(">>> KdcAccessibility: remove " + string);
            }
            bads.remove(string);
        }

        private static synchronized boolean isBad(String string) {
            return bads.contains(string);
        }

        private static synchronized void reset() {
            if (DEBUG) {
                System.out.println(">>> KdcAccessibility: reset");
            }
            bads.clear();
        }

        private static synchronized List<String> list(String string) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (badPolicy == BpType.TRY_LAST) {
                ArrayList<String> arrayList2 = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (bads.contains(string2)) {
                        arrayList2.add(string2);
                        continue;
                    }
                    arrayList.add(string2);
                }
                arrayList.addAll(arrayList2);
            } else {
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
            }
            return arrayList;
        }
    }

    private static class KdcCommunication
    implements PrivilegedExceptionAction<byte[]> {
        private String kdc;
        private int port;
        private boolean useTCP;
        private int timeout;
        private int retries;
        private byte[] obuf;

        public KdcCommunication(String string, int n, boolean bl, int n2, int n3, byte[] byArray) {
            this.kdc = string;
            this.port = n;
            this.useTCP = bl;
            this.timeout = n2;
            this.retries = n3;
            this.obuf = byArray;
        }

        @Override
        public byte[] run() throws IOException, KrbException {
            byte[] byArray = null;
            for (int i = 1; i <= this.retries; ++i) {
                String string;
                String string2 = string = this.useTCP ? "TCP" : "UDP";
                if (DEBUG) {
                    System.out.println(">>> KDCCommunication: kdc=" + this.kdc + " " + string + ":" + this.port + ", timeout=" + this.timeout + ",Attempt =" + i + ", #bytes=" + this.obuf.length);
                }
                try (NetClient netClient = NetClient.getInstance(string, this.kdc, this.port, this.timeout);){
                    netClient.send(this.obuf);
                    byArray = netClient.receive();
                    break;
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    if (DEBUG) {
                        System.out.println("SocketTimeOutException with attempt: " + i);
                    }
                    if (i != this.retries) continue;
                    byArray = null;
                    throw socketTimeoutException;
                }
            }
            return byArray;
        }
    }
}

