/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.util;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ClassParser;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Method;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.util.AttributeHTML;
import com.sun.org.apache.bcel.internal.util.CodeHTML;
import com.sun.org.apache.bcel.internal.util.ConstantHTML;
import com.sun.org.apache.bcel.internal.util.MethodHTML;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Set;

public class Class2HTML {
    private static String classPackage;
    private static String className;
    private static ConstantPool constantPool;
    private static final Set<String> basicTypes;
    private final JavaClass javaClass;
    private final String dir;

    public static void _main(String[] stringArray) throws IOException {
        int n;
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        ClassParser classParser = null;
        JavaClass javaClass = null;
        String string = null;
        char c = File.separatorChar;
        String string2 = "." + c;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].charAt(0) == '-') {
                if (stringArray[n].equals("-d")) {
                    boolean bl;
                    File file;
                    if (!(string2 = stringArray[++n]).endsWith("" + c)) {
                        string2 = string2 + c;
                    }
                    if ((file = new File(string2)).isDirectory() || (bl = file.mkdirs()) || file.isDirectory()) continue;
                    System.out.println("Tried to create the directory " + string2 + " but failed");
                    continue;
                }
                if (stringArray[n].equals("-zip")) {
                    string = stringArray[++n];
                    continue;
                }
                System.out.println("Unknown option " + stringArray[n]);
                continue;
            }
            stringArray2[n2++] = stringArray[n];
        }
        if (n2 == 0) {
            System.err.println("Class2HTML: No input files specified.");
        } else {
            for (n = 0; n < n2; ++n) {
                System.out.print("Processing " + stringArray2[n] + "...");
                classParser = string == null ? new ClassParser(stringArray2[n]) : new ClassParser(string, stringArray2[n]);
                javaClass = classParser.parse();
                new Class2HTML(javaClass, string2);
                System.out.println("Done.");
            }
        }
    }

    static String referenceClass(int n) {
        String string = constantPool.getConstantString(n, (byte)7);
        string = Utility.compactClassName(string);
        string = Utility.compactClassName(string, classPackage + ".", true);
        return "<A HREF=\"" + className + "_cp.html#cp" + n + "\" TARGET=ConstantPool>" + string + "</A>";
    }

    static String referenceType(String string) {
        String string2 = Utility.compactClassName(string);
        string2 = Utility.compactClassName(string2, classPackage + ".", true);
        int n = string.indexOf(91);
        String string3 = string;
        if (n > -1) {
            string3 = string.substring(0, n);
        }
        if (basicTypes.contains(string3)) {
            return "<FONT COLOR=\"#00FF00\">" + string + "</FONT>";
        }
        return "<A HREF=\"" + string3 + ".html\" TARGET=_top>" + string2 + "</A>";
    }

    static String toHTML(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block6;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block6;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block6;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public Class2HTML(JavaClass javaClass, String string) throws IOException {
        this(javaClass, string, StandardCharsets.UTF_8);
    }

    private Class2HTML(JavaClass javaClass, String string, Charset charset) throws IOException {
        Method[] methodArray = javaClass.getMethods();
        this.javaClass = javaClass;
        this.dir = string;
        className = javaClass.getClassName();
        constantPool = javaClass.getConstantPool();
        int n = className.lastIndexOf(46);
        classPackage = n > -1 ? className.substring(0, n) : "";
        ConstantHTML constantHTML = new ConstantHTML(string, className, classPackage, methodArray, constantPool, charset);
        try (AttributeHTML attributeHTML = new AttributeHTML(string, className, constantPool, constantHTML, charset);){
            new MethodHTML(string, className, methodArray, javaClass.getFields(), constantHTML, attributeHTML, charset);
            this.writeMainHTML(attributeHTML, charset);
            new CodeHTML(string, className, methodArray, constantPool, constantHTML, charset);
        }
    }

    private void writeMainHTML(AttributeHTML attributeHTML, Charset charset) throws FileNotFoundException, UnsupportedEncodingException {
        try (Attribute[] attributeArray = new PrintWriter(this.dir + className + ".html", charset.name());){
            attributeArray.println("<HTML>\n<HEAD><TITLE>Documentation for " + className + "</TITLE></HEAD>\n<FRAMESET BORDER=1 cols=\"30%,*\">\n<FRAMESET BORDER=1 rows=\"80%,*\">\n<FRAME NAME=\"ConstantPool\" SRC=\"" + className + "_cp.html\"\n MARGINWIDTH=\"0\" MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n<FRAME NAME=\"Attributes\" SRC=\"" + className + "_attributes.html\"\n MARGINWIDTH=\"0\" MARGINHEIGHT=\"0\" FRAMEBORDER=\"1\" SCROLLING=\"AUTO\">\n</FRAMESET>\n<FRAMESET BORDER=1 rows=\"80%,*\">\n<FRAME NAME=\"Code\" SRC=\"" + className + "_code.html\"\n MARGINWIDTH=0 MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n<FRAME NAME=\"Methods\" SRC=\"" + className + "_methods.html\"\n MARGINWIDTH=0 MARGINHEIGHT=0 FRAMEBORDER=1 SCROLLING=\"AUTO\">\n</FRAMESET></FRAMESET></HTML>");
        }
        attributeArray = this.javaClass.getAttributes();
        for (int i = 0; i < attributeArray.length; ++i) {
            attributeHTML.writeAttribute(attributeArray[i], "class" + i);
        }
    }

    static {
        basicTypes = new HashSet<String>();
        basicTypes.add("int");
        basicTypes.add("short");
        basicTypes.add("boolean");
        basicTypes.add("void");
        basicTypes.add("char");
        basicTypes.add("byte");
        basicTypes.add("long");
        basicTypes.add("double");
        basicTypes.add("float");
    }
}

