/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.Repository;
import com.sun.org.apache.bcel.internal.classfile.JavaClass;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;

public class ObjectType
extends ReferenceType {
    private final String className;

    public static ObjectType getInstance(String string) {
        return new ObjectType(string);
    }

    public ObjectType(String string) {
        super((byte)14, "L" + Utility.packageToPath(string) + ";");
        this.className = Utility.pathToPackage(string);
    }

    public boolean accessibleTo(ObjectType objectType) throws ClassNotFoundException {
        JavaClass javaClass = Repository.lookupClass(this.className);
        if (javaClass.isPublic()) {
            return true;
        }
        JavaClass javaClass2 = Repository.lookupClass(objectType.className);
        return javaClass2.getPackageName().equals(javaClass.getPackageName());
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ObjectType && ((ObjectType)object).className.equals(this.className);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public int hashCode() {
        return this.className.hashCode();
    }

    @Deprecated
    public boolean referencesClass() {
        try {
            JavaClass javaClass = Repository.lookupClass(this.className);
            return javaClass.isClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean referencesClassExact() throws ClassNotFoundException {
        JavaClass javaClass = Repository.lookupClass(this.className);
        return javaClass.isClass();
    }

    @Deprecated
    public boolean referencesInterface() {
        try {
            JavaClass javaClass = Repository.lookupClass(this.className);
            return !javaClass.isClass();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public boolean referencesInterfaceExact() throws ClassNotFoundException {
        JavaClass javaClass = Repository.lookupClass(this.className);
        return !javaClass.isClass();
    }

    public boolean subclassOf(ObjectType objectType) throws ClassNotFoundException {
        if (this.referencesInterfaceExact() || objectType.referencesInterfaceExact()) {
            return false;
        }
        return Repository.instanceOf(this.className, objectType.className);
    }
}

