/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.Select;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class LOOKUPSWITCH
extends Select {
    LOOKUPSWITCH() {
    }

    public LOOKUPSWITCH(int[] nArray, InstructionHandle[] instructionHandleArray, InstructionHandle instructionHandle) {
        super((short)171, nArray, instructionHandleArray, instructionHandle);
        short s = (short)(9 + this.getMatchLength() * 8);
        super.setLength(s);
        this.setFixedLength(s);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitVariableLengthInstruction(this);
        visitor.visitStackConsumer(this);
        visitor.visitBranchInstruction(this);
        visitor.visitSelect(this);
        visitor.visitLOOKUPSWITCH(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        int n = this.getMatchLength();
        dataOutputStream.writeInt(n);
        for (int i = 0; i < n; ++i) {
            dataOutputStream.writeInt(super.getMatch(i));
            dataOutputStream.writeInt(this.setIndices(i, this.getTargetOffset(super.getTarget(i))));
        }
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        super.initFromFile(byteSequence, bl);
        int n = byteSequence.readInt();
        this.setMatchLength(n);
        short s = (short)(9 + n * 8);
        this.setFixedLength(s);
        short s2 = (short)(n + super.getPadding());
        super.setLength(s2);
        super.setMatches(new int[n]);
        super.setIndices(new int[n]);
        super.setTargets(new InstructionHandle[n]);
        for (int i = 0; i < n; ++i) {
            super.setMatch(i, byteSequence.readInt());
            super.setIndices(i, byteSequence.readInt());
        }
    }
}

