/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.BranchHandle;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InstructionHandle {
    public static final InstructionHandle[] EMPTY_ARRAY = new InstructionHandle[0];
    static final InstructionTargeter[] EMPTY_INSTRUCTION_TARGETER_ARRAY = new InstructionTargeter[0];
    private InstructionHandle next;
    private InstructionHandle prev;
    private Instruction instruction;
    @Deprecated
    protected int i_position = -1;
    private Set<InstructionTargeter> targeters;
    private Map<Object, Object> attributes;

    static InstructionHandle getInstructionHandle(Instruction instruction) {
        return new InstructionHandle(instruction);
    }

    protected InstructionHandle(Instruction instruction) {
        this.setInstruction(instruction);
    }

    public void accept(Visitor visitor) {
        this.instruction.accept(visitor);
    }

    public void addAttribute(Object object, Object object2) {
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>(3);
        }
        this.attributes.put(object, object2);
    }

    @Deprecated
    protected void addHandle() {
    }

    public void addTargeter(InstructionTargeter instructionTargeter) {
        if (this.targeters == null) {
            this.targeters = new HashSet<InstructionTargeter>();
        }
        this.targeters.add(instructionTargeter);
    }

    void dispose() {
        this.prev = null;
        this.next = null;
        this.instruction.dispose();
        this.instruction = null;
        this.i_position = -1;
        this.attributes = null;
        this.removeAllTargeters();
    }

    public Object getAttribute(Object object) {
        if (this.attributes != null) {
            return this.attributes.get(object);
        }
        return null;
    }

    public Collection<Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<Object, Object>(3);
        }
        return this.attributes.values();
    }

    public final Instruction getInstruction() {
        return this.instruction;
    }

    public final InstructionHandle getNext() {
        return this.next;
    }

    public int getPosition() {
        return this.i_position;
    }

    public final InstructionHandle getPrev() {
        return this.prev;
    }

    public InstructionTargeter[] getTargeters() {
        if (!this.hasTargeters()) {
            return EMPTY_INSTRUCTION_TARGETER_ARRAY;
        }
        InstructionTargeter[] instructionTargeterArray = new InstructionTargeter[this.targeters.size()];
        this.targeters.toArray(instructionTargeterArray);
        return instructionTargeterArray;
    }

    public boolean hasTargeters() {
        return this.targeters != null && !this.targeters.isEmpty();
    }

    public void removeAllTargeters() {
        if (this.targeters != null) {
            this.targeters.clear();
        }
    }

    public void removeAttribute(Object object) {
        if (this.attributes != null) {
            this.attributes.remove(object);
        }
    }

    public void removeTargeter(InstructionTargeter instructionTargeter) {
        if (this.targeters != null) {
            this.targeters.remove(instructionTargeter);
        }
    }

    public void setInstruction(Instruction instruction) {
        if (instruction == null) {
            throw new ClassGenException("Assigning null to handle");
        }
        if (this.getClass() != BranchHandle.class && instruction instanceof BranchInstruction) {
            throw new ClassGenException("Assigning branch instruction " + instruction + " to plain handle");
        }
        if (this.instruction != null) {
            this.instruction.dispose();
        }
        this.instruction = instruction;
    }

    final InstructionHandle setNext(InstructionHandle instructionHandle) {
        this.next = instructionHandle;
        return instructionHandle;
    }

    void setPosition(int n) {
        this.i_position = n;
    }

    final InstructionHandle setPrev(InstructionHandle instructionHandle) {
        this.prev = instructionHandle;
        return instructionHandle;
    }

    public Instruction swapInstruction(Instruction instruction) {
        Instruction instruction2 = this.instruction;
        this.instruction = instruction;
        return instruction2;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl) {
        return Utility.format(this.i_position, 4, false, ' ') + ": " + this.instruction.toString(bl);
    }

    protected int updatePosition(int n, int n2) {
        this.i_position += n;
        return 0;
    }
}

