/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.ANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.ASTORE;
import com.sun.org.apache.bcel.internal.generic.ArithmeticInstruction;
import com.sun.org.apache.bcel.internal.generic.ArrayInstruction;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.CHECKCAST;
import com.sun.org.apache.bcel.internal.generic.ClassGen;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.DLOAD;
import com.sun.org.apache.bcel.internal.generic.DSTORE;
import com.sun.org.apache.bcel.internal.generic.FLOAD;
import com.sun.org.apache.bcel.internal.generic.FSTORE;
import com.sun.org.apache.bcel.internal.generic.FieldInstruction;
import com.sun.org.apache.bcel.internal.generic.GETFIELD;
import com.sun.org.apache.bcel.internal.generic.GETSTATIC;
import com.sun.org.apache.bcel.internal.generic.GOTO;
import com.sun.org.apache.bcel.internal.generic.GOTO_W;
import com.sun.org.apache.bcel.internal.generic.IFEQ;
import com.sun.org.apache.bcel.internal.generic.IFGE;
import com.sun.org.apache.bcel.internal.generic.IFGT;
import com.sun.org.apache.bcel.internal.generic.IFLE;
import com.sun.org.apache.bcel.internal.generic.IFLT;
import com.sun.org.apache.bcel.internal.generic.IFNE;
import com.sun.org.apache.bcel.internal.generic.IFNONNULL;
import com.sun.org.apache.bcel.internal.generic.IFNULL;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPEQ;
import com.sun.org.apache.bcel.internal.generic.IF_ACMPNE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPEQ;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPGE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPGT;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPLE;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPLT;
import com.sun.org.apache.bcel.internal.generic.IF_ICMPNE;
import com.sun.org.apache.bcel.internal.generic.ILOAD;
import com.sun.org.apache.bcel.internal.generic.INSTANCEOF;
import com.sun.org.apache.bcel.internal.generic.INVOKEDYNAMIC;
import com.sun.org.apache.bcel.internal.generic.INVOKEINTERFACE;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.INVOKESTATIC;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.ISTORE;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.bcel.internal.generic.InstructionConst;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.InvokeInstruction;
import com.sun.org.apache.bcel.internal.generic.JSR;
import com.sun.org.apache.bcel.internal.generic.JSR_W;
import com.sun.org.apache.bcel.internal.generic.LLOAD;
import com.sun.org.apache.bcel.internal.generic.LSTORE;
import com.sun.org.apache.bcel.internal.generic.LocalVariableInstruction;
import com.sun.org.apache.bcel.internal.generic.MULTIANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.sun.org.apache.bcel.internal.generic.NEWARRAY;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.PUSH;
import com.sun.org.apache.bcel.internal.generic.PUTFIELD;
import com.sun.org.apache.bcel.internal.generic.PUTSTATIC;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;
import com.sun.org.apache.bcel.internal.generic.ReturnInstruction;
import com.sun.org.apache.bcel.internal.generic.StackInstruction;
import com.sun.org.apache.bcel.internal.generic.Type;

public class InstructionFactory {
    private static final String APPEND = "append";
    private static final String FQCN_STRING_BUFFER = "java.lang.StringBuffer";
    private static final String[] shortNames = new String[]{"C", "F", "D", "B", "S", "I", "L"};
    private static final MethodObject[] appendMethodObjects = new MethodObject[]{new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.STRING}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.OBJECT}), null, null, new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.BOOLEAN}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.CHAR}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.FLOAT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.DOUBLE}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.INT}), new MethodObject("java.lang.StringBuffer", "append", Type.STRINGBUFFER, new Type[]{Type.LONG})};
    @Deprecated
    protected ClassGen cg;
    @Deprecated
    protected ConstantPoolGen cp;

    public static ArrayInstruction createArrayLoad(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConst.BALOAD;
            }
            case 5: {
                return InstructionConst.CALOAD;
            }
            case 9: {
                return InstructionConst.SALOAD;
            }
            case 10: {
                return InstructionConst.IALOAD;
            }
            case 6: {
                return InstructionConst.FALOAD;
            }
            case 7: {
                return InstructionConst.DALOAD;
            }
            case 11: {
                return InstructionConst.LALOAD;
            }
            case 13: 
            case 14: {
                return InstructionConst.AALOAD;
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    public static ArrayInstruction createArrayStore(Type type) {
        switch (type.getType()) {
            case 4: 
            case 8: {
                return InstructionConst.BASTORE;
            }
            case 5: {
                return InstructionConst.CASTORE;
            }
            case 9: {
                return InstructionConst.SASTORE;
            }
            case 10: {
                return InstructionConst.IASTORE;
            }
            case 6: {
                return InstructionConst.FASTORE;
            }
            case 7: {
                return InstructionConst.DASTORE;
            }
            case 11: {
                return InstructionConst.LASTORE;
            }
            case 13: 
            case 14: {
                return InstructionConst.AASTORE;
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    private static ArithmeticInstruction createBinaryDoubleOp(char c) {
        switch (c) {
            case '-': {
                return InstructionConst.DSUB;
            }
            case '+': {
                return InstructionConst.DADD;
            }
            case '*': {
                return InstructionConst.DMUL;
            }
            case '/': {
                return InstructionConst.DDIV;
            }
            case '%': {
                return InstructionConst.DREM;
            }
        }
        throw new IllegalArgumentException("Invalid operand " + c);
    }

    private static ArithmeticInstruction createBinaryFloatOp(char c) {
        switch (c) {
            case '-': {
                return InstructionConst.FSUB;
            }
            case '+': {
                return InstructionConst.FADD;
            }
            case '*': {
                return InstructionConst.FMUL;
            }
            case '/': {
                return InstructionConst.FDIV;
            }
            case '%': {
                return InstructionConst.FREM;
            }
        }
        throw new IllegalArgumentException("Invalid operand " + c);
    }

    private static ArithmeticInstruction createBinaryIntOp(char c, String string) {
        switch (c) {
            case '-': {
                return InstructionConst.ISUB;
            }
            case '+': {
                return InstructionConst.IADD;
            }
            case '%': {
                return InstructionConst.IREM;
            }
            case '*': {
                return InstructionConst.IMUL;
            }
            case '/': {
                return InstructionConst.IDIV;
            }
            case '&': {
                return InstructionConst.IAND;
            }
            case '|': {
                return InstructionConst.IOR;
            }
            case '^': {
                return InstructionConst.IXOR;
            }
            case '<': {
                return InstructionConst.ISHL;
            }
            case '>': {
                return string.equals(">>>") ? InstructionConst.IUSHR : InstructionConst.ISHR;
            }
        }
        throw new IllegalArgumentException("Invalid operand " + string);
    }

    private static ArithmeticInstruction createBinaryLongOp(char c, String string) {
        switch (c) {
            case '-': {
                return InstructionConst.LSUB;
            }
            case '+': {
                return InstructionConst.LADD;
            }
            case '%': {
                return InstructionConst.LREM;
            }
            case '*': {
                return InstructionConst.LMUL;
            }
            case '/': {
                return InstructionConst.LDIV;
            }
            case '&': {
                return InstructionConst.LAND;
            }
            case '|': {
                return InstructionConst.LOR;
            }
            case '^': {
                return InstructionConst.LXOR;
            }
            case '<': {
                return InstructionConst.LSHL;
            }
            case '>': {
                return string.equals(">>>") ? InstructionConst.LUSHR : InstructionConst.LSHR;
            }
        }
        throw new IllegalArgumentException("Invalid operand " + string);
    }

    public static ArithmeticInstruction createBinaryOperation(String string, Type type) {
        char c = string.charAt(0);
        switch (type.getType()) {
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionFactory.createBinaryIntOp(c, string);
            }
            case 11: {
                return InstructionFactory.createBinaryLongOp(c, string);
            }
            case 6: {
                return InstructionFactory.createBinaryFloatOp(c);
            }
            case 7: {
                return InstructionFactory.createBinaryDoubleOp(c);
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    public static BranchInstruction createBranchInstruction(short s, InstructionHandle instructionHandle) {
        switch (s) {
            case 153: {
                return new IFEQ(instructionHandle);
            }
            case 154: {
                return new IFNE(instructionHandle);
            }
            case 155: {
                return new IFLT(instructionHandle);
            }
            case 156: {
                return new IFGE(instructionHandle);
            }
            case 157: {
                return new IFGT(instructionHandle);
            }
            case 158: {
                return new IFLE(instructionHandle);
            }
            case 159: {
                return new IF_ICMPEQ(instructionHandle);
            }
            case 160: {
                return new IF_ICMPNE(instructionHandle);
            }
            case 161: {
                return new IF_ICMPLT(instructionHandle);
            }
            case 162: {
                return new IF_ICMPGE(instructionHandle);
            }
            case 163: {
                return new IF_ICMPGT(instructionHandle);
            }
            case 164: {
                return new IF_ICMPLE(instructionHandle);
            }
            case 165: {
                return new IF_ACMPEQ(instructionHandle);
            }
            case 166: {
                return new IF_ACMPNE(instructionHandle);
            }
            case 167: {
                return new GOTO(instructionHandle);
            }
            case 168: {
                return new JSR(instructionHandle);
            }
            case 198: {
                return new IFNULL(instructionHandle);
            }
            case 199: {
                return new IFNONNULL(instructionHandle);
            }
            case 200: {
                return new GOTO_W(instructionHandle);
            }
            case 201: {
                return new JSR_W(instructionHandle);
            }
        }
        throw new IllegalArgumentException("Invalid opcode: " + s);
    }

    public static StackInstruction createDup(int n) {
        return n == 2 ? InstructionConst.DUP2 : InstructionConst.DUP;
    }

    public static StackInstruction createDup_1(int n) {
        return n == 2 ? InstructionConst.DUP2_X1 : InstructionConst.DUP_X1;
    }

    public static StackInstruction createDup_2(int n) {
        return n == 2 ? InstructionConst.DUP2_X2 : InstructionConst.DUP_X2;
    }

    public static LocalVariableInstruction createLoad(Type type, int n) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ILOAD(n);
            }
            case 6: {
                return new FLOAD(n);
            }
            case 7: {
                return new DLOAD(n);
            }
            case 11: {
                return new LLOAD(n);
            }
            case 13: 
            case 14: {
                return new ALOAD(n);
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    public static Instruction createNull(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConst.ACONST_NULL;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConst.ICONST_0;
            }
            case 6: {
                return InstructionConst.FCONST_0;
            }
            case 7: {
                return InstructionConst.DCONST_0;
            }
            case 11: {
                return InstructionConst.LCONST_0;
            }
            case 12: {
                return InstructionConst.NOP;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    public static StackInstruction createPop(int n) {
        return n == 2 ? InstructionConst.POP2 : InstructionConst.POP;
    }

    public static ReturnInstruction createReturn(Type type) {
        switch (type.getType()) {
            case 13: 
            case 14: {
                return InstructionConst.ARETURN;
            }
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return InstructionConst.IRETURN;
            }
            case 6: {
                return InstructionConst.FRETURN;
            }
            case 7: {
                return InstructionConst.DRETURN;
            }
            case 11: {
                return InstructionConst.LRETURN;
            }
            case 12: {
                return InstructionConst.RETURN;
            }
        }
        throw new IllegalArgumentException("Invalid type: " + type);
    }

    public static LocalVariableInstruction createStore(Type type, int n) {
        switch (type.getType()) {
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: {
                return new ISTORE(n);
            }
            case 6: {
                return new FSTORE(n);
            }
            case 7: {
                return new DSTORE(n);
            }
            case 11: {
                return new LSTORE(n);
            }
            case 13: 
            case 14: {
                return new ASTORE(n);
            }
        }
        throw new IllegalArgumentException("Invalid type " + type);
    }

    public static Instruction createThis() {
        return new ALOAD(0);
    }

    private static boolean isString(Type type) {
        return type instanceof ObjectType && ((ObjectType)type).getClassName().equals("java.lang.String");
    }

    public InstructionFactory(ClassGen classGen) {
        this(classGen, classGen.getConstantPool());
    }

    public InstructionFactory(ClassGen classGen, ConstantPoolGen constantPoolGen) {
        this.cg = classGen;
        this.cp = constantPoolGen;
    }

    public InstructionFactory(ConstantPoolGen constantPoolGen) {
        this(null, constantPoolGen);
    }

    public Instruction createAppend(Type type) {
        byte by = type.getType();
        if (InstructionFactory.isString(type)) {
            return this.createInvoke(appendMethodObjects[0], (short)182);
        }
        switch (by) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.createInvoke(appendMethodObjects[by], (short)182);
            }
            case 13: 
            case 14: {
                return this.createInvoke(appendMethodObjects[1], (short)182);
            }
        }
        throw new IllegalArgumentException("No append for this type? " + type);
    }

    public Instruction createCast(Type type, Type type2) {
        if (type instanceof BasicType && type2 instanceof BasicType) {
            byte by = type2.getType();
            int n = type.getType();
            if (by == 11 && (n == 5 || n == 8 || n == 9)) {
                n = 10;
            }
            String string = "com.sun.org.apache.bcel.internal.generic." + shortNames[n - 5] + "2" + shortNames[by - 5];
            Instruction instruction = null;
            try {
                instruction = (Instruction)Class.forName(string).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Could not find instruction: " + string, exception);
            }
            return instruction;
        }
        if (!(type instanceof ReferenceType) || !(type2 instanceof ReferenceType)) {
            throw new IllegalArgumentException("Cannot cast " + type + " to " + type2);
        }
        if (type2 instanceof ArrayType) {
            return new CHECKCAST(this.cp.addArrayClass((ArrayType)type2));
        }
        return new CHECKCAST(this.cp.addClass(((ObjectType)type2).getClassName()));
    }

    public CHECKCAST createCheckCast(ReferenceType referenceType) {
        if (referenceType instanceof ArrayType) {
            return new CHECKCAST(this.cp.addArrayClass((ArrayType)referenceType));
        }
        return new CHECKCAST(this.cp.addClass((ObjectType)referenceType));
    }

    public Instruction createConstant(Object object) {
        PUSH pUSH;
        if (object instanceof Number) {
            pUSH = new PUSH(this.cp, (Number)object);
        } else if (object instanceof String) {
            pUSH = new PUSH(this.cp, (String)object);
        } else if (object instanceof Boolean) {
            pUSH = new PUSH(this.cp, (Boolean)object);
        } else if (object instanceof Character) {
            pUSH = new PUSH(this.cp, (Character)object);
        } else {
            throw new ClassGenException("Illegal type: " + object.getClass());
        }
        return pUSH.getInstruction();
    }

    public FieldInstruction createFieldAccess(String string, String string2, Type type, short s) {
        String string3 = type.getSignature();
        int n = this.cp.addFieldref(string, string2, string3);
        switch (s) {
            case 180: {
                return new GETFIELD(n);
            }
            case 181: {
                return new PUTFIELD(n);
            }
            case 178: {
                return new GETSTATIC(n);
            }
            case 179: {
                return new PUTSTATIC(n);
            }
        }
        throw new IllegalArgumentException("Unknown getfield kind:" + s);
    }

    public GETFIELD createGetField(String string, String string2, Type type) {
        return new GETFIELD(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public GETSTATIC createGetStatic(String string, String string2, Type type) {
        return new GETSTATIC(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public INSTANCEOF createInstanceOf(ReferenceType referenceType) {
        if (referenceType instanceof ArrayType) {
            return new INSTANCEOF(this.cp.addArrayClass((ArrayType)referenceType));
        }
        return new INSTANCEOF(this.cp.addClass((ObjectType)referenceType));
    }

    private InvokeInstruction createInvoke(MethodObject methodObject, short s) {
        return this.createInvoke(methodObject.className, methodObject.name, methodObject.resultType, methodObject.argTypes, s);
    }

    public InvokeInstruction createInvoke(String string, String string2, Type type, Type[] typeArray, short s) {
        return this.createInvoke(string, string2, type, typeArray, s, s == 185);
    }

    public InvokeInstruction createInvoke(String string, String string2, Type type, Type[] typeArray, short s, boolean bl) {
        if (s != 183 && s != 182 && s != 184 && s != 185 && s != 186) {
            throw new IllegalArgumentException("Unknown invoke kind: " + s);
        }
        int n = 0;
        String string3 = Type.getMethodSignature(type, typeArray);
        for (Type type2 : typeArray) {
            n += type2.getSize();
        }
        int n2 = bl ? this.cp.addInterfaceMethodref(string, string2, string3) : this.cp.addMethodref(string, string2, string3);
        switch (s) {
            case 183: {
                return new INVOKESPECIAL(n2);
            }
            case 182: {
                return new INVOKEVIRTUAL(n2);
            }
            case 184: {
                return new INVOKESTATIC(n2);
            }
            case 185: {
                return new INVOKEINTERFACE(n2, n + 1);
            }
            case 186: {
                return new INVOKEDYNAMIC(n2);
            }
        }
        throw new IllegalStateException("Unknown invoke kind: " + s);
    }

    public NEW createNew(ObjectType objectType) {
        return new NEW(this.cp.addClass(objectType));
    }

    public NEW createNew(String string) {
        return this.createNew(ObjectType.getInstance(string));
    }

    public Instruction createNewArray(Type type, short s) {
        if (s == 1) {
            if (type instanceof ObjectType) {
                return new ANEWARRAY(this.cp.addClass((ObjectType)type));
            }
            if (type instanceof ArrayType) {
                return new ANEWARRAY(this.cp.addArrayClass((ArrayType)type));
            }
            return new NEWARRAY(type.getType());
        }
        ArrayType arrayType = type instanceof ArrayType ? (ArrayType)type : new ArrayType(type, (int)s);
        return new MULTIANEWARRAY(this.cp.addArrayClass(arrayType), s);
    }

    public InstructionList createPrintln(String string) {
        InstructionList instructionList = new InstructionList();
        instructionList.append(this.createGetStatic("java.lang.System", "out", Type.getType("Ljava/io/PrintStream;")));
        instructionList.append(new PUSH(this.cp, string));
        MethodObject methodObject = new MethodObject("java.io.PrintStream", "println", Type.VOID, new Type[]{Type.getType("Ljava/lang/String;")});
        instructionList.append(this.createInvoke(methodObject, (short)182));
        return instructionList;
    }

    public PUTFIELD createPutField(String string, String string2, Type type) {
        return new PUTFIELD(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public PUTSTATIC createPutStatic(String string, String string2, Type type) {
        return new PUTSTATIC(this.cp.addFieldref(string, string2, type.getSignature()));
    }

    public ClassGen getClassGen() {
        return this.cg;
    }

    public ConstantPoolGen getConstantPool() {
        return this.cp;
    }

    public void setClassGen(ClassGen classGen) {
        this.cg = classGen;
    }

    public void setConstantPool(ConstantPoolGen constantPoolGen) {
        this.cp = constantPoolGen;
    }

    private static class MethodObject {
        final Type[] argTypes;
        final Type resultType;
        final String className;
        final String name;

        MethodObject(String string, String string2, Type type, Type[] typeArray) {
            this.className = string;
            this.name = string2;
            this.resultType = type;
            this.argTypes = typeArray;
        }
    }
}

