/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantCP;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantDouble;
import com.sun.org.apache.bcel.internal.classfile.ConstantDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantFieldref;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantInterfaceMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantInvokeDynamic;
import com.sun.org.apache.bcel.internal.classfile.ConstantLong;
import com.sun.org.apache.bcel.internal.classfile.ConstantMethodref;
import com.sun.org.apache.bcel.internal.classfile.ConstantNameAndType;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.generic.ArrayType;
import com.sun.org.apache.bcel.internal.generic.MethodGen;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class ConstantPoolGen {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private static final String METHODREF_DELIM = ":";
    private static final String IMETHODREF_DELIM = "#";
    private static final String FIELDREF_DELIM = "&";
    private static final String NAT_DELIM = "%";
    @Deprecated
    protected int size;
    @Deprecated
    protected Constant[] constants;
    @Deprecated
    protected int index = 1;
    private final Map<String, Integer> stringTable = new HashMap<String, Integer>();
    private final Map<String, Integer> classTable = new HashMap<String, Integer>();
    private final Map<String, Integer> utf8Table = new HashMap<String, Integer>();
    private final Map<String, Integer> natTable = new HashMap<String, Integer>();
    private final Map<String, Integer> cpTable = new HashMap<String, Integer>();

    public ConstantPoolGen() {
        this.size = 256;
        this.constants = new Constant[this.size];
    }

    public ConstantPoolGen(Constant[] constantArray) {
        if (constantArray.length > 65535) {
            throw new IllegalStateException("The number of constants " + constantArray.length + " is over the size limit of the constant pool: " + 65535);
        }
        StringBuilder stringBuilder = new StringBuilder(256);
        this.size = Math.min(Math.max(256, constantArray.length + 64), 65535);
        this.constants = new Constant[this.size];
        System.arraycopy(constantArray, 0, this.constants, 0, constantArray.length);
        if (constantArray.length > 0) {
            this.index = constantArray.length;
        }
        for (int i = 1; i < this.index; ++i) {
            Object object;
            Object object2;
            Object object3;
            Constant constant;
            Constant constant2 = this.constants[i];
            if (constant2 instanceof ConstantString) {
                constant = (ConstantString)constant2;
                object3 = (ConstantUtf8)this.constants[((ConstantString)constant).getStringIndex()];
                object2 = ((ConstantUtf8)object3).getBytes();
                if (this.stringTable.containsKey(object2)) continue;
                this.stringTable.put((String)object2, i);
                continue;
            }
            if (constant2 instanceof ConstantClass) {
                constant = (ConstantClass)constant2;
                object3 = (ConstantUtf8)this.constants[((ConstantClass)constant).getNameIndex()];
                object2 = ((ConstantUtf8)object3).getBytes();
                if (this.classTable.containsKey(object2)) continue;
                this.classTable.put((String)object2, i);
                continue;
            }
            if (constant2 instanceof ConstantNameAndType) {
                constant = (ConstantNameAndType)constant2;
                object3 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant).getNameIndex()];
                object2 = (ConstantUtf8)this.constants[((ConstantNameAndType)constant).getSignatureIndex()];
                stringBuilder.append(((ConstantUtf8)object3).getBytes());
                stringBuilder.append(NAT_DELIM);
                stringBuilder.append(((ConstantUtf8)object2).getBytes());
                object = stringBuilder.toString();
                stringBuilder.delete(0, stringBuilder.length());
                if (this.natTable.containsKey(object)) continue;
                this.natTable.put((String)object, i);
                continue;
            }
            if (constant2 instanceof ConstantUtf8) {
                constant = (ConstantUtf8)constant2;
                object3 = ((ConstantUtf8)constant).getBytes();
                if (this.utf8Table.containsKey(object3)) continue;
                this.utf8Table.put((String)object3, i);
                continue;
            }
            if (!(constant2 instanceof ConstantCP)) continue;
            constant = (ConstantCP)constant2;
            if (constant2 instanceof ConstantInvokeDynamic) {
                object3 = Integer.toString(((ConstantInvokeDynamic)constant).getBootstrapMethodAttrIndex());
            } else if (constant2 instanceof ConstantDynamic) {
                object3 = Integer.toString(((ConstantDynamic)constant).getBootstrapMethodAttrIndex());
            } else {
                object = (ConstantClass)this.constants[((ConstantCP)constant).getClassIndex()];
                object2 = (ConstantUtf8)this.constants[((ConstantClass)object).getNameIndex()];
                object3 = Utility.pathToPackage(((ConstantUtf8)object2).getBytes());
            }
            object = (ConstantNameAndType)this.constants[((ConstantCP)constant).getNameAndTypeIndex()];
            object2 = (ConstantUtf8)this.constants[((ConstantNameAndType)object).getNameIndex()];
            String string = ((ConstantUtf8)object2).getBytes();
            object2 = (ConstantUtf8)this.constants[((ConstantNameAndType)object).getSignatureIndex()];
            String string2 = ((ConstantUtf8)object2).getBytes();
            String string3 = METHODREF_DELIM;
            if (constant2 instanceof ConstantInterfaceMethodref) {
                string3 = IMETHODREF_DELIM;
            } else if (constant2 instanceof ConstantFieldref) {
                string3 = FIELDREF_DELIM;
            }
            stringBuilder.append((String)object3);
            stringBuilder.append(string3);
            stringBuilder.append(string);
            stringBuilder.append(string3);
            stringBuilder.append(string2);
            String string4 = stringBuilder.toString();
            stringBuilder.delete(0, stringBuilder.length());
            if (this.cpTable.containsKey(string4)) continue;
            this.cpTable.put(string4, i);
        }
    }

    public ConstantPoolGen(ConstantPool constantPool) {
        this(constantPool.getConstantPool());
    }

    public int addArrayClass(ArrayType arrayType) {
        return this.addClass_(arrayType.getSignature());
    }

    public int addClass(ObjectType objectType) {
        return this.addClass(objectType.getClassName());
    }

    public int addClass(String string) {
        return this.addClass_(Utility.packageToPath(string));
    }

    private int addClass_(String string) {
        int n = this.lookupClass(string);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        ConstantClass constantClass = new ConstantClass(this.addUtf8(string));
        int n2 = this.index;
        this.constants[this.index++] = constantClass;
        return this.computeIfAbsent(this.classTable, string, n2);
    }

    public int addConstant(Constant constant, ConstantPoolGen constantPoolGen) {
        Constant[] constantArray = constantPoolGen.getConstantPool().getConstantPool();
        switch (constant.getTag()) {
            case 8: {
                ConstantString constantString = (ConstantString)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantString.getStringIndex()];
                return this.addString(constantUtf8.getBytes());
            }
            case 7: {
                ConstantClass constantClass = (ConstantClass)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                return this.addClass(constantUtf8.getBytes());
            }
            case 12: {
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constant;
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                ConstantUtf8 constantUtf82 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                return this.addNameAndType(constantUtf8.getBytes(), constantUtf82.getBytes());
            }
            case 1: {
                return this.addUtf8(((ConstantUtf8)constant).getBytes());
            }
            case 6: {
                return this.addDouble(((ConstantDouble)constant).getBytes());
            }
            case 4: {
                return this.addFloat(((ConstantFloat)constant).getBytes());
            }
            case 5: {
                return this.addLong(((ConstantLong)constant).getBytes());
            }
            case 3: {
                return this.addInteger(((ConstantInteger)constant).getBytes());
            }
            case 9: 
            case 10: 
            case 11: {
                ConstantCP constantCP = (ConstantCP)constant;
                ConstantClass constantClass = (ConstantClass)constantArray[constantCP.getClassIndex()];
                ConstantNameAndType constantNameAndType = (ConstantNameAndType)constantArray[constantCP.getNameAndTypeIndex()];
                ConstantUtf8 constantUtf8 = (ConstantUtf8)constantArray[constantClass.getNameIndex()];
                String string = Utility.pathToPackage(constantUtf8.getBytes());
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getNameIndex()];
                String string2 = constantUtf8.getBytes();
                constantUtf8 = (ConstantUtf8)constantArray[constantNameAndType.getSignatureIndex()];
                String string3 = constantUtf8.getBytes();
                switch (constant.getTag()) {
                    case 11: {
                        return this.addInterfaceMethodref(string, string2, string3);
                    }
                    case 10: {
                        return this.addMethodref(string, string2, string3);
                    }
                    case 9: {
                        return this.addFieldref(string, string2, string3);
                    }
                }
                throw new IllegalArgumentException("Unknown constant type " + constant);
            }
        }
        throw new IllegalArgumentException("Unknown constant type " + constant);
    }

    public int addDouble(double d) {
        int n = this.lookupDouble(d);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index] = new ConstantDouble(d);
        this.index += 2;
        return n;
    }

    public int addFieldref(String string, String string2, String string3) {
        int n = this.lookupFieldref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addClass(string);
        int n3 = this.addNameAndType(string2, string3);
        int n4 = this.index;
        this.constants[this.index++] = new ConstantFieldref(n2, n3);
        return this.computeIfAbsent(this.cpTable, string + FIELDREF_DELIM + string2 + FIELDREF_DELIM + string3, n4);
    }

    public int addFloat(float f) {
        int n = this.lookupFloat(f);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index++] = new ConstantFloat(f);
        return n;
    }

    public int addInteger(int n) {
        int n2 = this.lookupInteger(n);
        if (n2 != -1) {
            return n2;
        }
        this.adjustSize();
        n2 = this.index;
        this.constants[this.index++] = new ConstantInteger(n);
        return n2;
    }

    public int addInterfaceMethodref(MethodGen methodGen) {
        return this.addInterfaceMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int addInterfaceMethodref(String string, String string2, String string3) {
        int n = this.lookupInterfaceMethodref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addClass(string);
        int n3 = this.addNameAndType(string2, string3);
        int n4 = this.index;
        this.constants[this.index++] = new ConstantInterfaceMethodref(n2, n3);
        return this.computeIfAbsent(this.cpTable, string + IMETHODREF_DELIM + string2 + IMETHODREF_DELIM + string3, n4);
    }

    public int addLong(long l) {
        int n = this.lookupLong(l);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index] = new ConstantLong(l);
        this.index += 2;
        return n;
    }

    public int addMethodref(MethodGen methodGen) {
        return this.addMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int addMethodref(String string, String string2, String string3) {
        int n = this.lookupMethodref(string, string2, string3);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addNameAndType(string2, string3);
        int n3 = this.addClass(string);
        int n4 = this.index;
        this.constants[this.index++] = new ConstantMethodref(n3, n2);
        return this.computeIfAbsent(this.cpTable, string + METHODREF_DELIM + string2 + METHODREF_DELIM + string3, n4);
    }

    public int addNameAndType(String string, String string2) {
        int n = this.lookupNameAndType(string, string2);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        int n2 = this.addUtf8(string);
        int n3 = this.addUtf8(string2);
        n = this.index;
        this.constants[this.index++] = new ConstantNameAndType(n2, n3);
        return this.computeIfAbsent(this.natTable, string + NAT_DELIM + string2, n);
    }

    public int addString(String string) {
        int n = this.lookupString(string);
        if (n != -1) {
            return n;
        }
        int n2 = this.addUtf8(string);
        this.adjustSize();
        ConstantString constantString = new ConstantString(n2);
        n = this.index;
        this.constants[this.index++] = constantString;
        return this.computeIfAbsent(this.stringTable, string, n);
    }

    public int addUtf8(String string) {
        int n = this.lookupUtf8(string);
        if (n != -1) {
            return n;
        }
        this.adjustSize();
        n = this.index;
        this.constants[this.index++] = new ConstantUtf8(string);
        return this.computeIfAbsent(this.utf8Table, string, n);
    }

    protected void adjustSize() {
        if (this.index + 3 >= 65535) {
            throw new IllegalStateException("The number of constants " + (this.index + 3) + " is over the size limit of the constant pool: " + 65535);
        }
        if (this.index + 3 >= this.size) {
            Constant[] constantArray = this.constants;
            this.size *= 2;
            this.size = Math.min(this.size, 65535);
            this.constants = new Constant[this.size];
            System.arraycopy(constantArray, 0, this.constants, 0, this.index);
        }
    }

    private int computeIfAbsent(Map<String, Integer> map, String string, int n) {
        Integer n2 = map.get(string);
        if (n2 == null) {
            map.put(string, n);
        }
        return n;
    }

    public Constant getConstant(int n) {
        return this.constants[n];
    }

    public ConstantPool getConstantPool() {
        return new ConstantPool(this.constants);
    }

    public ConstantPool getFinalConstantPool() {
        return new ConstantPool(Arrays.copyOf(this.constants, this.index));
    }

    private int getIndex(Map<String, Integer> map, String string) {
        return this.toIndex(map.get(string));
    }

    public int getSize() {
        return this.index;
    }

    public int lookupClass(String string) {
        return this.getIndex(this.classTable, Utility.packageToPath(string));
    }

    public int lookupDouble(double d) {
        long l = Double.doubleToLongBits(d);
        for (int i = 1; i < this.index; ++i) {
            ConstantDouble constantDouble;
            if (!(this.constants[i] instanceof ConstantDouble) || Double.doubleToLongBits((constantDouble = (ConstantDouble)this.constants[i]).getBytes()) != l) continue;
            return i;
        }
        return -1;
    }

    public int lookupFieldref(String string, String string2, String string3) {
        return this.getIndex(this.cpTable, string + FIELDREF_DELIM + string2 + FIELDREF_DELIM + string3);
    }

    public int lookupFloat(float f) {
        int n = Float.floatToIntBits(f);
        for (int i = 1; i < this.index; ++i) {
            ConstantFloat constantFloat;
            if (!(this.constants[i] instanceof ConstantFloat) || Float.floatToIntBits((constantFloat = (ConstantFloat)this.constants[i]).getBytes()) != n) continue;
            return i;
        }
        return -1;
    }

    public int lookupInteger(int n) {
        for (int i = 1; i < this.index; ++i) {
            ConstantInteger constantInteger;
            if (!(this.constants[i] instanceof ConstantInteger) || (constantInteger = (ConstantInteger)this.constants[i]).getBytes() != n) continue;
            return i;
        }
        return -1;
    }

    public int lookupInterfaceMethodref(MethodGen methodGen) {
        return this.lookupInterfaceMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int lookupInterfaceMethodref(String string, String string2, String string3) {
        return this.getIndex(this.cpTable, string + IMETHODREF_DELIM + string2 + IMETHODREF_DELIM + string3);
    }

    public int lookupLong(long l) {
        for (int i = 1; i < this.index; ++i) {
            ConstantLong constantLong;
            if (!(this.constants[i] instanceof ConstantLong) || (constantLong = (ConstantLong)this.constants[i]).getBytes() != l) continue;
            return i;
        }
        return -1;
    }

    public int lookupMethodref(MethodGen methodGen) {
        return this.lookupMethodref(methodGen.getClassName(), methodGen.getName(), methodGen.getSignature());
    }

    public int lookupMethodref(String string, String string2, String string3) {
        return this.getIndex(this.cpTable, string + METHODREF_DELIM + string2 + METHODREF_DELIM + string3);
    }

    public int lookupNameAndType(String string, String string2) {
        return this.getIndex(this.natTable, string + NAT_DELIM + string2);
    }

    public int lookupString(String string) {
        return this.getIndex(this.stringTable, string);
    }

    public int lookupUtf8(String string) {
        return this.getIndex(this.utf8Table, string);
    }

    public void setConstant(int n, Constant constant) {
        this.constants[n] = constant;
    }

    private int toIndex(Integer n) {
        return n != null ? n : -1;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 1; i < this.index; ++i) {
            stringBuilder.append(i).append(")").append(this.constants[i]).append("\n");
        }
        return stringBuilder.toString();
    }
}

