/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.classfile.CodeException;
import com.sun.org.apache.bcel.internal.generic.BranchInstruction;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.InstructionHandle;
import com.sun.org.apache.bcel.internal.generic.InstructionTargeter;
import com.sun.org.apache.bcel.internal.generic.ObjectType;

public final class CodeExceptionGen
implements InstructionTargeter,
Cloneable {
    static final CodeExceptionGen[] EMPTY_ARRAY = new CodeExceptionGen[0];
    private InstructionHandle startPc;
    private InstructionHandle endPc;
    private InstructionHandle handlerPc;
    private ObjectType catchType;

    public CodeExceptionGen(InstructionHandle instructionHandle, InstructionHandle instructionHandle2, InstructionHandle instructionHandle3, ObjectType objectType) {
        this.setStartPC(instructionHandle);
        this.setEndPC(instructionHandle2);
        this.setHandlerPC(instructionHandle3);
        this.catchType = objectType;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
    }

    @Override
    public boolean containsTarget(InstructionHandle instructionHandle) {
        return this.startPc == instructionHandle || this.endPc == instructionHandle || this.handlerPc == instructionHandle;
    }

    public ObjectType getCatchType() {
        return this.catchType;
    }

    public CodeException getCodeException(ConstantPoolGen constantPoolGen) {
        return new CodeException(this.startPc.getPosition(), this.endPc.getPosition() + this.endPc.getInstruction().getLength(), this.handlerPc.getPosition(), this.catchType == null ? 0 : constantPoolGen.addClass(this.catchType));
    }

    public InstructionHandle getEndPC() {
        return this.endPc;
    }

    public InstructionHandle getHandlerPC() {
        return this.handlerPc;
    }

    public InstructionHandle getStartPC() {
        return this.startPc;
    }

    public void setCatchType(ObjectType objectType) {
        this.catchType = objectType;
    }

    public void setEndPC(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.endPc, instructionHandle, this);
        this.endPc = instructionHandle;
    }

    public void setHandlerPC(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.handlerPc, instructionHandle, this);
        this.handlerPc = instructionHandle;
    }

    public void setStartPC(InstructionHandle instructionHandle) {
        BranchInstruction.notifyTarget(this.startPc, instructionHandle, this);
        this.startPc = instructionHandle;
    }

    public String toString() {
        return "CodeExceptionGen(" + this.startPc + ", " + this.endPc + ", " + this.handlerPc + ")";
    }

    @Override
    public void updateTarget(InstructionHandle instructionHandle, InstructionHandle instructionHandle2) {
        boolean bl = false;
        if (this.startPc == instructionHandle) {
            bl = true;
            this.setStartPC(instructionHandle2);
        }
        if (this.endPc == instructionHandle) {
            bl = true;
            this.setEndPC(instructionHandle2);
        }
        if (this.handlerPc == instructionHandle) {
            bl = true;
            this.setHandlerPC(instructionHandle2);
        }
        if (!bl) {
            throw new ClassGenException("Not targeting " + instructionHandle + ", but {" + this.startPc + ", " + this.endPc + ", " + this.handlerPc + "}");
        }
    }
}

