/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.ClassGenException;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.ReferenceType;
import com.sun.org.apache.bcel.internal.generic.Type;

public final class ArrayType
extends ReferenceType {
    private final int dimensions;
    private final Type basicType;

    public ArrayType(byte by, int n) {
        this(BasicType.getType(by), n);
    }

    public ArrayType(String string, int n) {
        this(ObjectType.getInstance(string), n);
    }

    public ArrayType(Type type, int n) {
        super((byte)13, "<dummy>");
        Object object;
        if (n < 1 || n > 255) {
            throw new ClassGenException("Invalid number of dimensions: " + n);
        }
        switch (type.getType()) {
            case 13: {
                object = (ArrayType)type;
                this.dimensions = n + ((ArrayType)object).dimensions;
                this.basicType = ((ArrayType)object).basicType;
                break;
            }
            case 12: {
                throw new ClassGenException("Invalid type: void[]");
            }
            default: {
                this.dimensions = n;
                this.basicType = type;
            }
        }
        object = new StringBuilder();
        for (int i = 0; i < this.dimensions; ++i) {
            ((StringBuilder)object).append('[');
        }
        ((StringBuilder)object).append(this.basicType.getSignature());
        super.setSignature(((StringBuilder)object).toString());
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)object;
            return arrayType.dimensions == this.dimensions && arrayType.basicType.equals(this.basicType);
        }
        return false;
    }

    public Type getBasicType() {
        return this.basicType;
    }

    @Override
    @Deprecated
    public String getClassName() {
        return this.signature;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public Type getElementType() {
        if (this.dimensions == 1) {
            return this.basicType;
        }
        return new ArrayType(this.basicType, this.dimensions - 1);
    }

    @Override
    public int hashCode() {
        return this.basicType.hashCode() ^ this.dimensions;
    }
}

