/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import com.sun.org.apache.bcel.internal.util.Args;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Synthetic
extends Attribute {
    private byte[] bytes;

    public Synthetic(int n, int n2, byte[] byArray, ConstantPool constantPool) {
        super((byte)7, n, Args.require0(n2, "Synthetic attribute length"), constantPool);
        this.bytes = byArray;
    }

    Synthetic(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (byte[])null, constantPool);
        if (n2 > 0) {
            this.bytes = new byte[n2];
            dataInput.readFully(this.bytes);
            Synthetic.println("Synthetic attribute with length > 0");
        }
    }

    public Synthetic(Synthetic synthetic) {
        this(synthetic.getNameIndex(), synthetic.getLength(), synthetic.getBytes(), synthetic.getConstantPool());
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitSynthetic(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        Synthetic synthetic = (Synthetic)this.clone();
        if (this.bytes != null) {
            synthetic.bytes = (byte[])this.bytes.clone();
        }
        synthetic.setConstantPool(constantPool);
        return synthetic;
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        if (super.getLength() > 0) {
            dataOutputStream.write(this.bytes, 0, super.getLength());
        }
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] byArray) {
        this.bytes = byArray;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Synthetic");
        if (super.getLength() > 0) {
            stringBuilder.append(" ").append(Utility.toHexString(this.bytes));
        }
        return stringBuilder.toString();
    }
}

