/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.StackMapType;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class StackMapEntry
implements Node,
Cloneable {
    static final StackMapEntry[] EMPTY_ARRAY = new StackMapEntry[0];
    private int frameType;
    private int byteCodeOffset;
    private StackMapType[] typesOfLocals;
    private StackMapType[] typesOfStackItems;
    private ConstantPool constantPool;

    StackMapEntry(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(dataInput.readByte() & 0xFF, -1, null, null, constantPool);
        if (this.frameType >= 0 && this.frameType <= 63) {
            this.byteCodeOffset = this.frameType - 0;
        } else if (this.frameType >= 64 && this.frameType <= 127) {
            this.byteCodeOffset = this.frameType - 64;
            this.typesOfStackItems = new StackMapType[]{new StackMapType(dataInput, constantPool)};
        } else if (this.frameType == 247) {
            this.byteCodeOffset = dataInput.readUnsignedShort();
            this.typesOfStackItems = new StackMapType[]{new StackMapType(dataInput, constantPool)};
        } else if (this.frameType >= 248 && this.frameType <= 250) {
            this.byteCodeOffset = dataInput.readUnsignedShort();
        } else if (this.frameType == 251) {
            this.byteCodeOffset = dataInput.readUnsignedShort();
        } else if (this.frameType >= 252 && this.frameType <= 254) {
            this.byteCodeOffset = dataInput.readUnsignedShort();
            int n = this.frameType - 251;
            this.typesOfLocals = new StackMapType[n];
            for (int i = 0; i < n; ++i) {
                this.typesOfLocals[i] = new StackMapType(dataInput, constantPool);
            }
        } else if (this.frameType == 255) {
            int n;
            this.byteCodeOffset = dataInput.readUnsignedShort();
            int n2 = dataInput.readUnsignedShort();
            this.typesOfLocals = new StackMapType[n2];
            for (n = 0; n < n2; ++n) {
                this.typesOfLocals[n] = new StackMapType(dataInput, constantPool);
            }
            n = dataInput.readUnsignedShort();
            this.typesOfStackItems = new StackMapType[n];
            for (int i = 0; i < n; ++i) {
                this.typesOfStackItems[i] = new StackMapType(dataInput, constantPool);
            }
        } else {
            throw new ClassFormatException("Invalid frame type found while parsing stack map table: " + this.frameType);
        }
    }

    @Deprecated
    public StackMapEntry(int n, int n2, StackMapType[] stackMapTypeArray, int n3, StackMapType[] stackMapTypeArray2, ConstantPool constantPool) {
        this.byteCodeOffset = n;
        this.typesOfLocals = stackMapTypeArray != null ? stackMapTypeArray : StackMapType.EMPTY_ARRAY;
        this.typesOfStackItems = stackMapTypeArray2 != null ? stackMapTypeArray2 : StackMapType.EMPTY_ARRAY;
        this.constantPool = constantPool;
        if (n2 < 0) {
            throw new IllegalArgumentException("numberOfLocals < 0");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("numberOfStackItems < 0");
        }
    }

    public StackMapEntry(int n, int n2, StackMapType[] stackMapTypeArray, StackMapType[] stackMapTypeArray2, ConstantPool constantPool) {
        this.frameType = n;
        this.byteCodeOffset = n2;
        this.typesOfLocals = stackMapTypeArray != null ? stackMapTypeArray : StackMapType.EMPTY_ARRAY;
        this.typesOfStackItems = stackMapTypeArray2 != null ? stackMapTypeArray2 : StackMapType.EMPTY_ARRAY;
        this.constantPool = constantPool;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitStackMapEntry(this);
    }

    public StackMapEntry copy() {
        int n;
        StackMapEntry stackMapEntry;
        try {
            stackMapEntry = (StackMapEntry)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Clone Not Supported");
        }
        stackMapEntry.typesOfLocals = new StackMapType[this.typesOfLocals.length];
        for (n = 0; n < this.typesOfLocals.length; ++n) {
            stackMapEntry.typesOfLocals[n] = this.typesOfLocals[n].copy();
        }
        stackMapEntry.typesOfStackItems = new StackMapType[this.typesOfStackItems.length];
        for (n = 0; n < this.typesOfStackItems.length; ++n) {
            stackMapEntry.typesOfStackItems[n] = this.typesOfStackItems[n].copy();
        }
        return stackMapEntry;
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.frameType);
        if (this.frameType >= 64 && this.frameType <= 127) {
            this.typesOfStackItems[0].dump(dataOutputStream);
        } else if (this.frameType == 247) {
            dataOutputStream.writeShort(this.byteCodeOffset);
            this.typesOfStackItems[0].dump(dataOutputStream);
        } else if (this.frameType >= 248 && this.frameType <= 250) {
            dataOutputStream.writeShort(this.byteCodeOffset);
        } else if (this.frameType == 251) {
            dataOutputStream.writeShort(this.byteCodeOffset);
        } else if (this.frameType >= 252 && this.frameType <= 254) {
            dataOutputStream.writeShort(this.byteCodeOffset);
            for (StackMapType stackMapType : this.typesOfLocals) {
                stackMapType.dump(dataOutputStream);
            }
        } else if (this.frameType == 255) {
            dataOutputStream.writeShort(this.byteCodeOffset);
            dataOutputStream.writeShort(this.typesOfLocals.length);
            for (StackMapType stackMapType : this.typesOfLocals) {
                stackMapType.dump(dataOutputStream);
            }
            dataOutputStream.writeShort(this.typesOfStackItems.length);
            for (StackMapType stackMapType : this.typesOfStackItems) {
                stackMapType.dump(dataOutputStream);
            }
        } else if (this.frameType < 0 || this.frameType > 63) {
            throw new ClassFormatException("Invalid Stack map table tag: " + this.frameType);
        }
    }

    public int getByteCodeOffset() {
        return this.byteCodeOffset;
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getFrameType() {
        return this.frameType;
    }

    int getMapEntrySize() {
        if (this.frameType >= 0 && this.frameType <= 63) {
            return 1;
        }
        if (this.frameType >= 64 && this.frameType <= 127) {
            return 1 + (this.typesOfStackItems[0].hasIndex() ? 3 : 1);
        }
        if (this.frameType == 247) {
            return 3 + (this.typesOfStackItems[0].hasIndex() ? 3 : 1);
        }
        if (this.frameType >= 248 && this.frameType <= 250 || this.frameType == 251) {
            return 3;
        }
        if (this.frameType >= 252 && this.frameType <= 254) {
            int n = 3;
            for (StackMapType stackMapType : this.typesOfLocals) {
                n += stackMapType.hasIndex() ? 3 : 1;
            }
            return n;
        }
        if (this.frameType != 255) {
            throw new IllegalStateException("Invalid StackMap frameType: " + this.frameType);
        }
        int n = 7;
        for (StackMapType stackMapType : this.typesOfLocals) {
            n += stackMapType.hasIndex() ? 3 : 1;
        }
        for (StackMapType stackMapType : this.typesOfStackItems) {
            n += stackMapType.hasIndex() ? 3 : 1;
        }
        return n;
    }

    public int getNumberOfLocals() {
        return this.typesOfLocals.length;
    }

    public int getNumberOfStackItems() {
        return this.typesOfStackItems.length;
    }

    public StackMapType[] getTypesOfLocals() {
        return this.typesOfLocals;
    }

    public StackMapType[] getTypesOfStackItems() {
        return this.typesOfStackItems;
    }

    private boolean invalidFrameType(int n) {
        return !(n == 247 || n >= 248 && n <= 250 || n == 251 || n >= 252 && n <= 254 || n == 255);
    }

    public void setByteCodeOffset(int n) {
        if (n < 0 || n > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Invalid StackMap offset: " + n);
        }
        if (this.frameType >= 0 && this.frameType <= 63) {
            this.frameType = n > 63 ? 251 : n;
        } else if (this.frameType >= 64 && this.frameType <= 127) {
            this.frameType = n > 63 ? 247 : 64 + n;
        } else if (this.invalidFrameType(this.frameType)) {
            throw new IllegalStateException("Invalid StackMap frameType: " + this.frameType);
        }
        this.byteCodeOffset = n;
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void setFrameType(int n) {
        if (n >= 0 && n <= 63) {
            this.byteCodeOffset = n - 0;
        } else if (n >= 64 && n <= 127) {
            this.byteCodeOffset = n - 64;
        } else if (this.invalidFrameType(n)) {
            throw new IllegalArgumentException("Invalid StackMap frameType");
        }
        this.frameType = n;
    }

    @Deprecated
    public void setNumberOfLocals(int n) {
    }

    @Deprecated
    public void setNumberOfStackItems(int n) {
    }

    public void setTypesOfLocals(StackMapType[] stackMapTypeArray) {
        this.typesOfLocals = stackMapTypeArray != null ? stackMapTypeArray : StackMapType.EMPTY_ARRAY;
    }

    public void setTypesOfStackItems(StackMapType[] stackMapTypeArray) {
        this.typesOfStackItems = stackMapTypeArray != null ? stackMapTypeArray : StackMapType.EMPTY_ARRAY;
    }

    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append("(");
        if (this.frameType >= 0 && this.frameType <= 63) {
            stringBuilder.append("SAME");
        } else if (this.frameType >= 64 && this.frameType <= 127) {
            stringBuilder.append("SAME_LOCALS_1_STACK");
        } else if (this.frameType == 247) {
            stringBuilder.append("SAME_LOCALS_1_STACK_EXTENDED");
        } else if (this.frameType >= 248 && this.frameType <= 250) {
            stringBuilder.append("CHOP ").append(String.valueOf(251 - this.frameType));
        } else if (this.frameType == 251) {
            stringBuilder.append("SAME_EXTENDED");
        } else if (this.frameType >= 252 && this.frameType <= 254) {
            stringBuilder.append("APPEND ").append(String.valueOf(this.frameType - 251));
        } else if (this.frameType == 255) {
            stringBuilder.append("FULL");
        } else {
            stringBuilder.append("UNKNOWN (").append(this.frameType).append(")");
        }
        stringBuilder.append(", offset delta=").append(this.byteCodeOffset);
        if (this.typesOfLocals.length > 0) {
            stringBuilder.append(", locals={");
            for (n = 0; n < this.typesOfLocals.length; ++n) {
                stringBuilder.append(this.typesOfLocals[n]);
                if (n >= this.typesOfLocals.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
        }
        if (this.typesOfStackItems.length > 0) {
            stringBuilder.append(", stack items={");
            for (n = 0; n < this.typesOfStackItems.length; ++n) {
                stringBuilder.append(this.typesOfStackItems[n]);
                if (n >= this.typesOfStackItems.length - 1) continue;
                stringBuilder.append(", ");
            }
            stringBuilder.append("}");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public void updateByteCodeOffset(int n) {
        this.setByteCodeOffset(this.byteCodeOffset + n);
    }
}

